using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using System.Collections.Generic;

namespace NetSNS.Web.manage.user
{
    public partial class EducationEdit : NetSNS.Web.UI.Page.ManagePage
    {
        NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
        NetSNS.BLL.User.Space sp = new NetSNS.BLL.User.Space();
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                if (!IsPostBack)
                {
                    this.txtUserId.Value = Request.QueryString["r"];
                    this.txtID.Value = Request.QueryString["ID"];
                }

                string type = Request.QueryString["Type"];
                if (type == "Edit")
                {
                    UpdateEducation();
                }
                else
                {
                    LoadEducationInfo();
                }
            }
            catch { }
        }

        #region ʼϢ
        public void LoadEducationInfo()
        {
            for(int i=2008;i>=1950;i--)
            {
                string str = i.ToString();
                selYear_0.Items.Add(new ListItem(str, str));
            }
            DataTable dt = us.getEducationByID(int.Parse(this.txtID.Value));
            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    if (selAcademy_0.Items.Count > 0)
                    {
                        for (int j = 0; j < selAcademy_0.Items.Count; j++)
                        {
                            selAcademy_0.Items.RemoveAt(j);
                        }
                    }

                    selAcademy_0.DataSource = sp.getUserInfo(int.Parse(dt.Rows[0]["SchoolID"].ToString()), 15);
                    selAcademy_0.DataTextField = "Name";
                    selAcademy_0.DataValueField = "ID";
                    selAcademy_0.DataBind();

                    selAcademy_0.Value = dt.Rows[0]["AcademyID"].ToString();
                    SelType_0.Value = dt.Rows[0]["DegreeID"].ToString();
                    selYear_0.Value = dt.Rows[0]["MatriculationYear"].ToString();
                    txtSchoolName_0.Value = dt.Rows[0]["SchoolName"].ToString();
                    txtShoolID_0.Value = dt.Rows[0]["SchoolID"].ToString();
                }
            }
        }
        #endregion

        public void UpdateEducation()
        {
            UserEducationInfo uf = new UserEducationInfo();

            uf.UserID = int.Parse(Request.QueryString["r"]);
            uf.ID = int.Parse(Request.QueryString["ID"]);
            uf.DegreeID = int.Parse(Request.QueryString["DegreeID"]);
            uf.SchoolID = int.Parse(Request.QueryString["SchoolID"]);
            uf.AcademyID = int.Parse(Request.QueryString["AcademyID"]);
            uf.MatriculationYear = int.Parse(Request.QueryString["MatriculationYear"]);

            List<NetSNS.Model.UserEducationInfo> listStr = new List<NetSNS.Model.UserEducationInfo>();
            listStr.Add(uf);

            if (us.SaveEducation(listStr) == 1)
            {
                PageRight("޸ĻԱϢɹ!", "EducationList.aspx?r=" + Request.QueryString["r"]);
            }
            else
            {
                PageError("޸ĻԱϢʧ!", "EducationList.aspx?r=" + Request.QueryString["r"]);
            }
        }
    }
}
