using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;

namespace NetSNS.Web.manage.user
{
    public partial class UserBase : NetSNS.Web.UI.Page.ManagePage
    {
        NetSNS.BLL.User.Space sp = new NetSNS.BLL.User.Space();
        NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
        protected void Page_Load(object sender, EventArgs e)
        {
            

            try
            {
                string type = Request.Form["Type"];
                if (type == "City")
                {
                    this.txtUserID.Value = Request.Form["r"];
                    LoadInfo(SelCity, 2, true);
                }
                else
                {
                    if (!IsPostBack)
                    {
                        this.txtUserID.Value = Request.QueryString["r"];
                        LoadInfo();
                        LoadInfo(selVocation, 0, false);
                        LoadInfo(homeprovince, 1, false);
                        LoadInfo(SelCity, 2, false);
                        getLXInfo(int.Parse(this.txtUserID.Value));
                    }
                }
            }
            catch { }
        }

        public void LoadInfo()
        {
            DataTable dt = sp.getConstellation(0);

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    zodiac.DataSource = dt;
                    zodiac.DataTextField = "Name";
                    zodiac.DataValueField = "ID";
                    zodiac.DataBind();
                    zodiac.SelectedIndex = 0;
                }
            }
        }

        #region ȡԱϵϢ
        public void getLXInfo(int UserId)
        {
            NetSNS.Model.UserBasicInfo info = us.GetUserBasic(UserId);
            this.gender.Value = info.Sex.ToString();

            if (info.Birthday.ToShortDateString() == "0001-1-1")
            {
                this.txtBrith.Value = "2008-1-1";
            }
            else
            {
                this.txtBrith.Value = info.Birthday.ToShortDateString();
            }
            this.txtMSN.Value = info.MSN;
            this.txtGTalk.Value =info.GTalk;
            this.txtQQ.Value = info.QQ;
            this.txtSkype.Value = info.Skype;
            this.txtMobile.Value = info.Mobile;
            this.txtTel.Value = info.Tel;
            this.txtAddress.Value =info.Addr;
            this.txtHttp.Value =info.WebSite;
            this.birthPrivacy.Value = info.BirthidayDisplay.ToString();
            this.selVocation.Value = info.Vocation.ToString();
            this.homeprovince.Value = info.HomeProv.ToString();
            this.SelCity.Value = info.HomeCity.ToString();
        }
        #endregion

        #region ޸ĻԱϢ
        protected void Button1_Click(object sender, EventArgs e)
        {
            UserBasicInfo uf = new UserBasicInfo();

            uf.UserID = int.Parse(Request.Form["txtUserID"]);
            uf.Sex = int.Parse(Request.Form["gender"]);
            uf.Birthday =Convert.ToDateTime(Request.Form["txtBrith"]);
            uf.Constellation = int.Parse(Request.Form["zodiac"]);
            uf.MSN = this.txtMSN.Value;
            uf.QQ = this.txtQQ.Value;
            uf.Skype = this.txtSkype.Value;
            uf.Tel = this.txtTel.Value;
            uf.WebSite = this.txtHttp.Value;
            uf.Mobile = this.txtMobile.Value;
            uf.GTalk = this.txtGTalk.Value;
            uf.Addr = this.txtAddress.Value;
            uf.BirthidayDisplay = int.Parse(Request.Form["birthPrivacy"]);
            uf.Vocation = int.Parse(Request.Form["selVocation"]);
            uf.HomeProv = int.Parse(Request.Form["homeprovince"]);
            uf.HomeCity = int.Parse(Request.Form["SelCity"]);

            if (us.UpdateUserBase(uf) == 1)
            {
                PageRight("޸ĻԱϢɹ!", "UserList.aspx");
            }
            else
            {
                PageError("޸ĻԱϢʧ!", "UserList.aspx");
            }
        }
        #endregion


        public void LoadInfo(HtmlSelect select, int i, bool bl)
        {
            DataTable dt = null;
            if (i == 0)//ҵ
            {
                dt = sp.getConstellation(2);
            }
            else if (i == 1)//ʡ
            {
                dt = sp.getConstellation(1);
            }
            else if (i == 2)//
            {
                int id;
                try
                {
                    id = int.Parse(Request.Form["id"]);
                }
                catch
                {
                    id = int.Parse(this.homeprovince.Value);
                }
                dt = sp.getUserInfo(id, 14);
            }
            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    string str = "";
                    if (bl)
                    {
                        for (int j = 0; j < dt.Rows.Count; j++)
                        {
                            str += dt.Rows[j]["ID"].ToString() + "," + dt.Rows[j]["Name"].ToString() + "|";
                        }
                        Response.Write(str);
                        Response.End();
                    }
                    else
                    {
                        select.DataSource = dt;
                        select.DataTextField = "Name";
                        select.DataValueField = "ID";
                        select.DataBind();
                        select.SelectedIndex = 0;
                    }
                }
            }
        }
    }
}
