using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;

namespace NetSNS.Web.manage.user
{
    public partial class UserEdit : NetSNS.Web.UI.Page.ManagePage
    {
        NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
        NetSNS.BLL.User.Space sp = new NetSNS.BLL.User.Space();
        protected void Page_Load(object sender, EventArgs e)
        {
            this.txtUserID.Value = Request.QueryString["r"];

            try
            {
                string type = Request.Form["Type"];
                if (type == "City")
                {
                    LoadInfo(this.DrpCity, 2, true);
                }
                else
                {
                    if (!Page.IsPostBack)
                    {
                        getInfo();
                    }
                }
            }
            catch { }
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            string id = Request.QueryString["r"];
            if (id == null || id == "")
                PageError("ݴ!", "Userlist.aspx");

            NetSNS.Model.UserInfo info = us.GetUserInfo(int.Parse(id));

            LoadInfo(this.DrpProvince,1,false);// ʡ
            this.DrpProvince.Value = info.Province.ToString();
            LoadInfo(this.DrpCity,2,false);//
           
            this.txtEmail.Text= info.Email;
            this.txtName.Text = info.Username;
            this.DrpCity.Value = info.City.ToString();
            this.spanLoginNumber.InnerHtml = info.LoginTimes.ToString();
            this.spanLastLoginTime.InnerHtml = info.LastLoginTime.ToString();
            this.spanLastLoginIP.InnerHtml = info.LastLoginIp;
            this.spanRegTime.InnerHtml = info.RegTime.ToString();
            this.spanRegIP.InnerHtml = info.RegIP;
            this.txthidPwd.Value = info.Password;

            switch (info.State)
            {
                case EnumUserState.Register:
                    this.radState.SelectedValue ="0";
                    break;
                case EnumUserState.Lock:
                    this.radState.SelectedValue="1";
                    break;
                case EnumUserState.Normal:
                    this.radState.SelectedValue="5";
                    break;     
            }
        }

        public void LoadInfo(HtmlSelect select, int i,bool bl)
        {
            DataTable dt = null;
            if (i == 1)//ʡ
            {
                dt = sp.getConstellation(1);
            }
            else if (i == 2)//
            {
                int id;
                try
                {
                    id = int.Parse(Request.Form["id"]);
                }
                catch
                {
                    id = int.Parse(this.DrpProvince.Value);
                }
                dt = sp.getUserInfo(id, 14);
            }
            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    if (bl)
                    {
                        string str = "";
                        for (int j = 0; j < dt.Rows.Count; j++)
                        {
                            str += dt.Rows[j]["ID"].ToString() + "," + dt.Rows[j]["Name"].ToString() + "|";
                        }
                        Response.Write(str);
                        Response.End();
                    }
                    else
                    {
                        select.DataSource = dt;
                        select.DataTextField = "Name";
                        select.DataValueField = "ID";
                        select.DataBind();
                        select.SelectedIndex = 0;
                    }
                }
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            UserInfo uf = new UserInfo();

            uf.Email = this.txtEmail.Text;
            uf.Username = this.txtName.Text;
            uf.State = (EnumUserState)int.Parse(this.radState.SelectedValue);
            uf.Province = int.Parse(Request.Form["DrpProvince"]);
            uf.City = int.Parse(Request.Form["DrpCity"]);
            if (this.txtPwd.Text == "")
            {
                uf.Password = this.txthidPwd.Value;
            }
            else
            {
                uf.Password = NetSNS.Common.Input.MD5(this.txtPwd.Text.Trim(), false);
            }

            if (us.UpdateUser(uf, int.Parse(this.txtUserID.Value)) == 1)
            {
                PageRight("޸ĻԱϢɹ!", "UserList.aspx");
            }
            else
            {
                PageError("޸ĻԱϢʧ!", "UserList.aspx");
            }
        }
    }
}
