using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.Web.passport
{
    public partial class hr : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            passpost();
        }

        protected void passpost()
        {
            string type = Request.QueryString["Type"];
            string uid = Request.QueryString["UserID"];
            string HeadType = Request.QueryString["HeadType"];
            string FriendID = Request.QueryString["FriendID"];
            string pass = Request.QueryString["pass"];

            NetSNS.BLL.User.User user = new NetSNS.BLL.User.User();
            NetSNS.Model.UserInfo userinfo = new NetSNS.Model.UserInfo();

            switch (type)
            {
                case "Email":
                    userinfo = user.GetUserInfo(Convert.ToInt32(uid));
                    Response.Write(userinfo.Email);
                    Response.End();
                    break;
                case "Name":
                    userinfo = user.GetUserInfo(Convert.ToInt32(uid));
                    Response.Write(userinfo.Username);
                    Response.End();
                    break;
                case "HeadIMG":
                    Response.Write(GetHeadImage(Convert.ToInt32(uid), Convert.ToInt32(HeadType)));
                    Response.End();
                    break;
                case "Relation":
                    NetSNS.BLL.User.Friend friend = new NetSNS.BLL.User.Friend();
                    Response.Write(friend.GetRelation(Convert.ToInt32(uid), Convert.ToInt32(FriendID)));
                    Response.End();
                    break;
                case "Login":
                    NetSNS.Model.EnumLoginState state = user.CheckLogin(Convert.ToInt32(uid), pass);
                    Response.Write(state.ToString());
                    Response.End();
                    break;
                case "LetterCnt":
                    NetSNS.BLL.User.Letter letter = new NetSNS.BLL.User.Letter();
                    Response.Write(letter.InBoxCount(Convert.ToInt32(uid)));
                    Response.End();
                    break;
                case "getNoti":
                    Response.Write(getNoti(Convert.ToInt32(uid)));
                    Response.End();
                    break;
            }
        }

        /// <summary>
        /// ȡ֪ͨ
        /// </summary>
        /// <param name="UserID">û</param>
        /// <returns></returns>
        protected string getNoti(int UserID)
        {
            UserIndex UIndex = new UserIndex();
            string listStr = string.Empty;
            int GetNoticeCount = UIndex.NoticeInfo(UserID);
            bool isValue = false;
            string HeadPicStr = this.GetHeadImage(UserID, 1);
            if ((HeadPicStr.Substring((HeadPicStr.LastIndexOf("/") + 1))).ToLower() == "default.jpg")
            {
                listStr += "<a href=\"@SNSURL/user/Space/UserHeadPhoto.aspx\"><img src=\"/images/ico/warn.gif\" title=\"δͷ񣬸Ͽȥͷ\" /></a>";
                isValue = true;
            }
            if (GetNoticeCount > 0)
            {
                listStr += "<li><img src=\"/images/ico-noti.gif\" alt=\"֪ͨ\" /> <a href=\"@SNSURL/user/letter/notice.aspx\"><b style-\"color:Red;\">" + GetNoticeCount + "</b>֪ͨ</a></li>";
                isValue = true;
            }
            int GetFriendCount = UIndex.FriendRequest(UserID, 1);
            int GetGroupCount = UIndex.FriendRequest(UserID, 3);
            if (GetFriendCount > 0)
            {
                listStr += "<li>&nbsp; <img border=\"0\" src=\"/images/f_icon.gif\" /> <a href=\"@SNSURL/user/friend/frdconfirm.aspx\"><b>" + GetFriendCount + "</b></a></li>";
                isValue = true;
            }
            if (GetGroupCount > 0)
            {
                listStr += "<li>&nbsp; <img border=\"0\" src=\"/images/group-icon.gif\" /> <a href=\"@SNSURL/user/group/groupreq.aspx\"><b>" + GetGroupCount + "</b>Ⱥ</a></li>";
                isValue = true;
            }
            if (!isValue)
            {
                listStr += "<li></li>";
            }
            return "<ul>" + listStr + "</ul>";
        }


        /// <summary>
        /// ȡͷ
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <param name="size">ͼ</param>
        /// <returns>ͷ·</returns>
        protected string GetHeadImage(int userid, int size)
        {
            NetSNS.BLL.User.User u = new NetSNS.BLL.User.User();
            UserInfo ui = u.GetUserInfo(userid);
            NetSNS.BLL.User.Photo p = new NetSNS.BLL.User.Photo();
            PhotoInfo pi = p.Info(ui.Portrait);
            return GetSmallHeadPic(pi.FilePath, size);
        }

        /// <summary>
        /// תͷ·Ϊ·
        /// </summary>
        /// <param name="orgPicPath">ԭʼ·</param>
        /// <param name="size">С</param>
        /// <returns></returns>
        public string GetSmallHeadPic(object orgHeadPicPath, int size)
        {
            if (orgHeadPicPath == null || orgHeadPicPath == DBNull.Value)
                return GetSmallHeadPic((object)"default.jpg", size);
            if (orgHeadPicPath.ToString().Trim() == "")
                return GetSmallHeadPic((object)"default.jpg", size);
            string name = size.ToString();
            Dictionary<string, PicConfigInfo> _portrait = PicConfig.Portrait;
            string rvalue = string.Empty;
            try
            {
                rvalue = (string)orgHeadPicPath;
            }
            catch { }
            if (rvalue.Trim() == string.Empty)
                return string.Empty;
            if (_portrait[name].Directory.EndsWith("/"))
            {
                rvalue = _portrait[name].Directory + rvalue;
            }
            else
            {
                rvalue = _portrait[name].Directory + "/" + rvalue;
            }
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            if (PicConfig.ProtraitServer != "~" && PicConfig.ProtraitServer != "")
            {
                return PicConfig.ProtraitServer + "/" + rvalue;
            }
            return "/" + rvalue;
        }
    }
}
