﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Collections.Generic;
using NetSNS.Model;
using NetSNS.BLL.User;
using NetSNS.DALProfile;
using System.Net;
using NetSNS.DALSQLServer;
namespace NetSNS.Web.passport
{
    public partial class _interface : System.Web.UI.Page
    {
        /// <summary>
        /// 配置文件
        /// </summary>
        protected Dictionary<string, string> Config; 
        /// <summary>
        /// 配置文件路径
        /// </summary>
        protected string ConfigPath = "/passport/config/passport.config";
        /// <summary>
        /// 用户信息XML路径
        /// </summary>
        protected string UserXMLPath = "/passport/config/user.xml";
        /// <summary>
        /// 用户信息XML
        /// </summary>
        protected XmlDocument UserXML;
        /// <summary>
        /// 回馈信息 appid
        /// </summary>
        protected string appid = string.Empty;
        /// <summary>
        /// 回馈信息状态， 0成功， 1失败
        /// </summary>
        protected int status = 0;
        /// <summary>
        /// 是否需要cookie
        /// </summary>
        protected string needcookie = string.Empty;
        /// <summary>
        /// 信息
        /// </summary>
        protected string message = string.Empty;
        /// <summary>
        /// 接口发送过来的XML
        /// </summary>
        protected XmlDocument RequestXML;
        /// <summary>
        /// 当前email
        /// </summary>
        protected string email = string.Empty;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected string username = string.Empty;
        /// <summary>
        /// 页面初始化
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Page_Load(object sender, EventArgs e)
        {
            DbHelper.Provider = new DbBase();
            setConfig();
            appid = Config["APPID"];
            UserXML = new XmlDocument();
            UserXML.Load(Server.MapPath(UserXMLPath));
            setRequestXML();
            string email=string.Empty;
            string username=string.Empty;
            string password = string.Empty;
            string action = string.Empty;
            if (!String.IsNullOrEmpty(Request.QueryString["syskey"]))
            {
                email = Request.QueryString["email"];
                password = Request.QueryString["password"];
                if (string.IsNullOrEmpty(password) || string.IsNullOrEmpty(email))
                {
                    Logout();
                }
                else
                {
                    Login();
                }
            }
            else
            {
                if (!Available())
                {
                    status = 1;
                    message = "验证不成功！";
                    Xmlwrite();
                }
                try
                {
                    action = RequestXML.SelectSingleNode("root/action").InnerText;
                    email = RequestXML.SelectSingleNode("root/email").InnerText;
                    password = RequestXML.SelectSingleNode("root/password").InnerText;
                    username = RequestXML.SelectSingleNode("root/username").InnerText;
                }
                catch { }
                this.email = email;
                this.username = username;
                switch (action)
                {
                    case "reguser":
                        RegUser();
                        break;
                    case "getinfo":
                        UserInfo();
                        break;
                    default:
                        status = 1;
                        message = "参数非法，操作中止！";
                        break;
                }
            }
            Xmlwrite();
        }
        /// <summary>
        /// 登陆
        /// </summary>
        private void Login()
        {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc = RequestXML;
            string password = string.Empty, email = string.Empty, savecookie = string.Empty, md5password=string.Empty;
            try
            {
                password = Request.QueryString["password"];
                email = Request.QueryString["email"];
                savecookie = Request.QueryString["savecookie"];
                md5password = Request.QueryString["md5password"];
            }
            catch { }
            int savedays = 0;
            if (string.IsNullOrEmpty(savecookie)) savecookie = "0";
            switch (int.Parse(savecookie))
            {
                case 0:
                    {
                        savedays = 0;
                        break;
                    }
                case 1:
                    {
                        savedays = 7;
                        break;
                    }
                case 2:
                    {
                        savedays = 30;
                        break;
                    }
                case 3:
                    {
                        savedays = 365;
                        break;
                    }
                default:
                    {
                        savedays = 0;
                        break;
                    }
            }

            if (!string.IsNullOrEmpty(md5password))
            {
                string Sql = "select UserID,UserName,Password,State,Portrait from NT_User where Email='" + email + "' and password='" + md5password + "'";
                IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    Sql = "select FilePath from NT_Photo where PhotoID=" + rd["Portrait"];
                    string portrait="";
                    try
                    {
                        portrait = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
                    }
                    catch { }
                    NetSNS.Web.UI.Page.UserPage.SetCookie(Convert.ToInt32(rd["userid"]), Convert.ToString(rd["UserName"]), md5password, portrait, false);
                }
                else
                {
                    status = 1;
                    message = "Password error.";
                    rd.Close();
                    return;
                }
               
                status = 0;
                message = "Login Successed.";
                rd.Close();
                return;
            }
            if (!CheckLogin(SqlEncode(email), password, savedays))
            {
                status = 1;
                return;
            }
            status = 0;
            message = "Login Successed.";
        }
        /// <Summary>
        /// 用户登录
        /// </Summary>
        private bool CheckLogin(string email, string password, int saveDays)
        {
            if (email == null || password == null
                   || email == string.Empty || password == string.Empty)
            {
                status = 1;
                message = "登陆参数错误";
                return false;
            }
            else
            {
                int userId = 0;
                string userName = string.Empty;
                string userPortrait = string.Empty;
                BLL.User.User us = new NetSNS.BLL.User.User();
                EnumLoginState state = us.Login(email, password, out userId, out userName, out userPortrait);
                switch (state)
                {
                    case EnumLoginState.Succeed:
                        NetSNS.Web.UI.Page.UserPage.SetCookie(userId, userName, NetSNS.Common.Input.MD5(password, false), userPortrait, false);
                        status = 0;
                        message = "登陆成功";
                        return true;
                    case EnumLoginState.Err_UnActivation:
                        status = 1;
                        message = "邮件没有通过电子邮件激活";
                        return false;
                    case EnumLoginState.Err_NameOrPwdError:
                        status = 1;
                        message = "用户名或密码错误";
                        return false;
                    case EnumLoginState.Err_Locked:
                        message = "对不起，您的帐号已经被系统锁定，如有疑问，请与管理员联系";
                        status = 1;
                        return false;
                    default:
                        status = 1;
                        message = "登陆参数错误";
                        return false;
                }
            }

        }

        /// <summary>
        /// 退出
        /// </summary>
        private void Logout()
        {
            HttpCookie cookieToken = new HttpCookie("SnsUserToken");
            if (cookieToken != null)
            {
                cookieToken.Expires.AddMilliseconds(0.1);
                Response.Cookies.Add(cookieToken);
            }
            status = 0;
            message = "Logout Successed.";
        }

        /// <summary>
        /// 取得用户信息
        /// </summary>
        private void UserInfo()
        {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.LoadXml("<?xml version=\"1.0\" encoding=\"utf-8\" ?><root><appid>netsns</appid><status>0</status><syskey /><body><username /><password /><email /><question /><answer /><savecookie /><gender /><qq /><msn /><telephone /><homepage /><userip /><truename /><nickname /><birthday /><userstatus /><province /><city /><address /><message /></body></root>");
            string sql = "select * from Nt_user a LEFT OUTER join  Nt_userinfo b on  b.userid=a.userid where a.email='" + SqlEncode(email) + "' or username='" + SqlEncode(username) + "'";
            DataTable dt= DbHelper.ExecuteTable(CommandType.Text,sql,null);
            if (dt.Rows.Count < 1)
            {
                status = 1;
                message = "所查询的用户不存在！";
                Xmlwrite();
            }
            else
            {
                DataRow Rs = dt.NewRow();
                Rs = dt.Rows[0];
                string sss = Convert.ToString(Rs["Email"]);
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/email").InnerText = Convert.ToString(Rs["Email"]);
                }
                catch { }
                  //性别反置
                if (Rs["Sex"].ToString() == "1")
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/gender").InnerText = "0";
                }
                else if (Rs["Sex"].ToString() == "0")
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/gender").InnerText = "1";
                }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/homepage").InnerText = Rs["website"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/password").InnerText = Rs["password"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/qq").InnerText = Rs["qq"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/msn").InnerText = Rs["msn"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/telephone").InnerText = Rs["Tel"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/mobile").InnerText = Rs["mobile"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/address").InnerText = Rs["Addr"].ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/province").InnerText = getAreaName(Convert.ToInt32(Rs["province"])).ToString();
                    xmlDoc.DocumentElement.SelectSingleNode("body/city").InnerText = getAreaName(Convert.ToInt32(Rs["city"])).ToString();
                }
                catch { }
                try
                {
                    xmlDoc.DocumentElement.SelectSingleNode("body/userip").InnerText = Rs["LastLoginIP"].ToString();
                }
                catch { }

                int t = 0;
                // 0-正常 1-锁定 2-屏蔽
                if (Rs["state"].ToString() == "1")
                {
                    t = 1;
                }

                xmlDoc.DocumentElement.SelectSingleNode("body/userstatus").InnerText = t.ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/truename").InnerText = Rs["username"].ToString();
                xmlDoc.DocumentElement.SelectSingleNode("body/nickname").InnerText = Rs["username"].ToString();
            }
            Response.Write(xmlDoc.OuterXml);
            dt.Dispose();
            Response.End();
        }
        /// <summary>
        /// 注册用户
        /// </summary>
        private void RegUser()
        {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc = UserXML;
            string siteID = "0";
            string password, email, username, sex, province, city;
            try
            {
                username = SqlEncode(RequestXML.SelectSingleNode("root/username").InnerText).Trim();
                email = SqlEncode(RequestXML.SelectSingleNode("root/email").InnerText).Trim();
                password = RequestXML.SelectSingleNode("root/password").InnerText.Trim();
                sex = RequestXML.SelectSingleNode("root/gender").InnerText.Trim();
                province = RequestXML.SelectSingleNode("root/province").InnerText.Trim();
                city = RequestXML.SelectSingleNode("root/city").InnerText.Trim();
            }
            catch
            {
                status = 1;
                message = "参数非法，操作失败！";
                return;
            }
            // 0为男性，1为女性
            if (sex == "0")
                sex = "1";
            else
                sex = "0";

            if (password == "")
            {
                status = 1;
                message = "参数非法，操作失败！";
                return;
            }
            EnumRegister ret;
            try
            {
                UserInfo ui = new UserInfo();
                ui.Email = email;
                ui.Username = username;
                ui.Password = password;
                try
                {
                    ui.Province = getAreaID(province);
                    ui.City = getAreaID(city);
                }
                catch { }
                NetSNS.BLL.User.User User = new NetSNS.BLL.User.User();
                ret = User.Register(ui);
            }
            catch
            {
                status = 1;
                message = "注册程序错误！";
                return;
            }
            if (ret == EnumRegister.Succeed)
            {
                status = 0;
                message = "注册成功！";
            }
            else if (ret == EnumRegister.EmailRepeat)
            {
                status = 1;
                message = "该Email地址已注册过帐户";
            }
            else if (ret == EnumRegister.EmailMayNotSend)
            {
                status = 0;
                message = "你已经成功注册,请你稍后检查邮箱,如果没有收到帐号确认邮件,请与客服联系";
            }
            else
            {
                status = 1;
                message = "系统错误,请稍后再试";
            }
        }

        /// <summary>
        /// 设置配置文件
        /// </summary>
        private void setConfig()
        {
            System.Xml.XmlDocument xdoc = new XmlDocument();
            xdoc.Load(Server.MapPath(this.ConfigPath));
            XmlElement root = xdoc.DocumentElement;

            Dictionary<string, string> dic = new Dictionary<string, string>();
            XmlNodeList xnl = root.GetElementsByTagName("Item");
            for (int i = 0; i < xnl.Count; i++)
            {
                dic.Add(xnl[i].ChildNodes.Item(0).InnerXml, xnl[i].ChildNodes.Item(1).InnerXml);
            }
            this.Config = dic;
        }
        /// <summary>
        /// 设置RequestXML
        /// </summary>
        private void setRequestXML()
        {
            XmlTextReader reader = null;
            try
            {
                reader = new XmlTextReader(Request.InputStream);
                RequestXML = new XmlDocument();
                RequestXML.Load(reader);
            }
            catch
            {
                RequestXML = null;
            }
            finally
            {
                if (null != reader)
                {
                    reader.Close();
                    reader = null;
                }
            }
        }

        /// <summary>
        /// sql编码
        /// </summary>
        /// <param name="sqlString">sql语句</param>
        /// <returns></returns>
        private string SqlEncode(string sqlString)
        {
            string Result = "";
            if (string.IsNullOrEmpty(sqlString))
            {
                return Result;
            }
            for (int i = 0; i < sqlString.Length; i++)
                Result += (sqlString[i] == '\'' ? "\'\'" : sqlString[i] + "");
            return Result;
        }
        /// <summary>
        /// 写信息
        /// </summary>
        private void Xmlwrite()
        {
            XmlTextWriter writer = new XmlTextWriter(Response.Output);

            writer.Formatting = Formatting.Indented;

            writer.WriteStartDocument();

            writer.WriteStartElement("root");

            writer.WriteStartElement("appid");
            writer.WriteString(appid);
            writer.WriteEndElement();

            writer.WriteStartElement("status");
            writer.WriteString(status.ToString());
            writer.WriteEndElement();

            writer.WriteStartElement("needcookie");

            writer.WriteString("1" == Request.QueryString["needcookie"] ? "1" : "0");

            writer.WriteEndElement();

            writer.WriteStartElement("body");

            writer.WriteStartElement("message");
            writer.WriteString(message);
            writer.WriteEndElement();
            writer.WriteEndElement();
            writer.WriteEndElement();
            writer.WriteEndDocument();
            Response.End();
        }
        /// <summary>
        /// 得到地域ID
        /// </summary>
        /// <param name="areaname">地域名称</param>
        /// <returns>地域ID</returns>
        private int getAreaID(string areaname)
        {
            NetSNS.BLL.User.Dict dict = new NetSNS.BLL.User.Dict();
            return dict.GetAreaID(areaname);
        }
        /// <summary>
        /// 取得地域名称
        /// </summary>
        /// <param name="areaid">地域ID</param>
        /// <returns></returns>
        private string getAreaName(int areaid)
        {
            NetSNS.BLL.User.Dict dict = new NetSNS.BLL.User.Dict();
            return dict.GetAreaName(areaid);
        }

        /// <summary>
        /// 检测是否是允许的地址发来的
        /// </summary>
        /// <returns></returns>
        private bool Check()
        {
            UriBuilder ub = new UriBuilder(Config["URL"]);
            if (HttpContext.Current.Request.UserHostAddress == getIP(ub.Host))
            {
                return true;
            }
            return false;
        }
        /// <summary>
        /// 根据域名获取IP
        /// </summary>
        /// <param name="host">域名</param>
        /// <returns></returns>
        private string getIP(string host)
        {
            IPHostEntry hostinfo = Dns.GetHostEntry(host);
            return hostinfo.AddressList[0].ToString();
        }
        /// <summary>
        /// 检测是否开启接口
        /// </summary>
        /// <returns></returns>
        private bool Enable()
        {
            if (bool.Parse(Config["ENABLED"]))
            {
                return true;
            }
            return false;
        }
        /// <summary>
        /// 检测并返回
        /// </summary>
        /// <returns></returns>
        private bool Available()
        {
            if (Check() && Enable())
                return true;
            return false;
        }
    }
}
