using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using System.Collections.Generic;
using NetSNS.Common;

namespace NetSNS.Web.user.Album
{
    public partial class GroupAlbumNew : NetSNS.Web.UI.Page.BasePage
    {
        protected new int UserID;
        protected void Page_Load(object sender, EventArgs e)
        {
            UserID = this.GetUserID();
            if (Page.IsPostBack)
            {
                SaveAlbum();
            }
            setGroup();
        }


        protected void setGroup()
        {
            int GroupID = 0;
            try
            {
                GroupID = int.Parse(Request.QueryString["groupid"]);
            }
            catch { }
            if (GroupID == 0)
            {
                PageError("ݴ!", "photos.aspx");
            }
            UserGroup ug = new UserGroup();
            if (!ug.IsMyGroup(GroupID, this.UserID))
            {
                this.addtip.InnerHtml = "<ul><li>ȺԱܷȺ</li><li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷȺ</li></ul>','',function (){self.location='../group/group.aspx?Action=Join&GroupID=" + GroupID + "';})\">Ⱥ</a></li></ul>";
                this.addform.Visible = false;
                return;
            }
            this.addform.Visible = true;
            this.addtip.Visible = false;
            List<UserGroupInfo> grouplist = ug.GetUserGroup(this.UserID);
            for (int i = 0; i < grouplist.Count; i++)
            {
                ListItem li = new ListItem(grouplist[i].GroupName, grouplist[i].GroupID.ToString());
                if (grouplist[i].GroupID == GroupID)
                    li.Selected = true;
                this.GroupID.Items.Add(li);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        protected void SaveAlbum()
        {
            string title = Input.Filter(Request.Form["title"]);
            string desc = Input.Filter(Request.Form["desc"]);
            string attr = Input.Filter(Request.Form["attr"]);
            string groupid = Input.Filter(Request.Form["groupid"]);
            if (title == "")
            {
                Session["ErrMSG"] = "<li>ƲΪ";
            }

            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(desc, true);
            if (res != "")
            {
                desc = desc.Replace(res, "***");
            }
            #endregion

            int GroupID = 0;
            try
            {
                GroupID = int.Parse(groupid);
            }
            catch { }
            NetSNS.BLL.User.Album ab = new NetSNS.BLL.User.Album();
            AlbumInfo abi = new AlbumInfo();
            abi.Title = title;
            abi.UserID = this.UserID;
            abi.Description = desc;
            abi.ImagesCount = 0;
            abi.CreateTime = DateTime.Now;
            abi.GroupID = GroupID;
            switch (attr)
            {
                case "0":
                    abi.Privacy = EnumPrivacy.ForWholeSite;
                    break;
                case "1":
                    abi.Privacy = EnumPrivacy.ForNetWorkAndFriends;
                    break;
                case "2":
                    abi.Privacy = EnumPrivacy.ForFriends;
                    break;
                case "3":
                    abi.Privacy = EnumPrivacy.ForOwner;
                    break;
                default:
                    abi.Privacy = EnumPrivacy.ForWholeSite;
                    break;
            }
            if (ab.Add(abi) == 1)
            {
                Session.Remove("ErrMSG");
                Response.Redirect("PhotoAdd.aspx?r=" + ab.LastAlbumID(this.UserID) + "&u=" + this.UserID);
            }
            else
            {
                Session["ErrMSG"] = "<li>ʧ";
            }
            if (Convert.ToString(Session["ErrMSG"]) != "")
            {
                Session["ErrMSG"] = "<ul>" + Convert.ToString(Session["ErrMSG"]) + "</ul>";
            }
            Response.Redirect("GroupAlbumNew.aspx");
        }
    }
}
