//===========================================================
//==               (c)2008  NETSNS 1.0                  ==
//==            website:www.aspxcms.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Web.UI.Control;
using NetSNS.Common;
using System.Collections.Generic;

namespace NetSNS.Web.user.Group
{
    public partial class Group : NetSNS.Web.UI.Page.BasePage
    {
        protected NetSNS.Model.UserGroupInfo usergroupinfo;
        NetSNS.BLL.User.GroupMember groupmember = new NetSNS.BLL.User.GroupMember();
        protected new int UserID = 0;
        protected int GroupID;
        protected void Page_Load(object sender, EventArgs e)
        {
            UserID = this.GetUserID();
            CheckPublicity();
            Operate();
            getInfo();
        }

        /// <summary>
        /// Ƿ
        /// </summary>
        protected void CheckPublicity()
        {
            bool tf = false;
            string s_GroupID = Request.QueryString["GroupID"];
            if (s_GroupID == null || s_GroupID == "")
            { PageError("ݴ", "dyangroup.aspx"); }

            Div_JoinGroup.Visible = false;
            GroupID = Convert.ToInt32(s_GroupID);

            if (!groupmember.IsGroupMember(UserID, GroupID))
            {
                PostDiss.Visible = false;
                Div_JoinGroup.Visible = true;
                if (UserID != 0)
                    but_Join.Attributes.Add("onclick", "self.location='group.aspx?Action=Join&GroupID=" + GroupID + "'");
                else
                    but_Join.Attributes.Add("onclick", "alert('ûе½');location.href='/user/index.aspx'");
            }



            Hid_GroupID.Value = s_GroupID;
            NetSNS.BLL.User.UserGroup usergroup = new NetSNS.BLL.User.UserGroup();
            usergroupinfo = usergroup.Info(GroupID);

            usergroup.AddVisit(GroupID, UserID);
            usergroup.AddHot(GroupID);

            tf = usergroup.CheckPublicity(GroupID, UserID, false);
            if (!tf)
            { PageError("ûзȨޣ", "dyangroup.aspx"); }
        }

        /// <summary>
        /// ز
        /// </summary>
        protected void Operate()
        {
            string s_Act = Request.QueryString["Action"];
            int n = 0;
            if (s_Act != null && s_Act != "")
            {
                string s_gid = Request.QueryString["GroupID"];
                if (s_gid == null || s_gid == "")
                    PageError("ݴ!", "dyangroup.aspx");
                int groupid = Convert.ToInt32(s_gid);
                if (UserID == 0)
                    PageError("ûе¼!", "/user/login.aspx");
                switch (s_Act)
                {
                    case "Join":
                        NetSNS.Model.GroupMemberInfo gmemberinfo = new GroupMemberInfo();
                        gmemberinfo.ID = 0;
                        gmemberinfo.GroupID = groupid;
                        gmemberinfo.UserID = UserID;
                        gmemberinfo.Grade = EnumGroupGrade.Common;
                        gmemberinfo.JoinTime = DateTime.Now;
                        n = groupmember.Join(gmemberinfo);
                        if (n == 1)
                            Response.Redirect("group.aspx?GroupID=" + groupid.ToString());
                        else
                            PageError("Ⱥʧ!", "dyangroup.aspx");
                        break;
                    case "Exit":
                        if (usergroupinfo.UserID == UserID && usergroupinfo.Members == 1)
                        {
                            NetSNS.BLL.User.UserGroup usergroup = new NetSNS.BLL.User.UserGroup();
                            n = usergroup.Del(groupid, UserID);
                        }
                        else
                        {
                            n = groupmember.Out(UserID, groupid);
                        }
                        if (n == 1)
                            Response.Cookies["OutGroup"].Value = "true";
                        Response.Redirect("grouplist.aspx");
                        break;
                }
            }
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            int GroupID = Convert.ToInt32(Hid_GroupID.Value);

            H2_GroupName.InnerHtml = usergroupinfo.GroupName;
            P_Publicity.InnerHtml = NetSNS.BLL.User.UserGroup.getPublicityName(usergroupinfo.Publicity);
            Div_sect.InnerHtml = NetSNS.Common.Input.HtmlEncode(usergroupinfo.Bulletin);
            Img_GroupHead.Src = this.GetGroupHead(usergroupinfo.Portrait);
            Img_GroupHead.Alt = usergroupinfo.GroupName;
            Span_UserCount.InnerHtml = usergroupinfo.Members.ToString();
            A_AllMember.HRef = "groupmember.aspx?GroupID=" + Hid_GroupID.Value;

            DataTable dt_NewMember = groupmember.Top6GroupMemberList(GroupID);
            if (dt_NewMember != null)
            {
                Rpt_MemberList.DataSource = dt_NewMember;
                Rpt_MemberList.DataBind();
                dt_NewMember.Clear(); dt_NewMember.Dispose();
            }

            A_Edit.HRef = "step1.aspx?GroupID=" + Hid_GroupID.Value;
            P_GroupType.InnerHtml = getGroupType(usergroupinfo.Publicity);

            DataTable dt_GroupAdmin = groupmember.GroupMemberGradeList(2, GroupID);
            if (dt_GroupAdmin != null)
            {
                Rpt_GroupAdminList.DataSource = dt_GroupAdmin;
                Rpt_GroupAdminList.DataBind();
                dt_GroupAdmin.Clear(); dt_GroupAdmin.Dispose();
            }

            string s_Op = "";
            bool supertf = false;
            bool admintf = false;
            if (usergroupinfo.UserID == UserID)
                supertf = true;
            if (groupmember.IsGroupAdmin(UserID, GroupID))
                admintf = true;

            string clubstr = string.Empty;
            CarClubInfo ccinfo = new CarClubInfo();
            NetSNS.BLL.User.UserGroup ug = new NetSNS.BLL.User.UserGroup();
            ccinfo = ug.GetCarClubInfo(GroupID);
            if (ccinfo.id != 0)
            {
                clubstr = "<li><a href=\"/user/car/clubinfo.aspx?id=" + GroupID + "\">" + ccinfo.clubName + "</a></li>";
            }
            if (supertf || admintf)
            {
                s_Op = "<li><a href=\"GroupDiscuss.aspx?GroupID=" + GroupID + "\">鿴</a></li>";
                s_Op += "<li><a href=\"album.aspx?GroupID=" + GroupID + "\">鿴</a></li>";
                s_Op += clubstr;
                s_Op += "<li><a href=\"step1.aspx?GroupID=" + GroupID + "\">Ⱥ</a></li>";
                s_Op += "<li><a href=\"step3.aspx?GroupID=" + GroupID + "&a=1\">Ա</a></li>";
                s_Op += "<li><a href=\"step3.aspx?GroupID=" + GroupID + "&a=1\">Ѽ</a></li>";
                if (usergroupinfo.Members == 1 || admintf)
                    s_Op += "<li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪ˳Ⱥ</li></ul>','˳',function (){self.location='?Action=Exit&GroupID=" + GroupID + "';})\">˳Ⱥ</a></li>";
            }
            else
            {
                s_Op = "<li><a href=\"GroupDiscuss.aspx?GroupID=" + GroupID + "\">鿴</a></li>";
                s_Op += "<li><a href=\"album.aspx?GroupID=" + GroupID + "\">鿴</a></li>";
                s_Op += clubstr;
                //жǷǱȺԱʾȺ
                if (UserID != 0)
                {
                    if (groupmember.IsGroupMember(UserID, GroupID) == false)
                        s_Op += "<li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷȺ</li></ul>','',function (){self.location='?Action=Join&GroupID=" + GroupID + "';})\">Ⱥ</a></li>";
                    else
                        s_Op += "<li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪ˳Ⱥ</li></ul>','˳',function (){self.location='?Action=Exit&GroupID=" + GroupID + "';})\">˳Ⱥ</a></li>";
                }
            }
            Ul_GroupAdminOp.InnerHtml = s_Op;

            DivPage.Visible = false;
            int r, p, PageIndex = 0;
            PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo st = new SqlConditionInfo("@GroupID", GroupID, TypeCode.Int32);

            DataTable dt_Discuss = NetSNS.BLL.User.UtilPage.GetPage("GroupDiscuss_aspx", PageIndex, 25, out r, out p, st);
            if (dt_Discuss != null)
            {
                Rpt_DiscussList.DataSource = dt_Discuss;
                Rpt_DiscussList.DataBind();
                dt_Discuss.Clear();
                dt_Discuss.Dispose();
            }
            //жǷ÷ҳ
            if (r > 25)
            {
                //PostDiss.Visible = false;
                DivPage.Visible = true;
                DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, p, "GroupDiscuss.aspx?GroupID=" + GroupID);
            }
            span_DiscussCount.InnerHtml = r.ToString();
            setGroupAlbum();
        }

        /// <summary>
        /// ȡ˽
        /// </summary>
        /// <param name="enumprivacy"></param>
        /// <returns></returns>
        protected string getGroupType(EnumGroupPrivacy enumprivacy)
        {
            string s_Type = "";
            switch (enumprivacy)
            {
                case EnumGroupPrivacy.ForWholeSite:
                    s_Type = "<strong>ǹȺ</strong>ȺȫʱԼ롣";
                    break;
                case EnumGroupPrivacy.ForSemiOvert:
                    s_Type = "<strong>ǰ빫Ⱥ</strong>ǳԱȺϣܲ鿴Ҫܼ롣";
                    break;
                case EnumGroupPrivacy.ForGroupMember:
                    s_Type = "<strong>˽Ⱥ</strong>ֻгԱܿȺ飬ǳԱҪܳԱܼ롣";
                    break;
            }
            return s_Type;
        }

        /// <summary>
        /// ȡûͷַ
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns></returns>
        protected string getHead(object FilePath,object userid)
        {
            return GetSmallHeadPic(FilePath, 1,(int)userid);
        }

        /// <summary>
        /// жǷȺ
        /// </summary>
        /// <param name="Type"></param>
        /// <returns></returns>
        protected string getGradeName(object Type)
        {
            string s_Name = "";
            if (Type.ToString() == "0")
                s_Name = "Ⱥ";
            return s_Name;
        }

        /// <summary>
        /// ȡûԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        protected string getUserName(object UserID)
        {
            string s_Name = "&nbsp;";
            if (UserID != DBNull.Value)
            {
                NetSNS.BLL.User.User user = new NetSNS.BLL.User.User();
                UserInfo userinfo = new UserInfo();
                userinfo = user.GetUserInfo(Convert.ToInt32(UserID));
                s_Name = "<a href=\"/user/space/?r=" + UserID.ToString() + "\">" + userinfo.Username + "</a>";
            }
            return s_Name;
        }

        /// <summary>
        /// ȡʱ
        /// </summary>
        /// <param name="time">ʱ</param>
        /// <returns></returns>
        protected string getTime(object time, object id)
        {
            string s_Time = "&nbsp;";
            if (time != DBNull.Value)
                s_Time = "<a href=\"GroupDiscussInfo.aspx?DisID=" + id.ToString() + "\">" + NetSNS.Common.Public.getTimeSpan(Convert.ToDateTime(time)) + "</a>";
            return s_Time;
        }

        /// <summary>
        /// ʾǷö
        /// </summary>
        /// <param name="topnum"></param>
        /// <returns></returns>
        protected string getIsTop(object topnum)
        {
            string s_Top = "";
            if (topnum.ToString() == "1")
                s_Top = "ö";
            return s_Top;
        }

        /// <summary>
        /// ȡöʽ
        /// </summary>
        /// <param name="topnum"></param>
        /// <returns></returns>
        protected string getTopCss(object topnum)
        {
            string s_Css = "";
            if (topnum.ToString() == "1")
                s_Css = " class=\"top-topic\"";
            return s_Css;
        }

        /// <summary>
        /// ִӹ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button1_Click(object sender, EventArgs e)
        {
            bool tf = groupmember.IsGroupMember(UserID, Convert.ToInt32(Hid_GroupID.Value));
            if (!tf)
                PageError("ûзȨ!ܷ!", "dyangroup.aspx");

            if (Page.IsValid)
            {
                if (Topic.Value.Trim() == "" || Content.Value.Trim() == "")
                {
                    ShowErr("ݲΪ!", div_Error);
                    goto Finish;
                }

                #region ˹ؼ
                string res = NetSNS.Common.Public.CheckKey(this.Content.Value, true);
                if (res != "")
                {
                    this.Content.Value = this.Content.Value.Replace(res, "***");
                }
                #endregion
                NetSNS.BLL.User.GroupDiscuss groupdis = new NetSNS.BLL.User.GroupDiscuss();
                NetSNS.Model.GroupDiscussInfo groupdisinfo = new NetSNS.Model.GroupDiscussInfo();
                groupdisinfo.ID = 0;
                groupdisinfo.GroupID = Convert.ToInt32(Hid_GroupID.Value);
                groupdisinfo.UserID = UserID;
                groupdisinfo.Topic = Topic.Value;
                groupdisinfo.Content = NetSNS.Common.Input.HtmlEncode(Content.Value);
                groupdisinfo.DiscussType = 0;
                groupdisinfo.BelongTopic = 0;
                groupdisinfo.PostTime = DateTime.Now;
                groupdisinfo.PostIP = NetSNS.Common.Public.GetClientIP();
                groupdisinfo.LastPostTime = DateTime.Now;
                groupdisinfo.LastPostIP = NetSNS.Common.Public.GetClientIP();
                groupdisinfo.LastPoster = 0;
                groupdisinfo.Replys = 0;
                groupdisinfo.State = 0;
                groupdisinfo.LastModifyTime = DateTime.Now;
                groupdisinfo.LastModifyIP = NetSNS.Common.Public.GetClientIP();
                groupdisinfo.ReplyID = 0;
                groupdisinfo.ReplyTack = "";
                groupdisinfo.SeriesNum = 0;
                groupdisinfo.TopNum = 0;

                if (groupdis.Add(groupdisinfo) == 1)
                {
                    Response.Cookies["AddGroupDisIsSuc"].Value = "true";
                    Response.Redirect("GroupDiscuss.aspx?GroupID=" + Hid_GroupID.Value);
                }
                else
                {
                    Topic.Value = "";
                    Content.Value = "";
                    ShowErr("ʧ!", div_Error);
                }
            Finish: ;
            }
        }
        /// <summary>
        /// Ⱥ
        /// </summary>
        protected void setGroupAlbum()
        {
            BLL.User.Photo photo = new BLL.User.Photo();
            List<PhotoInfo> infolist = photo.GroupInfoList(GroupID);
            this.groupalbum.DataSource = infolist;
            this.groupalbum.RepeatDirection = RepeatDirection.Vertical;
            this.groupalbum.RepeatColumns = 3;
            this.groupalbum.DataBind();
        }
    }
}
