﻿<%@ Page Language="C#" AutoEventWireup="true" Codebehind="GroupDiscuss.aspx.cs" Inherits="NetSNS.Web.user.Group.GroupDiscuss"
    ValidateRequest="false" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title id="GroupTitle">群组讨论区</title>

    <script language="javascript" type="text/javascript" src="/js/prototype.js"></script>

    <script language="javascript" type="text/javascript" src="/js/public.js"></script>

    <script src="/js/eventload.js" type="text/javascript"></script>

    <script type="text/javascript" src="/editor/fckeditor.js"></script>

    <link href="/css/base.css" type="text/css" rel="stylesheet" />
    <link href="/css/skin/<% Response.Write(NetSNS.Config.UiConfig.SkinStyle); %>/style.css"
        id="skinpath" type="text/css" rel="stylesheet" />
</head>
<body>
    <div id="headarea">
        <!--#include file="../head.htm"-->
    </div>
    <div id="mainarea">
        <div id="mleft">
            <!--#include file="../left.htm"-->
        </div>
        <form id="form1" runat="server">
            <div id="mright">
                <div id="mid">
                    <div class="container">
                        <div id="header">
                            <p class="image">
                                <a id="A_A_Return1" runat="server">
                                    <img id="Img_GroupIMG" runat="server" width="48" height="48" /></a></p>
                            <h2>
                                <span id="Span_GroupName" runat="server"></span><span class="pipe">-</span><em>讨论区</em></h2>
                            <p class="actions">
                                <a id="A_Return" runat="server">返回群组</a></p>
                            <div id="toc">
                                <p class="bar">
                                    <span id="P_Count" runat="server"></span>个主题<span class="pipe">|</span><a href="#board-post">发表新主题</a></p>
                            </div>
                        </div>
                        <div class="msg-succ" id="div_Suc" runat="server" style="display: none;">
                        </div>
                        <div class="msg-error" id="div_Error" runat="server" style="display: none;">
                        </div>
                        <div class="mainnoright">
                            <div id="wrap">
                                <div id="board">
                                    <asp:Repeater ID="Rpt_DiscussList" runat="server">
                                        <HeaderTemplate>
                                            <table class="board-topic-list" cellspacing="0">
                                                <tr>
                                                    <th class="title">
                                                        主题</th>
                                                    <th class="author">
                                                        作者<span class="count">回复数</span></th>
                                                    <th class="replier">
                                                        最后发言<span class="time">发言时间</span></th>
                                                </tr>
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <tr <%# getTopCss(DataBinder.Eval(Container.DataItem, "TopNum"))%>>
                                                <td class="title">
                                                    <a href="GroupDiscussInfo.aspx?DisID=<%# DataBinder.Eval(Container.DataItem, "ID")%>">
                                                        <%# getIsTop(DataBinder.Eval(Container.DataItem, "TopNum"))%>
                                                        <%# DataBinder.Eval(Container.DataItem, "Topic")%>
                                                    </a>
                                                </td>
                                                <td class="author">
                                                    <a href="/user/space/?r=<%# DataBinder.Eval(Container.DataItem, "UserID")%>">
                                                        <%# DataBinder.Eval(Container.DataItem, "UserName")%>
                                                    </a><span class="count">
                                                        <%# DataBinder.Eval(Container.DataItem, "Replys")%>
                                                    </span>
                                                </td>
                                                <td class="replier">
                                                    <%# getUserName(DataBinder.Eval(Container.DataItem, "LastPoster"))%>
                                                    <span class="time">
                                                        <%# getTime(DataBinder.Eval(Container.DataItem, "LastPostTime"), DataBinder.Eval(Container.DataItem, "ID"))%>
                                                    </span>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate>
                                            </table>
                                        </FooterTemplate>
                                    </asp:Repeater>
                                    <div class="pagination" runat="server" id="DivPage">
                                    </div>
                                    <div class="nc" id="Div_JoinGroup" runat="server">
                                        仅群组成员可以发表新主题，随时可以加入。
                                        <div style="padding-top: 2em; text-align: center">
                                            <input type="button" class="f-button" value="加入此群组" runat="server" id="but_Join" />
                                        </div>
                                    </div>
                                    <div id="Div_NewTopic" runat="server">
                                        <div id="board-post">
                                            <h4>
                                                发表新主题</h4>
                                            <p>
                                                <label for="title" class="f-label">
                                                    标题</label><input type="text" class="f-text" runat="server" id="Topic" maxlength="40"
                                                        size="60" /></p>
                                            <p>
                                                <label for="body" class="f-label">
                                                    内容</label>

                                                <script type="text/javascript" language="JavaScript">
                                                        window.onload = function()
                                                        {
                                                            var sBasePath = "/editor/"
                                                            var oFCKeditor = new FCKeditor('Content') ;
                                                            oFCKeditor.BasePath	= sBasePath ;
                                                            oFCKeditor.Width = '100%' ;
                                                            oFCKeditor.ToolbarSet = 'Basic';
                                                            oFCKeditor.Height = '150' ;	
                                                            oFCKeditor.ReplaceTextarea() ;
                                                        }
                                                </script>

                                                <textarea rows="1" cols="1" name="Content" style="display: none" id="Content" runat="server"
                                                    maxlength="4000"></textarea>
                                            </p>
                                            <p class="act">
                                                <asp:HiddenField ID="Hid_GroupID" runat="server" />
                                                <asp:Button ID="Button1" runat="server" Text="发表" class="f-button" OnClick="Button1_Click" /></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bottombg">
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div id="bottomarea">
        <!--#include file="../footer.htm"-->
    </div>
</body>
</html>
