using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.Web.user.Space
{
    public partial class UserContact : NetSNS.Web.UI.Page.UserPage
    {
        NetSNS.BLL.User.Space sp = new NetSNS.BLL.User.Space();
        public static string GetDivStr = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.QueryString["cr"] != string.Empty && Request.QueryString["cr"] != null)
                {
                    GetDivStr = "<div style=\"padding:5px;margin:5px;margin-bottom:0;border:#F45803 1px solid;background-color:#FDFA05;color:#F45803;clear:both;\">ǵһε½ϵͳƻϡԷδʶرͷ</div>";
                }
                else
                {
                    GetDivStr = string.Empty;
                }

                getLXInfo(this.UserID);
            }

            try
            {
                string type = Request.Form["Type"];
                if (type == "Edit")
                {
                    Submit();
                }
                else if (type == "Privacy")
                {
                    UpdatePrivacy();
                }
            }
            catch { }
        }

        #region ȡԱϵϢ
        public void getLXInfo(int UserId)
        {
            DataTable dtt = sp.getUserInfo(UserId,11);
            if (dtt != null)
            {
                if (dtt.Rows.Count > 0)
                {
                    this.spanEmail.InnerHtml = dtt.Rows[0]["Email"].ToString();
                    this.msn.Value = dtt.Rows[0]["MSN"].ToString();
                    this.gtalk.Value = dtt.Rows[0]["GTalk"].ToString();
                    this.qq.Value = dtt.Rows[0]["QQ"].ToString();
                    this.skype.Value = dtt.Rows[0]["Skype"].ToString();
                    this.mobile.Value = dtt.Rows[0]["Mobile"].ToString();
                    this.landphone.Value = dtt.Rows[0]["Tel"].ToString();
                    this.address.Value = dtt.Rows[0]["Addr"].ToString();
                    this.website.Value = dtt.Rows[0]["WebSite"].ToString();
                    
                    this.spMsn.InnerHtml = getPrivacy(dtt.Rows[0]["MSNPrivacy"].ToString());
                    this.spEmail.InnerHtml = getPrivacy(dtt.Rows[0]["EmailPrivacy"].ToString());
                    this.spGtalk.InnerHtml = getPrivacy(dtt.Rows[0]["GTalkPrivacy"].ToString());
                    this.spqq.InnerHtml = getPrivacy(dtt.Rows[0]["QQPrivacy"].ToString());
                    this.spSkype.InnerHtml = getPrivacy(dtt.Rows[0]["SkypePrivacy"].ToString());
                    this.spMobile.InnerHtml = getPrivacy(dtt.Rows[0]["MobilePrivacy"].ToString());
                    this.spLandphone.InnerHtml = getPrivacy(dtt.Rows[0]["TelPrivacy"].ToString());
                    this.spAddress.InnerHtml = getPrivacy(dtt.Rows[0]["AddrPrivacy"].ToString());
                    this.spWebsite.InnerHtml = getPrivacy(dtt.Rows[0]["WebSitePrivacy"].ToString());
                }
            }
        }
        #endregion

        #region ɼ
        public string getPrivacy(string k)
        {
            int s = int.Parse(k);
            if (s == (int)EnumPrivacy.ForWholeSite)
            {
                return "ȫվûɼ";
            }
            else if (s == (int)EnumPrivacy.ForNetWorkAndFriends)
            {
                return "ͬûѿɼ";
            }
            else if (s == (int)EnumPrivacy.ForFriends)
            {
                return "ѿɼ";
            }
            else if (s == (int)EnumPrivacy.ForOwner)
            {
                return "Լɼ";
            }
            else
            {
                return "";
            }
        }
        #endregion

        #region »ԱϢ
        public void Submit()
        {
            UserBasicInfo uf = new UserBasicInfo();
            uf.UserID = this.UserID;
            uf.MSN = Request.Form["msn"];
            uf.GTalk = Request.Form["gtalk"];
            uf.QQ = Request.Form["qq"];
            uf.Skype = Request.Form["skype"];
            uf.Mobile = Request.Form["mobile"];
            uf.Tel = Request.Form["landphone"];
            uf.Addr = Request.Form["address"];
            uf.WebSite = Request.Form["website"];

            if (sp.UpdateUserInfo(uf, this.UserID, 1) == 1)
            {
                Response.Write("޸ĳɹ");
                Response.End();
            }
        }
        #endregion

        #region ûԱϢɼ
        public void UpdatePrivacy()
        {
            int str_Privacy = int.Parse(Request.Form["Privacy"]);
            string strName = Request.Form["strName"];
            if (sp.UpdatePrivacy(strName, str_Privacy, this.UserID) == 1)
            {
                Response.Write("óɹ");
                Response.End();
            }
        }
        #endregion
    }
}
