using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace NetSNS.Web
{
    public class BlogUi
    {
        /// <summary>
        /// ȡ־ݵĵ
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        static public string GetContent(object input)
        {
            if (input == null || input == DBNull.Value)
                return string.Empty;
            string s = NetSNS.Common.Input.HtmlEncode(input.ToString());
            if (s.Length <= 60)
                return s;
            else
                return s.Substring(0, 60) + "...";
        }
        /// <summary>
        /// ȡñ
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        static public string GetTitle(object input)
        {
            if (input == null || input == DBNull.Value)
                return "ޱ";
            return NetSNS.Common.Input.HtmlEncode(input.ToString());
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="blogid"></param>
        /// <param name="input"></param>
        /// <returns></returns>
        static public string GetComments(object blogid, object input)
        {
            int n = Convert.ToInt32(input);
            if (n < 1)
                return "û";
            else
                return "<a href=\"article.aspx?r=" + blogid + "#blog-cmtlist\">" + n + " </a>";
        }
        /// <summary>
        /// ȡĶ
        /// </summary>
        /// <param name="blogid"></param>
        /// <param name="input"></param>
        /// <returns></returns>
        static public string GetReads(object blogid, object input)
        {
            int n = Convert.ToInt32(input);
            if (n < 1)
                return "ûĶ";
            else
                return "<a href=\"article.aspx?r=" + blogid + "\">" + n + " Ķ</a>";
        }
    }
}
