using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.Web.user.blog
{
    public partial class article : NetSNS.Web.UI.Page.UserPage
    {
        protected int blid;
        protected int uid;
        protected string unm;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["r"] != null)
                blid = int.Parse(Request.QueryString["r"]);
            NetSNS.BLL.User.Blog bl = new NetSNS.BLL.User.Blog();
            #region Ajax
            if (Request.Form["Option"] == "DelComment")
            {
                try
                {
                    int id = int.Parse(Request.Form["ID"]);
                    bl.DelComment(UserID, id);
                    Response.Write("1");
                }
                catch
                {
                    Response.Write("0");
                }
                Response.End();
            }
            else if (Request.Form["Option"] == "DelBlog")
            {
                try
                {
                    int id = int.Parse(Request.Form["ID"]);
                    bl.DelBlog(UserID, id);
                    Response.Write("1");
                }
                catch
                {
                    Response.Write("0");
                }
                Response.End();
            }
            #endregion
            if (Request.Form["Comment"] == "Submit")
            {
                Comment(blid);
                Response.Redirect("article.aspx?r=" + blid);
            }

            BlogInfo info;
            List<BlogCommentInfo> lst;
            bool addreads = false;
            string cookieid = "BlogReadA_" + blid + "_" + UserID;
            if (Request.Cookies[cookieid] == null || Request.Cookies["BlogReadA_" + blid + "_" + UserID].Value != "1")
            {
                HttpCookie cooknum = new HttpCookie(cookieid);
                Response.Cookies[cookieid].Value = "1";
                Response.Cookies[cookieid].Expires = DateTime.Now.AddYears(10);
                addreads = true;
            }
            int n = bl.GetAllInfo(UserID, blid, addreads, out info, out lst);
            uid = info.UserID;
            unm = info.UserName;
            if (info.UserID == UserID)
            {
                unm = "";
                this.HypList.Text = "ҵ־б";
                this.HypList.NavigateUrl = "myblog.aspx";
            }
            else
            {
                unm = info.UserName;
                this.HypList.Text = "" + info.UserName + "־б";
                this.HypList.NavigateUrl = "userblog.aspx?r=" + info.UserID;
            }
            this.ImgPortrait.Src = GetSmallHeadPic(info.UserPortrait, 1,info.UserID);
            this.ImgPortrait.Alt = info.UserName;

            this.LtrNum.Text = n.ToString();
            if (info.Reads > 0)
                this.LtrReads.Text = info.Reads + " Ķ";
            else
                this.LtrReads.Text = "ûĶ";
            if (info.Comments > 0)
                this.LtrComments.Text = info.Comments + " ";
            else
                this.LtrComments.Text = "û";
            if (info.Title.Trim() == string.Empty)
                this.LtrTitle.Text = "ޱ";
            else
                this.LtrTitle.Text = Input.HtmlEncode(info.Title);
            this.LtrContent.Text = info.Content.Replace("\r\n", "");
            this.LtrTime.Text = Public.getTimeSpan(info.PostTime);
            this.RptComment.DataSource = lst;
            this.RptComment.DataBind();
            DataBind();
        }
        private void Comment(int blogid)
        {
            string s = Request.Form["TxtComment"];

            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(s, true);
            if (res != "")
            {
                s = s.Replace(res, "***");
            }
            #endregion
            NetSNS.BLL.User.Blog bl = new NetSNS.BLL.User.Blog();
            bl.CommentsBlog(blogid, UserID, s);
        }
        /// <summary>
        /// ǷʾɾĹ
        /// </summary>
        /// <param name="commuserid"></param>
        /// <param name="bloguserid"></param>
        /// <param name="commid"></param>
        /// <returns></returns>
        protected string ShowDelComm(object commuserid, object bloguserid, object commid)
        {
            if (UserID == (int)bloguserid || UserID == (int)commuserid)
                return "<span class=\"delete\"><a href=\"javascript:DeleteComment(" + commid + ");\" class=\"thread-del\">ɾ</a></span>";
            else
                return string.Empty;
        }
    }
}
