using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;

namespace NetSNS.Web.user.blog
{
    public partial class edit : NetSNS.Web.UI.Page.UserPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                this.HidBlogId.Value = "0";
                this.DivError.Visible = false;
                this.DivDS.Visible = false;
                ListItem it0 = new ListItem("ͬûѿɼ", ((int)EnumPrivacy.ForNetWorkAndFriends).ToString());
                this.DdlPrvcy.Items.Add(it0);
                ListItem it1 = new ListItem("ȫվûɼ", ((int)EnumPrivacy.ForWholeSite).ToString());
                it1.Selected = true;
                this.DdlPrvcy.Items.Add(it1);
                ListItem it2 = new ListItem("ѿɼ", ((int)EnumPrivacy.ForFriends).ToString());
                this.DdlPrvcy.Items.Add(it2);
                ListItem it3 = new ListItem("Լɼ", ((int)EnumPrivacy.ForOwner).ToString());
                this.DdlPrvcy.Items.Add(it3);
                this.LtrCaption.Text = "д־";
                string calid = Request.QueryString["calid"]; //ճid
                if (!string.IsNullOrEmpty(calid))
                {
                    this.calid.Value = calid;
                }
                if (Request.QueryString["r"] != null)
                {
                    int id = int.Parse(Request.QueryString["r"]);
                    this.HidBlogId.Value = id.ToString();
                    this.LtrCaption.Text = "༭־";
                    bool isdraft = false;
                    if (Request.QueryString["a"] != null && Request.QueryString["a"].ToLower() == "draft")
                    {
                        isdraft = true;
                        this.HidIsDraft.Value = "1";
                    }
                    else
                    {
                        this.BtnDraft.Visible = false;
                    }
                    NetSNS.BLL.User.Blog bl = new NetSNS.BLL.User.Blog();
                    BlogInfo info = bl.GetBlog(id, isdraft);
                    if (info.UserID != UserID)
                        throw new Exception("ûȨޱ༭־");
                    this.TxtTitle.Text = info.Title;
                    this.TxtContent.Value = info.Content;
                    this.DdlPrvcy.SelectedValue = ((int)info.Privacy).ToString();
                    //this.BtnDraft.Visible = false;
                }
                else
                {
                    this.BtnDel.Visible = false;
                }
            }
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            Save(false);
        }

        protected void BtnDraft_Click(object sender, EventArgs e)
        {
            Save(true);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="isDraft"></param>
        protected void Save(bool isDraft)
        {
            string title = this.TxtTitle.Text.Trim();
            //string content = NetSNS.Common.Input.loseExceptImg(this.TxtContent.Value);
            string content = this.TxtContent.Value;
            if (title == string.Empty && content == string.Empty)
            {
                this.DivError.Visible = true;
            }

            content = NetSNS.Common.Input.loseIframe(content);
            content = NetSNS.Common.Input.loseScript(content);

            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(content, true);
            if (res != "")
            {
                content = content.Replace(res,"***");
            }
            #endregion

            BlogInfo info = new BlogInfo();
            info.UserID = UserID;
            info.Title = title;
            info.Content = content;
            info.ID = int.Parse(this.HidBlogId.Value);
            NetSNS.BLL.User.Blog bl = new NetSNS.BLL.User.Blog();
            if (info.ID > 0)
            {
                if (isDraft)
                {
                    bl.Edit(info, 1);
                }
                else
                {
                    int n = 0;
                    if (this.HidIsDraft.Value == "1")
                    {
                        n = bl.Edit(info, 2);
                    }
                    else
                    {
                        bl.Edit(info, 0);
                        n = info.ID;
                    }
                    Response.Redirect("article.aspx?r=" + n);
                }
            }
            else
            {
                int newid = bl.Deliver(info, isDraft);
                //ID뵽ճ
                string calid=Request.Form["calid"];
                if(!string.IsNullOrEmpty(calid))
                {
                    setCarATCCal(newid, int.Parse(calid));
                }
                
                this.HidBlogId.Value = newid.ToString();
                if (!isDraft)
                {
                    NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                    us.updateinte(UserID, 2, 0, 0,"־");
                    Response.Redirect("article.aspx?r=" + newid);
                }
            }
            if (isDraft)
            {
                this.DivDS.Visible = true;
            }
        }

        protected void BtnDel_Click(object sender, EventArgs e)
        {
            int id = int.Parse(this.HidBlogId.Value);
            NetSNS.BLL.User.Blog bl = new NetSNS.BLL.User.Blog();
            if (this.HidIsDraft.Value == "1")
            {
                bl.DelDraft(UserID, id);
                Response.Redirect("draft.aspx");
            }
            else
            {
                bl.DelBlog(UserID, id);
                User us = new User();
                us.updateinte(UserID, 2, 0, 1, "ɾ־");
                Response.Redirect("myblog.aspx");
            }
        }
        /// <summary>
        /// òID뵽ѻճ
        /// </summary>
        /// <param name="blogid">ID</param>
        /// <param name="calid">ճID</param>
        protected void setCarATCCal(int blogid,int calid)
        {
            if (calid == 0)
                return;
            CarATCCalInfo caci = new CarATCCalInfo();
            CarATCCal cac = new CarATCCal();
            caci = cac.GetInfo(calid);
            caci.LogIDS += "," + blogid;
            cac.Update(caci);
        }
    }
}
