using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.blog
{
    public partial class userblog : NetSNS.Web.UI.Page.UserPage
    {
        protected int uid;
        protected string uname;
        protected bool istit = false;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.QueryString["r"] != null && Request.QueryString["r"].Trim() != string.Empty)
                {
                    uid = int.Parse(Request.QueryString["r"]);
                    if (uid == UserID)
                        Response.Redirect("myblog.aspx");
                }
                else
                {
                    Response.Redirect("myblog.aspx");
                }
                NetSNS.BLL.User.User us = new User();
                UserInfo info = us.GetUserInfo(uid);
                this.ImgPortrait.Alt = info.Username;
                this.ImgPortrait.Src = GetSmallHeadPic(info.PortraitDir, 1, info.UserID);
                uname = info.Username;
                BindData();
                DataBind();
            }
        }
        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            DataTable dt = UtilPage.GetPage("blog_user_list", PageIndex, PAGESZ, out ReCount, out PgCount, new SqlConditionInfo("@UserID", uid, TypeCode.Int32));
            string PageUrl = "userblog.aspx?r=" + uid;

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["Content"] = dt.Rows[i]["Content"].ToString().Replace("\r\n", "<br/>");
            }
                if (Request.QueryString["a"] != null && Request.QueryString["a"].ToLower() == "archive")
                {
                    this.RptImpact.DataSource = dt;
                    this.RptImpact.DataBind();
                    istit = true;
                    this.RptData.Visible = false;
                    PageUrl += "&a=archive";
                }
                else
                {
                    this.RptData.DataSource = dt;
                    this.RptData.DataBind();
                    this.RptImpact.Visible = false;
                }
            this.LtrNum.Text = ReCount.ToString();
            if (ReCount > PAGESZ)
            {
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, PageUrl);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }
    }
}
