﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using System.Collections.Generic;
using NetSNS.Common;
using NetSNS.Config;
using System.Text;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.buyfriend
{
    public partial class rank : NetSNS.Web.UI.Page.UserPage
    {
        SellFriend sf = new SellFriend();
        /// <summary>
        /// 我的游戏属性
        /// </summary>
        protected SellPropertyInfo Myproperty;

        protected int[] r = { 0, 0, 0, 0 };
        protected void Page_Load(object sender, EventArgs e)
        {
            r[3] = this.UserID;
            int.TryParse(Request.QueryString["r[0]"], out r[0]);
            int.TryParse(Request.QueryString["r[1]"], out r[1]);
            if (!int.TryParse(Request.QueryString["r[2]"], out r[2]))
            {
                r[2] = 2;
            }
            setMyproperty();
            setClass();
            setPage();
            setH2title();
            this.DataBind();
        }

        /// <summary>
        /// 设置我的信息
        /// </summary>
        protected void setMyproperty()
        {
            Myproperty = sf.GetUserProperty(this.UserID);
            if (Myproperty.UserID == 0)
            {
                Response.Redirect("index.aspx?url=" + Server.UrlEncode(Request.Url.ToString()));
            }
        }
        /// <summary>
        /// 分页显示
        /// </summary>
        protected void setPage()
        {
            int page=1;
            int.TryParse(Request.QueryString["page"],out page);
            int Recordcount;
            int PageCount;
            string PageUrl = string.Format("?r[0]={0}&r[1]={1}&r[2]={2}", r[0], r[1], r[2]);            
            DataTable dt = UtilPage.GetSellPage(r, page, PAGESZ, out Recordcount, out PageCount);
            try
            {
                dt.Columns.Add("Profit", typeof(int));
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    dt.Rows[i]["Profit"] = 0;
                }
            }
            catch { }
            this.rankdata.DataSource = dt;
            this.rankdata.DataBind();
            if (Recordcount > PAGESZ)
            {
                this.DivPage.Visible = true;
                this.DivPage.InnerHtml = PageNavigator.Pagination(page, PageCount, PageUrl);
            }
            else
            {
                this.DivPage.Visible = false;
            }
            dt.Dispose();
        }
        /// <summary>
        /// 取用户名
        /// </summary>
        /// <param name="userid">用户ID</param>
        /// <returns></returns>
        protected string getUsername(object userid)
        {
            string ts = "";
            try
            {
                User u = new User();
                UserInfo ui = u.GetUserInfo((int)userid);
                ts = ui.Username;
            }
            catch { }
            return ts;
        }
        protected string parsemoney(object money)
        {
            return Public.ParseMoney((int)money);
        }
        protected void setClass()
        {

            HtmlAnchor ha = (HtmlAnchor)this.FindControl("a" + r[0]);
            ha.Attributes.Add("class", "current");

            ha = (HtmlAnchor)this.FindControl("c" + r[2]);
            ha.Attributes.Add("class", "current");

            ha = (HtmlAnchor)this.FindControl("b" + r[1]);
            ha.Attributes.Add("class", "current");
            int i;
            for (i = 0; i <= 4; i++)
            {
                ha = (HtmlAnchor)this.FindControl("a" + i);
                ha.HRef = "?r[0]=" + i + "&r[1]=" + r[1] + "&r[2]=" + r[2] + "";
            }
            for (i = 0; i <= 2; i++)
            {
                ha = (HtmlAnchor)this.FindControl("c" + i);
                ha.HRef = "?r[0]=" + r[0] + "&r[1]=" + r[1] + "&r[2]=" + i + "";
            }
            for (i = 0; i <= 2; i++)
            {
                ha = (HtmlAnchor)this.FindControl("b" + i);
                ha.HRef = "?r[0]=" + r[0] + "&r[1]=" + i + "&r[2]=" + r[2] + "";
            }
        }
        protected void setH2title()
        {
            string str = string.Empty;
            switch (r[0])
            {
                case 0:
                    str = "每日收益排行榜";
                    break;
                case 1:
                    str = "身价排行榜";
                    break;
                case 2:
                    str = "资产排行榜";
                    break;
                case 3:
                    str = "现金排行榜";
                    break;
                case 4:
                    str = "最近活跃";
                    break;
            }
            this.h2title.InnerHtml = str;
        }
        protected string iif(bool b, string str1, string str2)
        {
            if (b)
                return str1;
            else
                return str2;
        }
        protected string ParseSlave(int whos)
        {
            return sf.ParseSlave(whos, this.UserID);
        }
    }
}
