using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Common;
using NetSNS.BLL.User;
namespace NetSNS.Web.user.car
{
    public partial class CalUpdate : NetSNS.Web.UI.Page.UserPage
    {
        string calid = string.Empty;
        CarATCCalInfo caci = new CarATCCalInfo();
        CarATCInfo cai = new CarATCInfo();
        protected void Page_Load(object sender, EventArgs e)
        {
            calid = Input.Filter(Request.QueryString["calid"]);
            if (string.IsNullOrEmpty(calid))
                PageError("", Request.RawUrl);
            setCaci();
            setCai();
            if (!check(cai.UserID))
                PageError("ǻˣܴճ", "atccal.aspx?hid=" + cai.HID);
            init();
        }

        protected bool check(string userids)
        {
            string[] ids = userids.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {
                if (ids[i] == this.UserID.ToString())
                    return true;
            }
            return false;
        }

        protected void setCai()
        {
            CarATC cac = new CarATC();
            cai = cac.GetInfo(caci.HID);
        }

        protected void setCaci()
        {
            int id = int.Parse(calid);
            CarATCCal cac = new CarATCCal();
            caci = cac.GetInfo(id);
        }

        protected void init()
        {
            this.name.Value = caci.CName;
            this.desc.Value = caci.CDesc;
            this.sleep.Value = caci.CSleep;
            this.tr.Value = caci.CTr;
            this.trs.Value = caci.CTrs;
            this.mapparam.Value = caci.MapParam;
            this.hid_calid.Value=caci.ID.ToString();
        }

        protected void Submit1_ServerClick(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                caci.CName = Request.Form["name"];
                caci.CDesc = Request.Form["desc"];
                caci.CSleep = Request.Form["sleep"];
                caci.CTr = Request.Form["tr"];
                caci.CTrs = Request.Form["trs"];
                caci.ID = int.Parse(Request.Form["hid_calid"]);
                caci.MapParam = Request.Form["mapparam"];
                if (string.IsNullOrEmpty(caci.CName))
                {
                    Response.Write("<script type=\"text/javascript\">alert(\"ճƲΪ!\");history.go(-1);</script>");
                    Response.End();
                    return;
                }
                if (string.IsNullOrEmpty(caci.MapParam))
                {
                    Response.Write("<script type=\"text/javascript\">alert(\"ͼΪ!\");history.go(-1);</script>");
                    Response.End();
                    return;
                }
                CarATCCal cac = new CarATCCal();
                cac.Update(caci);
                Response.Redirect("atccal.aspx?hid=" + caci.HID + "&sucmsg=" + Server.UrlEncode("ճϢɹ"));
            }
        }
    }
}
