using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using System.Collections.Generic;
using NetSNS.BLL.User;
using NetSNS.Web.UI.Control;
using NetSNS.Common;

namespace NetSNS.Web.user.car
{
    public partial class areaclub : NetSNS.Web.UI.Page.UserPage
    {
        CarClubUser clubuser = new CarClubUser();
        CarATC atc = new CarATC();
        Dict dict = new Dict();
        protected string province = string.Empty;
        protected string cityarray = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            #region ʡ
            if (!IsPostBack)
            {
                Dict dict = new Dict();
                IList<DictAreaInfo> list = dict.GetArea();
                foreach (DictAreaInfo info in list)
                {
                    if (info.ParentID.Equals(0))
                    {
                        province += "<option value=\"" + info.ID + "\">" + info.Name + "</option>";
                    }
                    else
                    {
                        if (!cityarray.Equals(string.Empty))
                            cityarray += ",";
                        cityarray += "new Array('" + info.ParentID + "','" + info.ID + "','" + info.Name + "')";
                    }
                } DataBind();
            }
            #endregion
            databind();
        }

        protected void databind()
        {
            string province = Request.QueryString["province"];
            string city = Request.QueryString["city"];
            int pro=0;
            int cit=0;
            string pstr = string.Empty;
            string cstr = string.Empty;
            if (!string.IsNullOrEmpty(province))
            {
                pro = int.Parse(province);
                pstr = getAera(pro);
            }
            if (!string.IsNullOrEmpty(city))
            {
                cit = int.Parse(city);
                cstr = getAera(cit);
            }
            int PageSize=30;
            int PageIndex=1;
            int RecordCout=0;
            int PageCout=0;
            try
            {
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            }
            catch{}
            string goUrl = "areaclub.aspx?province="+province+"&city="+city;
            bool tf = false;
            DataTable dt = NetSNS.BLL.User.UtilPage.GetAreaClubPage(pro, cit, PageIndex, PageSize, out RecordCout, out PageCout);
            if (dt != null)
            {
                Rpt_clublist.DataSource = dt;
                Rpt_clublist.DataBind();
                dt.Clear();
                dt.Dispose();                
            }
            //жǷ÷ҳ
            if (RecordCout > PageSize)
            {
                DivPage.Visible = true;
                DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PageCout, goUrl);
            }
            if (tf)
            {
                if (pstr == string.Empty && cstr == string.Empty)
                {
                    P_Result.InnerHtml = RecordCout + " ѻ  |  <a href=\"clublist.aspx\">гѻб</a>";
                }
                else
                {
                    P_Result.InnerHtml = RecordCout + " " + pstr + "" + cstr + "ĳѻ  |  <a href=\"clublist.aspx\">гѻб</a>";
                }
            }
            if (RecordCout == 0 && tf)
            {
                DivResult.Visible = true;
                if (pstr == string.Empty && cstr == string.Empty)
                {
                    DivResult.InnerHtml = "<p>ûҵѻ</p>";
                }
                else
                {
                    DivResult.InnerHtml = "<p>ûҵ" + pstr + "" + cstr + "ĳѻ</p>";
                }
            }
        }

        /// <summary>
        /// ȡǷȨ޲
        /// </summary>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        protected string getOp(object ClubID)
        {
            string s_Op = "";
            if (clubuser.isAdmin(UserID, Convert.ToInt32(ClubID)) == true)
            {
                s_Op = "<ul class=\"actions\"><li><a href=\"step1.aspx?id=" + ClubID.ToString() + "\">óѻ</a></li></ul>";
            }
            return s_Op;
        }

        /// <summary>
        /// ȡù
        /// </summary>
        /// <param name="Bulletin"></param>
        /// <returns></returns>
        protected string getclubAnnounce(object clubAnnounce)
        {
            string s_clubAnnounce = "";
            if (clubAnnounce != null && clubAnnounce.ToString() != "")
                s_clubAnnounce = "<span class=\"notice-title\">棺</span>" + Input.HtmlEncode(clubAnnounce.ToString());
            return s_clubAnnounce;
        }

        /// <summary>
        /// ȡóѻٳԱ
        /// </summary>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        protected string getMemberCnt(object ClubID)
        {
            return clubuser.Count(Convert.ToInt32(ClubID)).ToString();
        }

        /// <summary>
        /// ȡóѻжٸ
        /// </summary>
        /// <param name="ClubID"></param>
        /// <returns></returns>
        protected string getAtcCnt(object ClubID)
        {
            return atc.Count(Convert.ToInt32(ClubID)).ToString();
        }

        /// <summary>
        /// ȡõ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        protected string getAera(object id)
        {
            return dict.GetAreaName(Convert.ToInt32(id));
        }
    }
}
