using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using NetSNS.Model;
using NetSNS.Web.UI.Control;
using NetSNS.Common;
using NetSNS.BLL.User;

namespace NetSNS.Web.user.car
{
    public partial class club : NetSNS.Web.UI.Page.UserPage
    {
        private int clubid = 0;
        int cnt = 0;
        public CarClub carclub = new CarClub();
        public CarClubInfo clubinfo = new CarClubInfo();
        public CarClubUser caruser = new CarClubUser();
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";

            string id = Request.QueryString["id"];
            if (id == null || id == "")
                PageError("ݴ!", "clublist.aspx");
            clubid = Convert.ToInt32(id);
            clubinfo = carclub.Info(clubid);

            if (clubinfo.isLock == EnumIsLock.Lock)
                PageError("˳ѻѱ!", "clublist.aspx");

            cnt = caruser.Count(clubid);
            Operate();
            getInfo();
            setMyAlbum();
            this.atcadd.HRef = "atcadd.aspx?clubid=" + clubid;
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            Lit_name.Text = clubinfo.clubName;
            Lit_clubAnnounce.Text = Input.HtmlEncode(clubinfo.clubAnnounce);
            Li_clubDesc.Text = Input.HtmlDecode(clubinfo.clubDesc);

            Lit_UCnt.Text = cnt.ToString();

            A_AllMember.HRef = "memberlist.aspx?id=" + clubid;
            atcadd.HRef = "atcadd.aspx?clubid=" + clubid;
            LoadOp();
            LoadAtcList();
            LoadMemberList();
            LoadAdminList();
        }

        /// <summary>
        /// ز
        /// </summary>
        protected void LoadOp()
        {
            string tempop = "<li><a href=\"atclist.aspx?id=" + clubid + "\">鿴л</a></li>";
            tempop += "<li><a href=\"/user/group/group.aspx?GroupID=" + clubinfo.GroupID + "\"></a></li>";
            //жǷǹԱ
            if (caruser.isAdmin(UserID, clubid))
            {
                tempop += "<li><a href=\"step1.aspx?id=" + clubid + "\">óѻ</a></li>";
                tempop += "<li><a href=\"step2.aspx?id=" + clubid + "\">Ա</a></li>";
                if (cnt == 1)
                    tempop += "<a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪ˳˳ѻ</li></ul>','˳',function (){self.location='?action=exit&id=" + clubid + "';})\">˳˳ѻ</a></li>";
            }
            else
            {
                //жǲǴ˳ѻԱ
                if (caruser.isClubUser(UserID, clubid))
                {
                    if (!caruser.IsAdopt(UserID, clubid))
                    {
                        tempop += "<li>ȴ</li>";
                    }
                    else
                    {
                        tempop += "<a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪ˳˳ѻ</li></ul>','˳',function (){self.location='?action=exit&id=" + clubid + "';})\">˳˳ѻ</a></li>";
                    }
                }
                else
                {
                    switch (clubinfo.privacyFlag)
                    {
                        case EnumCarClubPrivacy.ForEveryOne:
                            tempop += "<li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪֱӼ˳ѻ</li></ul>','',function (){self.location='?action=join&id=" + clubid + "';})\">ֱӼ</a></li></li>";
                            break;
                        case EnumCarClubPrivacy.ForCheck:
                            tempop += "<li><a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'<ul><li>ȷҪ˳ѻ</li></ul>','',function (){self.location='?action=join&id=" + clubid + "';})\"></a></li>";
                            break;
                        case EnumCarClubPrivacy.ForDenied:
                            break;
                    }

                }
            }
            ul_Op.InnerHtml = tempop;
        }


        /// <summary>
        /// ػҳ
        /// </summary>
        /// <param name="PageIndex">ǰҳ</param>
        protected void LoadAtcList()
        {
            DivPage.Visible = false;
            int r, p, PageIndex = 0;
            PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo st = new SqlConditionInfo("@ClubID", clubid, TypeCode.Int32);

            DataTable dt = NetSNS.BLL.User.UtilPage.GetPage("atclist2_aspx", PageIndex, 20, out r, out p, st);
            if (dt != null)
            {
                Rpt_AtcList.DataSource = dt;
                Rpt_AtcList.DataBind();
                dt.Clear();
                dt.Dispose();
            }
            //жǷ÷ҳ
            if (r > 20)
            {
                DivPage.Visible = true;
                DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, p, "atclist2.aspx?id=" + clubid);
            }
            Lit_Cnt.Text = r.ToString();
        }

        /// <summary>
        /// سԱб
        /// </summary>
        protected void LoadMemberList()
        {
            DataTable dt = caruser.UserList(clubid);
            if (dt != null)
            {
                Rpt_MemberList.DataSource = dt;
                Rpt_MemberList.DataBind();
                dt.Clear();
                dt.Dispose();
            }
        }

        /// <summary>
        /// عԱб
        /// </summary>
        protected void LoadAdminList()
        {
            DataTable dt = caruser.AdminList(clubid);
            if (dt != null)
            {
                Rpt_ClubAdminList.DataSource = dt;
                Rpt_ClubAdminList.DataBind();
                dt.Clear();
                dt.Dispose();
            }
        }

        /// <summary>
        /// ȡûͷַ
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns></returns>
        protected string getHead(object FilePath,object userid)
        {
            return GetSmallHeadPic(FilePath, 1,(int)userid);
        }

        /// <summary>
        /// жǷ񴴽
        /// </summary>
        /// <param name="UID">û</param>
        /// <returns></returns>
        protected string getGradeName(object UID)
        {
            string s_Name = "";
            if (clubinfo.UserID == Convert.ToInt32(UID))
                s_Name = "";
            return s_Name;
        }


        /// <summary>
        /// ȡûƬ
        /// </summary>
        /// <param name="albumid">ID</param>
        /// <returns></returns>
        protected string getAlbum(object albumid)
        {
            if (albumid == null)
                return "";
            int abid = Convert.ToInt32(albumid);
            BLL.User.Album ab = new NetSNS.BLL.User.Album();
            AlbumInfo info = new AlbumInfo();
            info = ab.Info(abid);
            StringBuilder sb = new StringBuilder();
            sb.Append("<p class=\"image\">\n");
            sb.Append("                            <a href=\"../album/AlbumView.aspx?r[1]=" + abid + "\">\n");
            sb.Append("                                <img alt=\"" + info.Title + "\" title=\"" + info.Title + "\" src=\"" + this.GetSmallPic(ab.CoverPath(abid), 1) + "\" /></a></p>\n");
            return sb.ToString();
        }

        /// <summary>
        /// б
        /// </summary>
        /// <param name="hid">ID</param>
        protected void setMyAlbum()
        {
            CarATCCal atccal = new CarATCCal();
            DataTable tempdt = atccal.AlbumList(clubid, 5);
            DataTable dt = new DataTable();
            dt.Columns.Add("d", typeof(string));
            for (int i = 0; i < tempdt.Rows.Count; i++)
            {
                DataRow dr = dt.NewRow();
                dr["d"] = getAlbum((object)tempdt.Rows[i]["AlbumID"]);
                dt.Rows.Add(dr);
            }
            this.myalbum.DataSource = dt;
            this.myalbum.RepeatColumns = 3;
            this.myalbum.RepeatDirection = RepeatDirection.Vertical;
            this.myalbum.DataBind();
            dt.Dispose();
        }


        /// <summary>
        /// ز
        /// </summary>
        protected void Operate()
        {
            string s_Act = Request.QueryString["action"];
            int n = 0;
            if (s_Act != null && s_Act != "")
            {
                switch (s_Act)
                {
                    case "join":
                        if (clubinfo.privacyFlag == EnumCarClubPrivacy.ForDenied)
                            PageError("˳ѻܾκ˼", "clubinfo.aspx?id=" + clubid);
                        CarClubUserInfo clubuserinfo = new CarClubUserInfo();
                        clubuserinfo.ID = 0;
                        clubuserinfo.UserID = UserID;
                        clubuserinfo.ClubID = clubid;
                        clubuserinfo.isAdmin = 0;
                        if (clubinfo.privacyFlag == EnumCarClubPrivacy.ForCheck)
                            clubuserinfo.State = 1;
                        else
                            clubuserinfo.State = 0;
                        n = caruser.Add(clubuserinfo);
                        if (n == 1)
                            Response.Redirect("clubinfo.aspx?id=" + clubid);
                        else
                            PageError("복ѻʧ!", "clublist.aspx");
                        break;
                    case "exit":
                        if (clubinfo.UserID == UserID && cnt == 1)
                            n = carclub.Del(clubid, UserID);
                        else
                            n = caruser.Del(UserID, clubid);
                        Response.Redirect("clublist.aspx");
                        break;
                }
            }
        }
    }
}
