using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using System.Collections.Generic;


namespace NetSNS.Web.user.car
{
    public partial class index : NetSNS.Web.UI.Page.UserPage
    {
        protected string province = string.Empty;
        protected string cityarray = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            #region ʡ
            if (!IsPostBack)
            {
                Dict dict = new Dict();
                IList<DictAreaInfo> list = dict.GetArea();
                foreach (DictAreaInfo info in list)
                {
                    if (info.ParentID.Equals(0))
                    {
                        province += "<option value=\"" + info.ID + "\">" + info.Name + "</option>";
                    }
                    else
                    {
                        if (!cityarray.Equals(string.Empty))
                            cityarray += ",";
                        cityarray += "new Array('" + info.ParentID + "','" + info.ID + "','" + info.Name + "')";
                    }
                } DataBind();
            }
            #endregion
            setNewAlbum();
            setNewAtc();
            setMyClub();
            setNewClub();
            setNewLog();
            setRecClub();
        }

        /// <summary>
        /// Ƽѻ
        /// </summary>
        protected void setRecClub()
        {
            CarClub cc = new CarClub();
            List<CarClubInfo> list = cc.RecommendClubList();
            DataTable dt = new DataTable();
            dt.Columns.Add("pic", typeof(string));
            dt.Columns.Add("name", typeof(string));
            dt.Columns.Add("link", typeof(string));
            dt.Columns.Add("desc", typeof(string));
            for (int i = 0; i < list.Count; i++)
            {
                if (i == 4)
                    break;
                CarClubInfo info=list[i];
                DataRow dr = dt.NewRow();
                dr["pic"] = cc.GetClubPic(info.id);
                dr["name"] = info.clubName;
                dr["link"] = "clubinfo.aspx?id="+info.id;
                dr["desc"] = info.clubDesc;
                dt.Rows.Add(dr);
            }
            this.reclub.DataSource = dt;
            this.reclub.DataBind();
        }
        /// <summary>
        /// Ƭ
        /// </summary>
        protected void setNewAlbum()
        {
            CarClub cc = new CarClub();
            List<PhotoInfo> list = cc.NewPhotos(8);
            this.newphotos.DataSource = list;
            this.newphotos.DataBind();
        }

        protected string filterName(object name)
        {
            string n = Convert.ToString(name);
            if (string.IsNullOrEmpty(n))
            {
                return "û";
            }
            return n;
        }
        /// <summary>
        /// ò־
        /// </summary>
        protected void setNewLog()
        {
            CarATCCal cac = new CarATCCal();
            string ids = cac.GetCalBlog(0);
            string[] idss=ids.Split(',');
            Array.Sort(idss);
            Array.Reverse(idss);
            List<BlogInfo> list = new List<BlogInfo>();
            for (int i = 0; i < idss.Length; i++)
            {
                if (i == 30)
                    break;
                try
                {
                    int id = int.Parse(idss[i]);
                    Blog blo = new Blog();
                    BlogInfo bi = blo.GetBlog(id, false);
                    list.Add(bi);
                }
                catch
                {
                    continue;
                }
            }
            this.newLOG.DataSource = list;
            this.newLOG.DataBind();
        }
        protected string getarea(object userid)
        {
            BLL.User.User us = new User();
            int ct = us.GetUserCity(Convert.ToInt32(userid));
            Dict d = new Dict();
            return d.GetAreaName(ct);
        }
        protected UserInfo getUserInfo(object userid)
        {
            BLL.User.User us = new User();
            UserInfo ui = us.GetUserInfo(Convert.ToInt32(userid));
            return ui;
        }
        protected string fixBlogContent(object content)
        {
            string cc=Convert.ToString(content);
            string img=string.Empty;
            string str=string.Empty;
            Common.Input.splitImgAndText(cc, out img, out str);
            if (str.Length > 50)
            {
                return str.Substring(0, 47) + "...";
            }
            else
            {
                return str;
            }
        }
        protected string blogCommentsCount(object comments)
        {
            int num = Convert.ToInt32(comments);
            if (num == 0)
            {
                return "û";
            }
            else
            {
                return num + "";
            }
        }
        /// <summary>
        /// »
        /// </summary>
        protected void setNewAtc()
        {
            CarATC cac = new CarATC();
            List<CarATCInfo> list = cac.NewAtc(5);
            this.newAtc.DataSource = list;
            this.newAtc.DataBind();
        }
        /// <summary>
        /// ³ѻ
        /// </summary>
        protected void setNewClub()
        {
            CarClub cc = new CarClub();
            List<CarClubInfo> list = cc.NewClub(10);
            this.newClub.DataSource = list;
            this.newClub.DataBind();
        }
        /// <summary>
        /// ³ѻ
        /// </summary>
        protected void setMyClub()
        {
            CarClub cc = new CarClub();
            List<CarClubInfo> list = cc.MyClub(this.UserID,10);
            this.myClub.DataSource = list;
            this.myClub.DataBind();
        }
    }
}
