using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Web.UI.Control;
using NetSNS.Common;
using NetSNS.BLL.User;

namespace NetSNS.Web.user.car
{
    public partial class memberlist : NetSNS.Web.UI.Page.UserPage
    {
        private int clubid = 0;
        public CarClub carclub = new CarClub();
        public CarClubInfo clubinfo = new CarClubInfo();
        public CarClubUser caruser = new CarClubUser();
        public Friend friend = new Friend();
        public MiniBlog blog = new MiniBlog();
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            getInfo();
            LoadList();
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            string id = Request.QueryString["id"];
            if (id == null || id == "")
                PageError("ݴ!", "clublist.aspx");

            clubid = Convert.ToInt32(id);
            clubinfo = carclub.Info(clubid);

            if (clubinfo.isLock == EnumIsLock.Lock)
                PageError("˳ѻѱ!", "clublist.aspx");

            Lit_name.Text = clubinfo.clubName;
            A_ClubMember.HRef = "memberlist.aspx?id=" + clubid;
            A_ReturnClub.HRef = "clubinfo.aspx?id=" + clubid;
            Lit_ClubMemCnt.Text = caruser.Count(clubid).ToString();
            Hid_ClubID.Value = clubid.ToString();
        }

        /// <summary>
        /// طҳ
        /// </summary>
        /// <param name="PageIndex">ǰҳ</param>
        protected void LoadList()
        {
            DivPage.Visible = false;
            int r, p, PageIndex = 0;
            PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo st = new SqlConditionInfo("@ClubID", clubid, TypeCode.Int32);

            DataTable dt = NetSNS.BLL.User.UtilPage.GetPage("clubmemberlist_aspx", PageIndex, PAGESZ, out r, out p, st);
            if (dt != null)
            {
                Rpt_ClubMemList.DataSource = dt;
                Rpt_ClubMemList.DataBind();
                dt.Clear();
                dt.Dispose();
            }
            //жǷ÷ҳ
            if (r > PAGESZ)
            {
                DivPage.Visible = true;
                DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, p, "clubmemberlist.aspx?id=" + Hid_ClubID.Value);
            }
        }

        /// <summary>
        /// ȡBLOG
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        protected string getBlog(object userId)
        {
            string s_Blog = "";

            MiniBlogInfo bloginfo = blog.GetLastInfo(UserID, Convert.ToInt32(userId));
            if (bloginfo.ID > 0)
                return bloginfo.Content + " <span class=\"time\">" + NetSNS.Common.Public.getTimeSpan(bloginfo.PostTime) + "</span>";
            else
                return string.Empty;
        }

        /// <summary>
        /// ȡûԱϢ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        protected string getSchool(object UserID)
        {
            string s_School = "";
            string s_Academy = "";
            User user = new User();
            UserEducationInfo educinfo = new UserEducationInfo();
            educinfo = user.LastEducInfo(Convert.ToInt32(UserID));
            DictSchoolInfo schoolinfo = new DictSchoolInfo();
            schoolinfo = user.GetSchoolInfo(educinfo.SchoolID);

            if (educinfo.DegreeID >= 3 && educinfo.AcademyID != 0)
            {
                DictAcademyInfo AcademyInfo = new DictAcademyInfo();
                AcademyInfo = user.GetAcademyInfo(educinfo.AcademyID);
                s_Academy = " - " + AcademyInfo.Name;
            }
            if (educinfo.DegreeID > 0)
            {
                if (educinfo.MatriculationYear > 0)
                {
                    s_School = "<tr><th>" + getDegreeName(educinfo.DegreeID) + "</th>" +
                               "<td align=\"left\">" + schoolinfo.SchoolName + s_Academy + " " +
                               "<span class=\"time\">(" + educinfo.MatriculationYear.ToString() + "ѧ)</span></td></tr>";
                }
                else
                {
                    s_School = "<tr><th>" + getDegreeName(educinfo.DegreeID) + "</th>" +
                               "<td align=\"left\">" + schoolinfo.SchoolName + s_Academy + " " +
                               "</td></tr>";
                }
            }
            return s_School;
        }

        /// <summary>
        /// ȡѧ
        /// </summary>
        /// <param name="DegreeID"></param>
        /// <returns></returns>
        protected string getDegreeName(int DegreeID)
        {
            string s_DegreeName = "";
            switch (DegreeID)
            {
                case 1:
                    s_DegreeName = "";
                    break;
                case 2:
                    s_DegreeName = "";
                    break;
                case 3:
                    s_DegreeName = "ѧ";
                    break;
                case 4:
                    s_DegreeName = "о";
                    break;
                case 5:
                    s_DegreeName = "ʿ";
                    break;
            }
            return s_DegreeName;
        }

        /// <summary>
        /// ȡò 
        /// </summary>
        /// <param name="UID">Ա</param>
        /// <param name="UserName">Ա</param>
        /// <param name="FilePath">ͷ</param>
        /// <returns></returns>
        protected string getOp(object UID, object UserName, object FilePath)
        {
            string s_Op = "";
            if (Convert.ToInt32(UID) == UserID)
            {
                s_Op = "<li><a href=\"/user/friend/List.aspx?r=" + UserID + "\">鿴</a></li>";
            }
            else
            {
                string s_Temp = "";
                switch (friend.GetRelation(UserID, Convert.ToInt32(UID)))
                {
                    case 0:
                        s_Temp = "<li id=\"LI" + UID.ToString() + "\"><a href=\"javascript:void(0);\" " +
                                 "onclick=\"javascript:AddFriend(" + UID.ToString() + ",'" + UserName + "'," +
                                 "'" + getHead(FilePath,UID) + "','LI" + UID.ToString() + "')\">" +
                                 "Ϊ</a></li>";
                        break;
                    case 1:
                        break;
                    case 2:
                        break;
                    case 3:
                        s_Temp = "<li>ȴ֤</li>";
                        break;
                    case 4:
                        s_Temp = "<li id=\"LI" + UID.ToString() + "\"><a href=\"javascript:void(0);\" " +
                                "onclick=\"javascript:AddFriend(" + UID.ToString() + ",'" + UserName + "'," +
                                "'" + getHead(FilePath,UID) + "','LI" + UID.ToString() + "')\">" +
                                "Ϊ</a></li>";
                        break;
                }
                s_Op = "<li><a href=\"/user/letter/writeletter.aspx?UserID=" + UID.ToString() + "\">˽</a></li>" +
                       "<li><a href=\"javascript:void(0);\" " +
                       "onclick=\"javascript:Greet(" + UID.ToString() + ",'" + UserName.ToString() + "','" + getHead(FilePath,UID) + "');\" " +
                       "class=\"complexlink poke-send\">к</a></li>" +
                       "<li><a href=\"/user/friend/List.aspx?r=" + UID.ToString() + "\">鿴</a></li>" + s_Temp;
            }
            return s_Op;
        }

        /// <summary>
        /// ȡûͷַ
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns></returns>
        protected string getHead(object FilePath,object userid)
        {
            return GetSmallHeadPic(FilePath, 2,(int)userid);
        }
    }
}
