using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using System.Collections.Generic;

namespace NetSNS.Web.user.car
{
    public partial class step1 : NetSNS.Web.UI.Page.UserPage
    {
        CarClub club = new CarClub();
        CarClubInfo clubinfo = new CarClubInfo();
        private string clubid = "";
        bool isedit = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            Check();
            DataBind();
            if (!Page.IsPostBack)
                getInfo();
        }

        /// <summary>
        /// зȨóѻ
        /// </summary>
        protected void Check()
        {
            clubid = Request.QueryString["id"];
            if (clubid != null && clubid != "")
            {
                isedit = true;
                CarClubUser caruser = new CarClubUser();
                if (caruser.isAdmin(UserID, Convert.ToInt32(clubid)) == false)
                {
                    PageError("㲻ǹԱóѻϢ!", "atclist.aspx");
                }
                else
                {
                    clubName.Disabled = true;
                }
            }
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            Li_Step3.Visible = false;

            Dict dict = new Dict();
            IList<DictAreaInfo> list = dict.GetArea();
            foreach (DictAreaInfo info in list)
            {
                if (info.ParentID == 0)
                {
                    ListItem itm = new ListItem();
                    itm.Value = info.ID.ToString(); itm.Text = info.Name;
                    Province.Items.Add(itm);
                }
            }
            if (isedit)
            {
                Hid_ClubID.Value = clubid;
                clubinfo = club.Info(Convert.ToInt32(clubid));

                if (clubinfo.isLock == EnumIsLock.Lock)
                    PageError("˳ѻѱ!", "clublist.aspx");

                clubName.Value = clubinfo.clubName;
                clubAnnounce.Value = clubinfo.clubAnnounce;
                privacyFlag.Value = ((int)clubinfo.privacyFlag).ToString();
                Province.Text = clubinfo.Province.ToString();
                clubDesc.Value = NetSNS.Common.Input.ToTxt(clubinfo.clubDesc);
                H_title.InnerHtml = "޸ĳѻ";
                Title.InnerText = "޸ĳѻ";
                Submit1.Value = "޸ĳѻ";
            }
            IList<DictAreaInfo> list2 = dict.CityList(Convert.ToInt32(Province.Text));
            foreach (DictAreaInfo info in list2)
            {
                ListItem itm = new ListItem();
                itm.Value = info.ID.ToString(); itm.Text = info.Name;
                City.Items.Add(itm);
            }
            if (isedit)
            {
                City.Text = clubinfo.City.ToString();
                Li_Step1.InnerHtml = "<a href=\"step1.aspx?id=" + clubid + "\">һѻϢ</a>";
                Li_Step2.InnerHtml = "<a href=\"step2.aspx?id=" + clubid + "\">ڶѻԱ </a>";
                Li_Step3.Visible = true;
                Li_Step3.InnerHtml = "<a href=\"clubinfo.aspx?id=" + clubid + "\"></a>";
            }
        }

        protected void Submit1_ServerClick(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                bool tf = true;
                if (Hid_ClubID.Value != null && Hid_ClubID.Value != "")
                {
                    isedit = true;
                }
                else
                {
                    if (clubName.Value.Trim() == "")
                    {
                        tf = false;
                        ShowErr("ѻƲΪ", div_Error);
                        goto Finish;
                    }
                }
                #region ˹ؼ
                string res = NetSNS.Common.Public.CheckKey(this.clubAnnounce.Value.Trim(), true);
                if (res != "")
                {
                    ShowErr("ѻṫ治ܺ '" + res + "' ؼ֣", div_Error);
                    goto Finish;
                }
                res = NetSNS.Common.Public.CheckKey(this.clubDesc.Value.Trim(), true);
                if (res != "")
                {
                    ShowErr("ѻܲܺ '" + res + "' ؼ֣", div_Error);
                    goto Finish;
                }
                #endregion

                if (tf)
                {
                    if (isedit)
                        clubinfo.id = Convert.ToInt32(Hid_ClubID.Value);
                    else
                        clubinfo.id = 0;
                    clubinfo.UserID = UserID;
                    clubinfo.clubName = clubName.Value;
                    clubinfo.clubDesc = NetSNS.Common.Input.ToHtml(clubDesc.Value);
                    clubinfo.clubAnnounce = clubAnnounce.Value;
                    clubinfo.ischeck = 0;
                    clubinfo.GroupID = 0;
                    clubinfo.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(privacyFlag.Value);
                    clubinfo.Province = Convert.ToInt32(Request.Form["Province"]);
                    clubinfo.City = Convert.ToInt32(Request.Form["City"]);
                    clubinfo.CreatTime = DateTime.Now;
                    clubinfo.isLock = EnumIsLock.UnLock;
                    clubinfo.isRec = 0;

                    if (isedit == false)
                    {
                        int ID = club.Add(clubinfo);
                        if (ID > 0)
                            Response.Cookies["AddClubIsScu"].Value = "true";
                        Response.Redirect("step2.aspx?id=" + ID);
                    }
                    else
                    {
                        if (club.Edit(clubinfo) == 1)
                            Response.Cookies["EditClubIsScu"].Value = "true";
                        Response.Redirect("step2.aspx?id=" + Hid_ClubID.Value);
                    }
                }
            Finish:
                Dict dict = new Dict();
                IList<DictAreaInfo> list = dict.GetArea();
                foreach (DictAreaInfo info in list)
                {
                    if (info.ParentID == 0)
                    {
                        ListItem itm = new ListItem();
                        itm.Value = info.ID.ToString(); itm.Text = info.Name;
                        Province.Items.Add(itm);
                    }
                }
                Province.Text = Request.Form["Province"];
                IList<DictAreaInfo> list2 = dict.CityList(Convert.ToInt32(Province.Text));
                foreach (DictAreaInfo info in list2)
                {
                    ListItem itm = new ListItem();
                    itm.Value = info.ID.ToString(); itm.Text = info.Name;
                    City.Items.Add(itm);
                }
                City.Text = Request.Form["City"];
                ;
            }
        }
    }
}
