﻿//===========================================================
//==               (c)2008  NETSNS 1.0                ==
//==            website:www.aspxcms.com           ==
//==               Code By Arjun                           ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using System.Xml;
using NetSNS.Config;
using System.Collections.Generic;
namespace NetSNS.Web.user
{
    public partial class feed : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            int kid=0;
            try
            {
                kid=int.Parse(Request.QueryString["uid"]);
            }
            catch{}
            BLL.User.User u = new BLL.User.User();
            UserInfo ui=new UserInfo();
            if (kid != 0)
            {
                ui = u.GetUserInfoByKid(kid);
            }
            Response.Charset = "utf-8";
            Response.ContentEncoding = System.Text.UTF8Encoding.UTF8;
            Response.ContentType = "text/xml";
            XmlTextWriter writer = new XmlTextWriter(Response.Output);
            writer.Formatting = Formatting.Indented;
            writer.WriteStartDocument();
            writer.WriteStartElement("root");

            writer.WriteStartElement("userid");
            writer.WriteString(ui.UserID.ToString());
            writer.WriteEndElement();

            writer.WriteStartElement("kid");
            writer.WriteString(ui.Kid.ToString());
            writer.WriteEndElement();

            writer.WriteStartElement("username");
            writer.WriteString(ui.Username);
            writer.WriteEndElement();

            writer.WriteStartElement("email");
            writer.WriteString(ui.Email);
            writer.WriteEndElement();

            writer.WriteStartElement("head");
            writer.WriteString("http://" + Request.Url.Host + "/" + GetSmallHeadPic(ui.PortraitDir, 1));
            writer.WriteEndElement();

            writer.WriteStartElement("head1");
            writer.WriteString("http://" + Request.Url.Host + "/" + GetSmallHeadPic(ui.PortraitDir, 2));
            writer.WriteEndElement();

            writer.WriteStartElement("head2");
            writer.WriteString("http://" + Request.Url.Host + "/" + GetSmallHeadPic(ui.PortraitDir, 3));
            writer.WriteEndElement();

            writer.WriteStartElement("province");
            writer.WriteString(getarea(ui.Province));
            writer.WriteEndElement();

            writer.WriteStartElement("city");
            writer.WriteString(getarea(ui.City));
            writer.WriteEndElement();

            writer.WriteStartElement("logintimes");
            writer.WriteString(ui.LoginTimes.ToString());
            writer.WriteEndElement();

            writer.WriteStartElement("lastloginip");
            writer.WriteString(ui.LastLoginIp);
            writer.WriteEndElement();

            writer.WriteStartElement("lastlogintime");
            writer.WriteString(ui.LastLoginTime.ToLocalTime().ToString());
            writer.WriteEndElement();

            writer.WriteStartElement("regip");
            writer.WriteString(ui.RegIP);
            writer.WriteEndElement();


            writer.WriteStartElement("regtime");
            writer.WriteString(ui.RegTime.ToLocalTime().ToString());
            writer.WriteEndElement();

            writer.WriteEndDocument();
            Response.End();
        }

        /// <summary>
        /// 取得地域
        /// </summary>
        /// <param name="areaid">地域ID</param>
        /// <returns></returns>
        protected string getarea(int areaid)
        {
            Dict d = new Dict();
            return d.GetAreaName(areaid);
        }

        /// <summary>
        /// 转换头像路径为缩略路径
        /// </summary>
        /// <param name="orgPicPath">原始路径</param>
        /// <param name="size">缩小级别</param>
        /// <returns></returns>
        public string GetSmallHeadPic(object orgHeadPicPath, int size)
        {
            if (orgHeadPicPath == null || orgHeadPicPath == DBNull.Value)
                return GetSmallHeadPic((object)"default.jpg", size);
            if (orgHeadPicPath.ToString().Trim() == "")
                return GetSmallHeadPic((object)"default.jpg", size);
            string name = size.ToString();
            Dictionary<string, PicConfigInfo> _portrait = PicConfig.Portrait;
            string rvalue = string.Empty;
            try
            {
                rvalue = (string)orgHeadPicPath;
            }
            catch { }
            if (rvalue.Trim() == string.Empty)
                return string.Empty;
            if (_portrait[name].Directory.EndsWith("/"))
            {
                rvalue = _portrait[name].Directory + rvalue;
            }
            else
            {
                rvalue = _portrait[name].Directory + "/" + rvalue;
            }
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            return "/" + rvalue;
        }
    }
}
