using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using NetSNS.Web.UI.Control;
using NetSNS.Common;

namespace NetSNS.Web.user.friend
{
    public partial class searchend : NetSNS.Web.UI.Page.UserPage
    {
        protected string searchname;
        protected string list = string.Empty;
        protected string page = string.Empty;
        protected string recnum = string.Empty;
        NetSNS.BLL.User.MiniBlog mb = new NetSNS.BLL.User.MiniBlog();
        NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
        NetSNS.BLL.User.Friend frd = new Friend();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request["r"] == null || Request["r"].Trim() == string.Empty)
                {
                    Response.Redirect("search.aspx");
                }
                else
                {
                    searchname = Input.URLDecode(Request["r"].Trim());
                    BindData(searchname);
                    DataBind();
                }
            }
        }

        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData(string uname)
        {
            int ReCount, PgCount;
            int PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo con = new SqlConditionInfo("@UserName", uname, TypeCode.String);
            con.Blur = 3;
            DataTable dt = UtilPage.GetPage("friend_search", PageIndex, PAGESZ, out ReCount, out PgCount, con);
            if (ReCount > 0)
            {
                if (ReCount <= 500)
                    recnum = " " + ReCount;
                else
                    recnum = " " + ReCount;
                BindList(dt);
            }
            else
            {
                Response.Redirect("searchnone.aspx?r=" + uname);
            }

            //this.RptData.DataSource = dt;
            //this.RptData.DataBind();
            if (ReCount > PAGESZ)
            {
                page = "<div class=\"pagination\">" + PageNavigator.Pagination(PageIndex, PgCount, "searchend.aspx?r=" + Input.URLEncode(uname)) + "</div>";
            }
        }
        /// <summary>
        /// ȡռϢ
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        protected string GetLastMiniBlog(int friendid)
        {
            MiniBlogInfo info = mb.GetLastInfo(UserID, (int)friendid);
            if (info.ID > 0)
            {
                return "<tr><th>ռǣ</th><td>" + Input.HtmlDecode(info.Content) + " <span class=\"time\">" + Public.getTimeSpan(info.PostTime) + "</span></td></tr>";
            }
            else
            {
                return string.Empty;
            }
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="uid"></param>
        /// <returns></returns>
        protected string GetResume(int uid)
        {
            DataTable tb = us.GetCareer(UserID, (int)uid);
            if (tb == null || tb.Rows.Count < 1)
                return string.Empty;
            DataRow r = tb.Rows[0];
            string s = "<tr><th>˾</th><td>" + r["Company"] + "<span class=\"time\">(" + r["JoinYear"] + "-" + r["JoinMonth"] + " - ";
            if (r["LeaveYear"] == DBNull.Value || r["LeaveMonth"] == DBNull.Value)
                s += "";
            else
                s += r["LeaveYear"] + "-" + r["LeaveMonth"];
            s += ")</span></td></tr>";
            return s;
        }
        /// <summary>
        /// ȡѧϰ
        /// </summary>
        /// <param name="uid"></param>
        /// <returns></returns>
        protected string GetSchoolWork(int uid)
        {
            DataTable tb = us.GetEducation(UserID, (int)uid);
            if (tb == null || tb.Rows.Count < 1)
                return string.Empty;
            DataRow r = tb.Rows[0];
            string s = "<tr><th>" + EnumClass.GetEduGradeName((EnumStudyGrade)r["DegreeID"]) + "</th><td>" + r["SchoolName"] + " - " + r["Name"];
            if (r["MatriculationYear"] != DBNull.Value && (int)r["MatriculationYear"] > 0)
                s += " <span class=\"time\">(" + r["MatriculationYear"] + "ѧ)</span>";
            s += "</td></tr>";
            return s;
        }
        protected void BindList(DataTable dt)
        {
            foreach (DataRow r in dt.Rows)
            {

                int usid = (int)r["UserID"];

                //ͷ
                string headpicurl = GetSmallHeadPic(r["FilePath"], 2, usid);
                list += "<li>\r\n<div class=\"people\">\r\n";
                list += "<p class=\"image\"><a href=\"/user/space/?r=" + usid + "\">";
                list += "<img src=\"" + headpicurl + "\" alt=\"" + r["UserName"] + "\" /></a></p>\r\n";
                list += "<table class=\"info\">\r\n<caption>\r\n";
                list += "<a href=\"/user/space/?r=" + usid + "\">" + r["UserName"] + "</a> <span class=\"network\">(" + r["name"] + ")</span></caption>\r\n";
                list += GetResume(usid);
                list += GetSchoolWork(usid);
                list += GetLastMiniBlog(usid);
                list += "</table>\r\n";
                list += "<ul class=\"actions\">";
                if (usid != UserID) list += "<li><a href=\"../letter/writeletter.aspx?userid=" + r["UserID"] + "\">˽</a></li>\r\n";
                if (usid != UserID) list += "<li><a href=\"javascript:Greet('" + usid + "','" + r["UserName"] + "','" + headpicurl + "');\" class=\"complexlink poke-send\">к</a></li>\r\n";
                list += "<li><a href=\"list.aspx?r=" + usid + "\">鿴</a></li>\r\n";
                if (usid != UserID)
                {
                    int n = frd.GetRelation(UserID, usid);
                    if (n == 0)//κιϵ
                    {
                        list += "<li id=\"li_req_" + usid + "\"><a href=\"javascript:AddFriend(" + usid + ",'" + r["UserName"] + "','" + headpicurl + "','li_req_" + usid + "');\" class=\"complexlink friend-add\">Ϊ</a></li>\r\n";
                    }
                    else if (n == 3)//ѷ,ȴȷϺ
                    {
                        list += "<li>ȴ֤</li>";
                    }
                    else if (n == 4)//4
                    {
                        list += "<li><a href=\"/user/friend/frdconfirm.aspx\" class=\"complexlink friend-add\"></a></li>";
                    }
                }
                list += "</ul>\r\n</div>\r\n</li>\r\n";
            }
        }
    }
}
