using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;
using NetSNS.Config;

namespace NetSNS.Web.user
{
    public partial class index : NetSNS.Web.UI.Page.BasePage
    {
        public string SiteNames = string.Empty;
        protected string province = string.Empty;
        protected string cityarray = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            string G = Request.QueryString["g"];
            if (G != string.Empty && G != null)
            {
                switch (G)
                { 
                    case "car":
                        t1.InnerHtml = "<span style=\"padding:20px;color:Red;\">ѻἴƳڴ</span>";
                        break;
                    case "book":
                        t1.InnerHtml = "<span style=\"padding:20px;color:Red;\">ƵƳڴ</span>";
                        break;
                    case "taobao":
                        t1.InnerHtml = "<span style=\"padding:20px;color:Red;\">ԱƵƳڴ</span>";
                        break;
                    case "timeout":
                        t1.InnerHtml = "<span style=\"margin-top:50px;padding:5px;color:Red;font-size:14px;background-color:#FF6600;color:#fff;margin-left:5px;margin-bottom:8px;font-weight:bold;\">ҪԱܲ鿴ߵ¼</span>";
                        break;
                        
                }
            }
            #region ʡ
            if (!IsPostBack)
            {
                Dict dict = new Dict();
                IList<DictAreaInfo> list = dict.GetArea();
                foreach (DictAreaInfo info in list)
                {
                    if (info.ParentID.Equals(0))
                    {
                        province += "<option value=\"" + info.ID + "\">" + info.Name + "</option>";
                    }
                    else
                    {
                        if (!cityarray.Equals(string.Empty))
                            cityarray += ",";
                        cityarray += "new Array('" + info.ParentID + "','" + info.ID + "','" + info.Name + "')";
                    }
                } 
                DataBind();
            }
            #endregion

            RecUser.InnerHtml = RecUserList();
            //miniblogs.InnerHtml = miniblogList();
            SiteNames = NetSNS.Config.UiConfig.SiteName;
            HttpCookie cookieToken = Context.Request.Cookies["SnsUserToken"];
            if (cookieToken == null || cookieToken["token"] == null || cookieToken["token"] == "")
                return;
            string userCookie = cookieToken["token"];
            string desstr = DES.Decrypt(userCookie, SecretConfig.UserKey, SecretConfig.UserIV);
            string[] userInfo = desstr.Split(SecretConfig.UserSeparator);
            if (userInfo.Length == 3)
            {
                UserID = int.Parse(userInfo[0]);
                string pass = userInfo[1];
                string cookip = userInfo[2];
                if (cookip != Public.GetClientIP())
                {
                    return;
                }
                else
                {
                    NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                    EnumLoginState state = us.CheckLogin(UserID, pass);
                    if (state == EnumLoginState.Succeed)
                        Response.Redirect("default.aspx");
                }
            }
        }

        protected string miniblogList()
        {
            string listStr = "<ul style=\"float:left;\">";
            NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
            IDataReader dr = us.GetMiniBlog(6);
            while (dr.Read())
            {
                listStr += "<li style=\"float:left;\">";
                listStr += "<div class=\"mmleft\">";
                string TMPMTYPE = string.Empty;
                if (dr["mType"].ToString() != string.Empty && dr["mType"].ToString() != null)
                {
                    TMPMTYPE = "<span class=\"minitype\">[" + dr["mType"].ToString() + "]</span> ";
                }
                string gTime = string.Empty;
                if (NetSNS.Common.Input.IsDate(dr["postTime"].ToString()))
                {
                    gTime = DateTime.Parse(dr["postTime"].ToString()).ToShortDateString();
                }
                listStr += "<a href=\"/user/space/DefaultSpace.aspx?r="+dr["UserID"].ToString()+"\"><img src=\"" + GetHeadImage(Convert.ToInt32(dr["UserID"].ToString()), 1) + "\" style=\"width:48px;height:48px;\" /></a>";
                listStr += "</div>";
                listStr += "<div class=\"mmright\">";
                listStr += TMPMTYPE + dr["Content"].ToString() + "<a href=\"/user/miniblog/recentmini.aspx?mid=" + dr["ID"].ToString() + "#re_" + dr["ID"].ToString() + "\"> (ظ)</a> <span class=\"time\">" + gTime + "</span>";
                listStr += "</div>";
                listStr += "</li>";
            }
            dr.Close();
            return listStr+"</ul>";
        }

        /// <summary>
        /// ƼԱ
        /// </summary>
        /// <returns></returns>
        protected string RecUserList()
        {
            NetSNS.BLL.User.User UIndex = new NetSNS.BLL.User.User();
            string ListStr = string.Empty;
            IDataReader rd = UIndex.GetRecUser(2);
            while (rd.Read())
            {
                ListStr += "<li><a href=\"/user/space/DefaultSpace.aspx?r=" + rd["UserID"].ToString() + "\"><img title=\"" + rd["UserName"].ToString() + "\" src=\"" + GetHeadImage(Convert.ToInt32(rd["UserID"].ToString()), 1) + "\" /><span>" + rd["UserName"].ToString() + "</span></a><span>" + rd["Province1"].ToString() + rd["City1"].ToString() + " </span></li>\r\n";
            }
            rd.Close();
            return ListStr;
        }
    }
}
