using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.MySQL;
using NetSNS.DALSQLServer;
using System.Data.SqlClient;
using NetSNS.Model;
using MySql.Data.MySqlClient;
using NetSNS.DALProfile;

namespace NetSNS.Web.user
{
    public partial class jihuokanshu :NetSNS.Web.UI.Page.BasePage
    {
        Dbhelper dbhelper = Dbhelper.Instance();
        string m = string.Empty;
        string kid = string.Empty;
        string url = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            DbHelper.Provider = new DbBase();
            m = Request.QueryString["m"];
            kid = Request.QueryString["kid"];
            url = Request.QueryString["url"];
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void LinkButton1_Click(object sender, EventArgs e)
        {
            import();
            goUrl(url);
        }
        /// <summary>
        /// תָurl
        /// </summary>
        /// <param name="url"></param>
        protected void goUrl(string url)
        {
            Response.Redirect("/user/port.aspx?kid=" + kid + "&m=" + m + "&url=" + url);
        }
        /// <summary>
        /// ִе
        /// </summary>
        public void import()
        {
            string sql = "select * from jieqi_system_users where uid=" + kid + " ";
            MySqlDataReader dr = dbhelper.ExecuteReader(Dbhelper.connStr, sql, null); ;
            if (dr.Read())
            {
                string username = dr.GetString("uname");
                string email = dr.GetString("email");
                string password = dr.GetString("pass");
                string qq = dr.GetString("qq");
                string msn = dr.GetString("msn");
                string sex = dr.GetString("sex");
                string mobile = dr.GetString("mobile");
                string userid = dr.GetString("uid");

                if (NetSNS.Common.Input.MD5(email, false) != m)
                {
                    dr.Dispose();
                    Response.Redirect(Request.RawUrl);
                    Response.End();
                }
                ImportInfo info = new ImportInfo();
                info.UserName = username;
                info.UserPass = password;
                info.RegTime = DateTime.MinValue.AddYears(1900 - 1);
                info.UserEmail = email;
                info.RegIp = "";
                info.IP = "";
                info.IsLock = 0;
                info.LastLoginTime = DateTime.MinValue.AddYears(1900 - 1);
                info.Province = "";
                info.City = "";
                info.QQ = qq;
                info.Sex = sex;
                info.Kid = int.Parse(userid);
                info.LastLoginTime = DateTime.MinValue.AddYears(1900 - 1);
                try
                {
                    importSingle(info);                 
                }
                catch
                {
                    Response.Redirect(Request.RawUrl);
                    Response.End();
                }
            }
            dr.Dispose();
        }
        /// <summary>
        /// 뵥ûϢ
        /// </summary>
        /// <param name="info"></param>
        private void importSingle(ImportInfo info)
        {
            if (string.IsNullOrEmpty(info.UserEmail))
                return;
            string verifyCode = NetSNS.Common.Rand.Str(11);
            SqlConnection Conn = new SqlConnection(NetSNS.Config.DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[13];
                param[0] = new SqlParameter("@ReturnValue", SqlDbType.Int);
                param[0].Direction = ParameterDirection.ReturnValue;
                param[1] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                param[1].Value = info.UserEmail;
                param[2] = new SqlParameter("@IP", SqlDbType.Char, 15);
                param[2].Value = info.IP;
                param[3] = new SqlParameter("@Password", SqlDbType.NVarChar, 32);
                param[3].Value = info.UserPass;
                param[4] = new SqlParameter("@Username", SqlDbType.NVarChar, 50);
                param[4].Value = info.UserName;
                param[5] = new SqlParameter("@State", SqlDbType.Int, 4);
                param[5].Value = 5;
                param[6] = new SqlParameter("@Province", SqlDbType.Int, 4);
                param[6].Value = getAreaCode(info.Province);
                param[7] = new SqlParameter("@City", SqlDbType.Int, 4);
                if (string.IsNullOrEmpty(info.City))
                    param[7].Value = DBNull.Value;
                else
                    param[7].Value = getAreaCode(info.City);
                param[8] = new SqlParameter("@NowTime", SqlDbType.DateTime);
                param[8].Value = DateTime.Now;
                param[9] = new SqlParameter("@VerifyCode", SqlDbType.Char, 11);
                param[9].Value = verifyCode;
                param[10] = new SqlParameter("@EmailItem", SqlDbType.VarChar, 1000);
                param[10].Value = EnumClass.GetEmailNotifyStr();
                param[11] = new SqlParameter("@PrivDef", SqlDbType.Int);
                param[11].Value = 0;
                param[12] = new SqlParameter("@Kid", SqlDbType.Int);
                param[12].Value = info.Kid;
                DbHelper.ExecuteNonQuery(trans, CommandType.StoredProcedure, "NTP_Register", param);
                int retvalue = (int)param[0].Value;
                if (retvalue != 1 && retvalue != 2)
                {
                    string sql = "select userid from nt_user where Email=@Email";
                    int userid = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sql, param));
                    sql = "insert into [NT_UserInfo](UserID,Sex,QQ) values(" + userid + "," + info.Sex + ",'" + info.QQ + "')";
                    //ĬϺ
                    string dfriend = NetSNS.Config.UiConfig.defaultfriend;
                    string[] dfriendARR = null;
                    if (dfriend.IndexOf(",") > -1 || dfriend != string.Empty)
                    {
                        DateTime now = DateTime.Now;
                        string qsql = "select UserID from NT_User where Email=@Email";
                        int UserID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, qsql, param));
                        if (dfriend.IndexOf(",") > -1)
                        {
                            dfriendARR = dfriend.Split(',');
                            string iSQL = string.Empty;
                            string riSQL = string.Empty;
                            for (int j = 0; j < dfriendARR.Length; j++)
                            {
                                iSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + UserID + "," + dfriendARR[j].ToString() + ",0,'" + now.ToString() + "')";
                                int iCount = DbHelper.ExecuteNonQuery(trans, CommandType.Text, iSQL, null);

                                riSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + dfriendARR[j].ToString() + "," + UserID + ",0,'" + now.ToString() + "')";
                                int riCount = DbHelper.ExecuteNonQuery(trans, CommandType.Text, riSQL, null);
                            }
                        }
                        else
                        {
                            string reiSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + dfriend + "," + UserID + ",0,'" + now.ToString() + "')";
                            int reiCount = DbHelper.ExecuteNonQuery(trans, CommandType.Text, reiSQL, null);
                        }
                    }
                }
                else
                {
                    string sql = "select userid from nt_user where Email=@Email";
                    int userid = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sql, param));
                    sql = "Update nt_user set Kid=@Kid where Email=@Email";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                    sql = "update NT_UserInfo set Sex=" + info.Sex + ",QQ='" + info.QQ + "' where userid=" + userid + "";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                }
                trans.Commit();
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }
        /// <summary>
        /// ȡõ
        /// </summary>
        /// <param name="area"></param>
        /// <returns></returns>
        private int getAreaCode(string area)
        {
            int tn = 0;
            string sql = "select ID from NT_Dict_Area where name like '%" + area + "%'";
            try
            {
                tn = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
            }
            catch { }
            return tn;
        }
        /// <summary>
        /// ǷEMAIL
        /// </summary>
        /// <param name="email">ʼ</param>
        /// <returns></returns>
        private bool existEmail(string email)
        {
            string sql = "select Count(Email) from NT_User where Email='" + email + "'";
            int tn = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
            if (tn > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
    public class ImportInfo
    {
        private string username;
        private string userpass;
        private DateTime regtime;
        private string useremail;
        private string regip;
        private string ip;
        private int islock;
        private DateTime lastlogintime;
        private string province;
        private string city;
        private string qq;
        private string sex;
        private int kid;
        /// <summary>
        /// û
        /// </summary>
        public string UserName
        {
            get { return username; }
            set { username = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public string UserPass
        {
            get { return userpass; }
            set { userpass = value; }
        }
        /// <summary>
        /// עʱ
        /// </summary>
        public DateTime RegTime
        {
            get { return regtime; }
            set { regtime = value; }
        }
        /// <summary>
        /// ʼ
        /// </summary>
        public string UserEmail
        {
            get { return useremail; }
            set { useremail = value; }
        }
        /// <summary>
        /// עip
        /// </summary>
        public string RegIp
        {
            get { return regip; }
            set { regip = value; }
        }
        /// <summary>
        /// IP
        /// </summary>
        public string IP
        {
            get { return ip; }
            set { ip = value; }
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        public int IsLock
        {
            get { return islock; }
            set { islock = value; }
        }
        /// <summary>
        /// ½ʱ
        /// </summary>
        public DateTime LastLoginTime
        {
            get { return lastlogintime; }
            set { lastlogintime = value; }
        }
        /// <summary>
        /// ʡ
        /// </summary>
        public string Province
        {
            get { return province; }
            set { province = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public string City
        {
            get { return city; }
            set { city = value; }
        }
        /// <summary>
        /// QQ
        /// </summary>
        public string QQ
        {
            get { return qq; }
            set { qq = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public string Sex
        {
            get { return sex; }
            set { sex = value; }
        }
        /// <summary>
        /// ûID
        /// </summary>
        public int Kid
        {
            get { return kid; }
            set { kid = value; }
        }
    }
}
