using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.leaveword
{
    public partial class board : NetSNS.Web.UI.Page.UserPage
    {
        protected string uname = "";
        protected int uid;
        protected string portrait;
        protected string ShowRe = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            NetSNS.BLL.User.LeaveWord lw = new LeaveWord();
            #region Ajax
            if (Request.Form["Option"] == "Delete" && Request.Form["ID"] != null)
            {
                try
                {
                    int id = int.Parse(Request.Form["ID"]);
                    int n = lw.Delete(UserID, id);
                    if (n > 0)
                        Response.Write("1");
                    else
                        Response.Write("0");
                }
                catch
                {
                    Response.Write("0");
                }
                Response.End();
            }
            #endregion
            if (Request.Form["Action"] == "LeaveWord" && Request.Form["TxtBody"] != null && Request.Form["r"] != null)
            {
                string content = Request.Form["TxtBody"];
                int oid = int.Parse(Request["r"]);
                if (oid == UserID)
                {
                    ShowRe = "&nbsp;<a href=\"/user/leaveword/board.aspx?r=" + oid + "\">ظ</a>&nbsp;";
                }
                SaveWord(oid, content);
            }
            #region ʼҳ
            uid = UserID;
            if (Request["r"] != null && int.Parse(Request["r"]) != UserID)
            {
                uid = int.Parse(Request["r"]);
                if (!lw.CheckAuthority(UserID, uid))
                    PageError("Բ,ûв鿴û԰Ȩ", string.Empty);
                NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                UserInfo info = us.GetUserInfo(uid);
                uname = info.Username;
                portrait = info.PortraitDir;
                ImgPortrait.Alt = uname;
                ImgPortrait.Src = GetSmallHeadPic(portrait, 1, info.UserID);
            }
            else
            {
                ImgPortrait.Alt = UserName;
                this.DivPost.Visible = false;
                ImgPortrait.Src = GetSmallHeadPic(UserPortrait, 1,this.UserID);
            }
            BindData();
            DataBind();
            #endregion
        }
        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            DataTable dt = UtilPage.GetPage("leaveword_aspx", PageIndex, PAGESZ, out ReCount, out PgCount, new SqlConditionInfo("@Receiver", uid, TypeCode.Int32));
            this.RptData.DataSource = dt;
            this.RptData.DataBind();
            this.LtrNum.Text = ReCount.ToString();
            if (ReCount > PAGESZ)
            {
                string pgurl = "board.aspx";
                if (uid != UserID)
                    pgurl += "?r=" + uid;
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, pgurl);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }
        /// <summary>
        /// Ƿʾɾ
        /// </summary>
        /// <param name="nid"></param>
        /// <param name="ownerid"></param>
        /// <returns></returns>
        protected string ShowDel(object nid, object ownerid)
        {
            if ((int)ownerid == UserID || uid == this.UserID)
                return "<a class=\"delete w-del\" href=\"javascript:del(" + nid + ");\">ɾ</a>";
            else
                return string.Empty;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="ownerId"></param>
        /// <param name="content"></param>
        protected void SaveWord(int ownerId, string content)
        {
            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(content, true);
            if (res != "")
            {
                content = content.Replace(res, "***");
            }
            #endregion
            NetSNS.BLL.User.LeaveWord lw = new LeaveWord();
            lw.Edit(0, UserID, ownerId, content);
        }
    }
}
