using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.leaveword
{
    public partial class dialog : NetSNS.Web.UI.Page.UserPage
    {
        protected string uname1 = "";
        protected string uname2 = "";
        protected int uid1;
        protected int uid2;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Form["Action"] == "LeaveWord" && Request.Form["TxtBody"] != null && Request.Form["opposing"] != null)
            {
                string content = Request.Form["TxtBody"];
                int oid = int.Parse(Request.Form["opposing"]);
                SaveWord(oid, content);
            }
            if (Request.QueryString["r1"] == null || Request.QueryString["r2"] == null)
            {
                this.PageError("", "");
            }
            uid1 = int.Parse(Request.QueryString["r1"]);
            uid2 = int.Parse(Request.QueryString["r2"]);
            if (uid2 == UserID)
            {
                uid2 = uid1;
                uid1 = UserID;
            }
            if (uid1 != UserID)
            {
                NetSNS.BLL.User.LeaveWord lw = new LeaveWord();
                if (!lw.CheckAuthority(UserID, uid1))
                    PageError("Բ,ûв鿴û԰Ȩ", string.Empty);
                NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                UserInfo info = us.GetUserInfo(uid1);
                uname1 = info.Username;
            }
            else
            {
                this.ImgPortrait.Src = GetSmallHeadPic(UserPortrait, 1,this.UserID);
                this.ImgPortrait.Alt = UserName;
            }
            if (uid2 != UserID)
            {
                NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                UserInfo info = us.GetUserInfo(uid2);
                uname2 = info.Username;
                this.ImgPortrait.Src = GetSmallHeadPic(info.PortraitDir, 1,info.UserID);
                this.ImgPortrait.Alt = uname2;
            }
            if (uid1 != UserID && uid2 != UserID)
            {
                this.DivPost.Visible = false;
            }
            this.LtrCaption.Text = uname1 + "" + uname2;
            BindData();
            DataBind();
        }
        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo[] st = new SqlConditionInfo[]{
               new SqlConditionInfo("@Receiver", uid1, TypeCode.Int32),
               new SqlConditionInfo("@Sender", uid2, TypeCode.Int32)
           };
            DataTable dt = UtilPage.GetPage("leaveword_dialog", PageIndex, PAGESZ, out ReCount, out PgCount, st);
            this.RptData.DataSource = dt;
            this.RptData.DataBind();
            this.LtrNum.Text = ReCount.ToString();
            if (ReCount > PAGESZ)
            {
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, "dialog.aspx?r1=" + uid1 + "&r2=" + uid2);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }
        /// <summary>
        /// Ƿʾɾ
        /// </summary>
        /// <param name="nid"></param>
        /// <param name="ownerid"></param>
        /// <returns></returns>
        protected string ShowDel(object nid, object ownerid)
        {
            if ((int)ownerid == UserID || uid1 == this.UserID)
                return "<span class=\"delete\"><a class=\"delete w-del\" href=\"javascript:del(" + nid + ");\">ɾ</a></span>";
            else
                return string.Empty;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="ownerId"></param>
        /// <param name="content"></param>
        protected void SaveWord(int ownerId, string content)
        {
            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(content, true);
            if (res != "")
            {
                content = content.Replace(res, "***");
            }
            #endregion
            NetSNS.BLL.User.LeaveWord lw = new LeaveWord();
            lw.Edit(0, UserID, ownerId, content);
        }
    }
}
