using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.BLL.User;

namespace NetSNS.Web.user
{
    public partial class logout : NetSNS.Web.UI.Page.BasePage
    {
        protected new int UserID = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            UserID = GetCurrentUserID();
            UserInfo ui = new User().GetUserInfo(UserID);
            HttpCookie cookieToken = Context.Request.Cookies["SnsUserToken"];
            if (cookieToken != null)
            {
                cookieToken.Values.Clear();
                cookieToken.Domain = NetSNS.Config.UiConfig.CookieDomain;
                cookieToken.Expires = DateTime.Now.AddDays(20);
                Response.SetCookie(cookieToken);
                #region cms 
                NetSNS.API.Interface.PDOAction pdo = new NetSNS.API.Interface.PDOAction();
                if (pdo.Enabled())
                {
                    pdo.Logout(ui.Email);
                }
                #endregion
            }
        }
    }
}
