using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.blog
{
    public partial class mymini : NetSNS.Web.UI.Page.UserPage
    {
        protected int myid;
        protected string myname;
        public string sList = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            NetSNS.BLL.User.MiniBlog mnblg = new NetSNS.BLL.User.MiniBlog();
            sList = "<select name=\"mType\" id=\"mType\">";
            string opitem = NetSNS.Config.UiConfig.MiniType;
            string tmpItem = string.Empty;
            sList += "<option value=\"\">ѡ</option>";
            if (opitem.IndexOf(",") > -1)
            {
                string[] opitemARR = opitem.Split(',');
                for (int i = 0; i < opitemARR.Length; i++)
                {
                    sList += "<option value=\"" + opitemARR[i] + "\">" + opitemARR[i] + "</option>";
                }
            }
            sList += "</select>";
            #region AJAX
            if (Request.Form["Option"] == "Delete")
            {
                try
                {
                    int id = int.Parse(Request.Form["ID"]);
                    mnblg.DeleteMini(UserID, id);
                    Response.Write("1");
                }
                catch
                {
                    Response.Write("0");
                }
                Response.End();
            }
            #endregion
            this.DivMsg.Visible = false;
            if (Request.Form["Action"] == "Submit")
            {
                if (AddNewMini() == 1)
                {

                    HttpCookie cookiesu = new HttpCookie("miniblog");
                    cookiesu["mymini"] = "true";
                    Response.AppendCookie(cookiesu);
                    Response.Redirect("mymini.aspx");
                    return;
                }
            }
            HttpCookie cookie = Request.Cookies["miniblog"];
            if (cookie != null && cookie["mymini"] == "true")
            {
                this.DivMsg.Visible = true;
                cookie.Expires = DateTime.Now.AddMilliseconds(0.1);
                Response.AppendCookie(cookie);
            }
            if (Request.QueryString["r"] == null || Request.QueryString["r"].Trim() == string.Empty)
            {
                myid = UserID;
            }
            else
            {
                myid = int.Parse(Request.QueryString["r"]);
            }
            if (myid != UserID)
            {
                if (myid != UserID)
                {
                    if (!mnblg.CheckAuthority(myid, UserID))
                        PageError("Բ,ûв鿴û㲩͵Ȩ", string.Empty);
                }

                User us = new User();
                UserInfo info = us.GetUserInfo(myid);
                myname = info.Username;
                this.ImgHead.AlternateText = info.Username;
                this.ImgHead.ImageUrl = GetSmallHeadPic(info.PortraitDir, 1,info.UserID);
            }
            else
            {
                myname = "";
                this.ImgHead.AlternateText = UserName;
                this.ImgHead.ImageUrl = GetSmallHeadPic(UserPortrait, 1,this.UserID);

            }
            BindData();
            DataBind();

        }
        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            DataTable dt = UtilPage.GetPage("miniblog_mine", PageIndex, PAGESZ, out ReCount, out PgCount, new SqlConditionInfo("@UserID", myid, TypeCode.Int32));
            this.RptData.DataSource = dt;
            this.RptData.DataBind();
            this.LtrNum.Text = ReCount.ToString();
            if (ReCount > PAGESZ)
            {
                string url = "mymini.aspx";
                if (myid != UserID)
                    url += "?r=" + myid;
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, url);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }
        /// <summary>
        /// ռ
        /// </summary>
        protected int AddNewMini()
        {
            string content = NetSNS.Common.Input.loseExceptImg(Request.Form["TxtContent"]);
            string conStr = NetSNS.Common.Input.FilterHTML(Request.Form["TxtContent"]);
            if (Request.Form["TxtContent"] == null || Request.Form["TxtContent"] == string.Empty)
            {
                this.DivMsg.Visible = true;
                this.DivMsg.InnerHtml = "ռǱд";
                return 0;
            }
            if (Request.Form["TxtContent"].Length > 250)
            {
                this.DivMsg.Visible = true;
                this.DivMsg.InnerHtml = "ܳ250ַ";
                return 0;
            }
            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(conStr, true);
            if (res != "")
            {
                content = content.Replace(res, "***");
            }
            #endregion
            string MType = string.Empty;
            if (Request.Form["mType"] != null && Request.Form["mType"] != string.Empty)
            {
                MType = Request.Form["mType"];
            }
            NetSNS.BLL.User.MiniBlog mini = new NetSNS.BLL.User.MiniBlog();
            return mini.SaveMini(UserID, content, MType);
        }

        protected string ShowType(object MType)
        {
            string listStr = string.Empty;
            if (MType != null)
            {
                if (MType.ToString() != string.Empty && MType.ToString() != null)
                {
                    listStr = "<span class=\"minitype\">[" + MType.ToString() + "]</span> ";
                }
            }
            return listStr;
        }
    }
}
