using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.user.blog
{
    public partial class recentmini : NetSNS.Web.UI.Page.UserPage
    {
        public string sList = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            sList = "<select name=\"mType\" id=\"mType\">";
            string opitem = NetSNS.Config.UiConfig.MiniType;
            string tmpItem = string.Empty;
            sList += "<option value=\"\">ѡ</option>";
            if (opitem.IndexOf(",") > -1)
            {
                string[] opitemARR = opitem.Split(',');
                for (int i = 0; i < opitemARR.Length; i++)
                {
                    sList += "<option value=\"" + opitemARR[i] + "\">" + opitemARR[i] + "</option>";
                }
            }
            sList += "</select>";

            this.DivMsg.Visible = false;
            if (Request.Form["Action"] == "Submit")
            {
                if (AddNewMini() == 1)
                {
                    HttpCookie cookiesu = new HttpCookie("miniblog");
                    cookiesu["recent"] = "true";
                    Response.AppendCookie(cookiesu);
                    Response.Redirect("recentmini.aspx");
                }
            }
            HttpCookie cookie = Request.Cookies["miniblog"];
            if (cookie != null && cookie["recent"] == "true")
            {
                this.DivMsg.Visible = true;
                cookie.Expires = DateTime.Now.AddMilliseconds(0.1);
                Response.AppendCookie(cookie);
            }
            BindData();
            DataBind();
        }
        /// <summary>
        /// ҳ
        /// </summary>
        protected void BindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            if (Request.QueryString["Page"] != null)
            {
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            }
            string mid = Request.QueryString["mid"];
            DataTable dt = null;
            if (NetSNS.Common.Input.IsInteger(mid))
            {
                dt = UtilPage.GetPage("miniblog_recent_id", PageIndex, PAGESZ, out ReCount, out PgCount, new SqlConditionInfo("@UserID", UserID, TypeCode.Int32), new SqlConditionInfo("@MID", Convert.ToInt32(mid), TypeCode.Int32));
            }
            else
            {
                dt = UtilPage.GetPage("miniblog_recent", PageIndex, PAGESZ, out ReCount, out PgCount, new SqlConditionInfo("@UserID", UserID, TypeCode.Int32));
            }

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string kk = dt.Rows[i]["Content"].ToString();
            }
                this.RptData.DataSource = dt;
            this.RptData.DataBind();
            this.LtrNum.Text = ReCount.ToString();
            if (ReCount > PAGESZ)
            {
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, "recentmini.aspx");
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }
        /// <summary>
        /// ռ
        /// </summary>
        protected int AddNewMini()
        {
            string content = NetSNS.Common.Input.loseExceptImg(Request.Form["TxtContent"]);
            string conStr = NetSNS.Common.Input.FilterHTML(Request.Form["TxtContent"]);
            if (Request.Form["TxtContent"] == null || Request.Form["TxtContent"] == string.Empty)
            {
                this.DivMsg.Visible = true;
                this.DivMsg.InnerHtml = "ռǱд";
                return 0;
            }

            if (Request.Form["TxtContent"].Length > 250)
            {
                this.DivMsg.Visible = true;
                this.DivMsg.InnerHtml = "ܳ250ַ";
                return 0;
            }
            #region ˹ؼ
            string res = NetSNS.Common.Public.CheckKey(conStr, true);
            if (res != "")
            {
                content = content.Replace(res, "***");
            }
            #endregion
            NetSNS.BLL.User.MiniBlog mini = new NetSNS.BLL.User.MiniBlog();
            string MType = string.Empty;
            if (Request.Form["mType"] != null && Request.Form["mType"] != string.Empty)
            {
                MType = Request.Form["mType"];
            }
            return mini.SaveMini(UserID, content, MType);
        }
        /// <summary>
        /// ʾɾ
        /// </summary>
        /// <param name="uid"></param>
        /// <param name="mid"></param>
        /// <returns></returns>
        protected string ShowDel(object uid, object mid)
        {
            if (UserID == (int)uid)
                return "<span class=\"delete\"><a href=\"javascript:Delete(" + mid + ");\" class=\"m-del\">ɾ</a></span>";
            else
                return string.Empty;
        }

        protected string ShowType(object MType)
        {
            string listStr = string.Empty;
            if (MType != null)
            {
                if (MType.ToString() != string.Empty && MType.ToString() != null)
                {
                    listStr = "<span class=\"minitype\">["+MType.ToString()+"]</span> ";
                }
            }
            return listStr;
        }

        protected int ShowComment(object mid)
        {
            NetSNS.BLL.User.MiniBlog mini = new NetSNS.BLL.User.MiniBlog();
            return mini.GetMiniCount(Convert.ToInt32(mid.ToString()));
        }
    }
}
