using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.Web.user.vote
{
    public partial class vote : NetSNS.Web.UI.Page.UserPage
    {
        NetSNS.BLL.User.Vote v = new NetSNS.BLL.User.Vote();
        VoteInfo voteinfo = new VoteInfo();
        NetSNS.BLL.User.VoteOption vo = new NetSNS.BLL.User.VoteOption();
        protected string r = "";
        protected int userid = 0;
        protected string username = "";
        protected string option = "";
        protected int jcnt = 0;
        protected int vcnt = 0;
        protected string answer = "";
        protected string comm = "";
        protected string intro = "";
        protected string voteharf = "";
        protected string mycomm = "˵˵Ŀ...";
        protected int pid = 0;
        protected string rcnt = "";
        protected string tempreplycnt = "";
        protected string del = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            getInfo();
            DataBind();
        }

        protected void getInfo()
        {
            r = Request.QueryString["r"];
            string t = Request.QueryString["t"];
            voteinfo = v.Info(Convert.ToInt32(r));
            if (voteinfo.ID == 0)
                PageError("ݴ", "");
            Title.Text = Input.HtmlDecode(voteinfo.Title);
            AddTime.Text = voteinfo.AddTime.ToString("yyyy-MM-dd hh:mm");
            jcnt = voteinfo.JCnt;
            vcnt = voteinfo.VCnt;
            userid = voteinfo.UserID;
            intro = "<p>" + Input.HtmlEncode(voteinfo.Intro) + "</p>";
            User user = new User();
            UserInfo userinfo = new UserInfo();
            userinfo = user.GetUserInfo(userid);
            username = userinfo.Username;
            if (t == "v")
            {
                govote.Visible = true;
                option = getOption(voteinfo.ID, voteinfo.Mode);
            }
            else
            {
                result.Visible = true;
                lefter.Visible = true;
                righter.Visible = true;

                VoteComm votecomm = new VoteComm();
                ToVote tv = new ToVote();
                ToVoteInfo tvinfo = new ToVoteInfo();
                tvinfo = tv.Info(voteinfo.ID, UserID);
                if (tvinfo.ID > 0)
                {
                    myvoteinfo.Visible = true;
                    if (tvinfo.Content != null && tvinfo.Content.Trim() != "")
                    {
                        pid = tvinfo.ID;
                        int tempcnt = votecomm.ReplyCnt(pid);
                        if (tempcnt > 0)
                            rcnt = "(" + tempcnt + ")";
                    }
                }

                getfjoinvote();
                getuservote();
                getfriendvote(voteinfo.ID);
                getothervote(voteinfo.ID);
                option = getOption(voteinfo.ID);
                answer = getAnswer(voteinfo.ID, UserID);
                comm = getComm(voteinfo.ID, UserID);
            }
            IsVote(voteinfo.ID);
            getdel(voteinfo.ID);
        }

        /// <summary>
        /// õǷɾ
        /// </summary>
        /// <param name="VoteID">ͶƱ</param>
        /// <returns></returns>
        protected void getdel(int VoteID)
        {
            if (userid == this.UserID)
                del = " | <a href=\"javascript:void(0);\" onclick=\"javascript:Confirm(this,'ȷɾͶƱ','ɾ',function(){delvote(" + VoteID + "," + this.UserID + ")})\">ɾ</a>";
        }

        /// <summary>
        /// ȡۻظ
        /// </summary>
        /// <param name="VoteID">۱</param>
        /// <param name="UID">û</param>
        /// <param name="PID"></param>
        /// <returns></returns>
        protected string getReplyCnt(object VoteID, object UID, object PID)
        {
            tempreplycnt = "";
            VoteComm votecomm = new VoteComm();
            ToVote tv = new ToVote();
            ToVoteInfo tvinfo = new ToVoteInfo();
            tvinfo = tv.Info(Convert.ToInt32(VoteID), Convert.ToInt32(UID));
            if (tvinfo.Content != null && tvinfo.Content.Trim() != "")
            {
                int tempcnt = votecomm.ReplyCnt(Convert.ToInt32(PID));
                if (tempcnt > 0)
                    tempreplycnt = "(" + tempcnt + ")";
            }
            return tempreplycnt;
        }

        /// <summary>
        /// ҪͶƱť
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        protected void IsVote(int ID)
        {
            ToVote tovote = new ToVote();
            ToVoteInfo tvinfo = new ToVoteInfo();
            if (!tovote.IsVote(this.UserID, ID))
            {
                voteharf = "<div class=\"judgeinfo2\"><a href=\"vote.aspx?r=" + ID + "&t=v\" class=\"votebtn\">ҪͶƱ</a></div>";
                tvinfo = tovote.Info(ID, this.UserID);
                if (tvinfo.Content != null && tvinfo.Content.Trim() != "")
                    mycomm = Input.HtmlEncode(tvinfo.Content);
            }
        }

        /// <summary>
        /// غμӵͶƱб
        /// </summary>
        protected void getfjoinvote()
        {
            DataTable dt = v.FriendNewJoinVoteList(5, this.UserID);
            Rpt_fjoinvote.DataSource = dt;
            Rpt_fjoinvote.DataBind();
        }

        /// <summary>
        /// ûͶƱб
        /// </summary>
        protected void getuservote()
        {
            DataTable dt = v.MyAddVote(5, userid, Convert.ToInt32(r));
            Rpt_uservote.DataSource = dt;
            Rpt_uservote.DataBind();
        }

        /// <summary>
        /// غѵͶƱѡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        protected void getfriendvote(int ID)
        {
            DataTable dt = v.FriendVote(this.UserID, ID);
            Rpt_friendvote.DataSource = dt;
            Rpt_friendvote.DataBind();
        }

        /// <summary>
        /// ͶƱѡ
        /// </summary>
        /// <param name="ID"></param>
        protected void getothervote(int ID)
        {
            DataTable dt = v.OtherVote(this.UserID, ID);
            Rpt_otherdvote.DataSource = dt;
            Rpt_otherdvote.DataBind();
        }

        /// <summary>
        /// ȡҵĴ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <param name="UID">Ա</param>
        /// <returns></returns>
        protected string getAnswer(int ID, int UID)
        {
            bool tf = false;
            StringBuilder s = new StringBuilder();
            List<VoteOptionInfo> list = vo.OptionList(ID, UID, out tf);
            if (tf)
            {
                if (list.Count > 0)
                {
                    for (int i = 0; i < list.Count; i++)
                    {
                        s.Append(list[i].OptionName + "<br />");
                    }
                    return "<p class=\"ansjudgeinfo\">𰸣<br /><span class=\"green\">" + s.ToString() + "</span></p>";
                }
            }
            return "";
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <param name="UID">Ա</param>
        /// <returns></returns>
        protected string getComm(int ID, int UID)
        {
            ToVote tv = new ToVote();
            ToVoteInfo tvinfo = new ToVoteInfo();
            tvinfo = tv.Info(ID, UID);
            return "" + Input.HtmlEncode(tvinfo.Content) + "";
        }



        /// <summary>
        /// ȡͶƱѡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <param name="Mode">ͶƱѡ</param>
        /// <returns>ѡ</returns>
        protected string getOption(int ID, int Mode)
        {
            bool tf = false;
            StringBuilder s = new StringBuilder();
            List<VoteOptionInfo> list = vo.OptionList(ID, this.UserID, out tf);
            if (tf)
            {
                s.Append("ҵѡ<br />");
                for (int i = 0; i < list.Count; i++)
                {
                    s.Append(list[i].OptionName + "<br />");
                }
            }
            else
            {
                for (int i = 0; i < list.Count; i++)
                {
                    string o = "";
                    if (Mode == 1)//ѡ
                    {
                        o = "<input name=\"Option_" + ID.ToString() + "\" type=\"radio\" value=\"" + list[i].ID + "\" /> ";
                        s.Append(o + Input.HtmlEncode(list[i].OptionName) + "<br />");
                    }
                    else//ѡ
                    {
                        o = "<input name=\"Option_" + ID.ToString() + "\" type=\"checkbox\" value=\"" + list[i].ID + "\" /> ";
                        s.Append(o + Input.HtmlEncode(list[i].OptionName) + "<br />");
                    }
                }
            }
            return s.ToString();
        }

        /// <summary>
        /// ȡͶƱѡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <returns>ؽ</returns>
        protected string getOption(int ID)
        {
            StringBuilder s = new StringBuilder();
            List<VoteOptionInfo> list = vo.OptionList(ID);
            for (int i = 0; i < list.Count; i++)
            {
                float j = 0;
                if (vcnt != 0)
                    j = ((float)list[i].Cnt / (float)vcnt) * 100;
                s.Append("<div class=\"voteinfo\">");
                s.Append(Input.HtmlDecode(list[i].OptionName) + "</div>");
                s.Append("<div class=\"voteplan\">");
                s.Append("<div class=\"plan\" style=\"width: " + j + "%;\">");
                s.Append("</div>");
                s.Append("</div>");
                s.Append("<div class=\"number\">");
                s.Append("" + Convert.ToInt32(j) + "% " + list[i].Cnt + "</div>");
                s.Append("<div class=\"myclear\">");
                s.Append("</div>");
            }
            return s.ToString();
        }
    }
}
