using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Text;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Web.UI.Control;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.Web.user.vote
{
    public partial class votes : NetSNS.Web.UI.Page.UserPage
    {
        NetSNS.BLL.User.Vote v = new NetSNS.BLL.User.Vote();
        NetSNS.BLL.User.VoteOption vo = new NetSNS.BLL.User.VoteOption();
        ToVote tv = new ToVote();
        protected string btn = "";
        protected int userid = 0;
        protected int myjcnt = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            getInfo();
            DataBind();
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            string t = Request.QueryString["t"];
            userid = this.UserID;
            string r = Request.QueryString["r"];
            username.Text = "";
            if (r != null && r != "" && r != UserID.ToString())
            {
                userid = Convert.ToInt32(r);
                User user = new User();
                UserInfo uinfo = new UserInfo();
                uinfo = user.GetUserInfo(userid);
                username.Text = uinfo.Username;
            }
            myaddCnt.Text = v.MyAddCnt(userid).ToString();

            switch (t)
            {
                case "a":
                    myaddvote10.Visible = true;
                    divPage.Visible = true;
                    getmyaddvote(true);
                    break;
                case "j":
                    myjoinvote10.Visible = true;
                    divPage1.Visible = true;
                    getmyjoinvote(true);
                    break;
                default:
                    myaddvote10.Visible = true;
                    myjoinvote10.Visible = true;
                    moreavote.Visible = true;
                    morejvote.Visible = true;
                    getmyaddvote(false);
                    getmyjoinvote(false);
                    break;
            }
        }

        /// <summary>
        /// ҴͶƱ
        /// </summary>
        /// <param name="tf"></param>
        protected void getmyaddvote(bool tf)
        {
            DataTable dt = null;
            if (tf)
            {
                int r = 0, p = 0, PageIndex = 0;
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
                SqlConditionInfo st = new SqlConditionInfo("@UserID", userid, TypeCode.Int32);
                dt = UtilPage.GetPage("myaddvote_aspx", PageIndex, 20, out r, out p, st);
                divPage.InnerHtml = PageNavigator.Pagination(PageIndex, p, "votes.aspx?t=a&r=" + userid);
            }
            else
            {
                dt = v.MyAddVote(10, userid);
            }
            Rpt_myaddvote.DataSource = dt;
            Rpt_myaddvote.DataBind();
        }

        /// <summary>
        /// ҲͶƱ
        /// </summary>
        protected void getmyjoinvote(bool tf)
        {
            int r = 0, p = 0, PageIndex = 0;
            PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            SqlConditionInfo st = new SqlConditionInfo("@UserID", userid, TypeCode.Int32);
            DataTable dt = UtilPage.GetPage("myjoinvote_aspx", PageIndex, PAGESZ, out r, out p, st);
            myjcnt = dt.Rows.Count;
            if (tf)
                divPage1.InnerHtml = PageNavigator.Pagination(PageIndex, p, "votes.aspx?t=j&r=" + userid);
            else
                dt = v.MyJoinVote(10, userid);
            Rpt_myjoinvote.DataSource = dt;
            Rpt_myjoinvote.DataBind();
        }

        /// <summary>
        /// ؽ
        /// </summary>
        /// <param name="Intro"></param>
        /// <returns></returns>
        protected string getIntro(object Intro)
        {
            string s = "";
            if (Intro != null && Intro.ToString().Trim() != "")
                s = "<div>" + Intro.ToString() + "</div>";
            return s;
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="ID">۱</param>
        /// <returns></returns>
        protected string getContent(object ID)
        {
            btn = "";
            string s = "<p class=\"content\"><textarea id=\"Comm_" + ID.ToString() + "\" cols=\"\" rows=\"\" onfocus=\"if(this.value=='˵˵Ŀ...'){this.value='';}\" onblur=\"if(this.value==''){this.value='˵˵Ŀ...';}\">˵˵Ŀ...</textarea></p>";
            ToVoteInfo Info = new ToVoteInfo();
            Info = tv.Info(Convert.ToInt32(ID), UserID);
            if (Info.Content != null && Info.Content.Trim() != "")
            {
                s = "<p class=\"content\">" + NetSNS.Common.Input.HtmlEncode(Info.Content) + "</p>";
            }
            else
            {
                btn = "<input type=\"button\" value=\"ȷ\" class=\"butn1\" onclick=\"javascript:tovote(" + ID + ");\">";
            }
            return s;
        }

        /// <summary>
        /// ȡͶƱѡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <param name="Mode">ͶƱѡ</param>
        /// <returns>ѡ</returns>
        protected string getOption(object ID, object Mode)
        {
            bool tf = false;
            StringBuilder s = new StringBuilder();
            string c = getContent(ID);
            List<VoteOptionInfo> list = vo.OptionList(Convert.ToInt32(ID), UserID, out tf);
            s.Append("<p>");
            if (tf)
            {
                s.Append("ҵѡ<br />");
                for (int i = 0; i < list.Count; i++)
                {
                    s.Append(list[i].OptionName + "<br />");
                }
            }
            else
            {
                if (c.IndexOf("textarea") != -1)
                {
                    for (int i = 0; i < list.Count; i++)
                    {
                        string o = "";
                        if (Mode.ToString() == "1")//ѡ
                        {
                            o = "<input name=\"Option_" + ID.ToString() + "\" type=\"radio\" value=\"" + list[i].ID + "\" /> ";
                            s.Append(o + Input.HtmlEncode(list[i].OptionName) + "<br />");
                        }
                        else//ѡ
                        {
                            o = "<input name=\"Option_" + ID.ToString() + "\" type=\"checkbox\" value=\"" + list[i].ID + "\" /> ";
                            s.Append(o + Input.HtmlEncode(list[i].OptionName) + "<br />");
                        }
                    }
                }
            }
            s.Append("</p>");
            s.Append(c);
            return s.ToString();
        }


        /// <summary>
        /// ȡͶƱѡ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <returns>ѡ</returns>
        protected string getOption(object ID)
        {
            bool tf = false;
            StringBuilder s = new StringBuilder();
            List<VoteOptionInfo> list = vo.OptionList(Convert.ToInt32(ID), UserID, out tf);
            if (tf)
            {
                s.Append("ҵѡ<br />");
                for (int i = 0; i < list.Count; i++)
                {
                    s.Append(list[i].OptionName + "<br />");
                }
            }
            s.Append(getContent(ID));
            return s.ToString();
        }
    }
}
