function TYUploadGetMainWindow() 
{
	var mainWindow;
	if (window.opener) 
		mainWindow = window.opener;
	else 
		mainWindow = window.parent;
	return mainWindow;
};

TYUploadCancelled = false;

function TYUploadCancel() 
{
	TYUploadCancelled = true;
	var mainWindow = TYUploadGetMainWindow();
	if (mainWindow && mainWindow.stop)
		mainWindow.stop();
	else if (mainWindow && mainWindow.document && mainWindow.document.execCommand)
		mainWindow.document.execCommand('Stop');
}

function TYUpload_CombineHandlers(origHandler, newHandler) 
{
	if (!origHandler || typeof(origHandler) == 'undefined') return newHandler;
	return function(e) { origHandler(e); newHandler(e); };
}

TYUploadReq = null;
function TYUploadRefreshWithAjax(url) 
{
	TYUploadReq = null;
	var req = null;
	try
	{
		req = new ActiveXObject('Microsoft.XMLHTTP');
	}
	catch (ex)
	{
		req = null;
	}
	if (!req && typeof(XMLHttpRequest) != 'undefined')
	{
		req = new XMLHttpRequest();
	}
	if (req)
	{
		TYUploadReq = req;
	}
	if (TYUploadReq)
	{
		TYUploadReq.onreadystatechange = TYUploadUpdateHtml;
		TYUploadReq.open('GET', url);
		TYUploadReq.send(null);
	}
	else
	{
		return false;
	}
	return true;
}

function TYUploadUpdateHtml()
{
	if (typeof(TYUploadReq) != 'undefined' && TYUploadReq != null && TYUploadReq.readyState == 4) 
	{
		try
		{
			var responseXmlDoc = TYUploadReq.responseXML;
			if (responseXmlDoc.parseError && responseXmlDoc.parseError.errorCode != 0)
			{
//				window.alert('parse error: ' + responseXmlDoc.parseError.reason);
			}
//			window.alert(new XMLSerializer().serializeToString(responseXmlDoc));
			var templates = responseXmlDoc.getElementsByTagName('TYUploadDetails');
			var status = templates.item(0).getAttribute('status');
			for (var t = 0; t < templates.length; t++)
			{
				var srcElem = templates.item(t);
				var innerXml = '';
				for (var i = 0; i < srcElem.childNodes.length; i++)
				{
					var childNode = srcElem.childNodes.item(i);
					var xml = childNode.xml;
					if (xml == null)
						xml = new XMLSerializer().serializeToString(childNode);
					if (typeof(xml) == 'undefined')
						throw "serializeToString() returned 'undefined' (probably due to a Safari bug) so no AJAX.";  
					innerXml += xml;
				}
				var id = srcElem.getAttribute('id');
				var destElem = document.getElementById(id);
				destElem.innerHTML = innerXml;
				for (var a=0; a < srcElem.attributes.length; a++)
				{
					var attr = srcElem.attributes.item(a);
					if (attr.specified)
					{
						if (attr.name == 'style' && destElem.style && destElem.style.cssText)
							destElem.style.cssText = attr.value;
						else
							destElem.setAttribute(attr.name, attr.value);
					}
				}
			}
			if (status != 'NormalInProgress' && status != 'ChunkedInProgress' && status != 'Unknown')
			{
				TYUploadRefreshPage();
			}
			var lastMillis = TYUploadLastUpdate.getTime();
			TYUploadLastUpdate = new Date();
			var delay = Math.max(lastMillis + 1000 - TYUploadLastUpdate.getTime(), 1);
			TYUploadReloadTimeoutId = setTimeout('TYUploadRefresh()', delay);
		}
		catch (ex)
		{
			TYUploadRefreshPage();
		}
	}
}

TYUploadLastUpdate = new Date(); 
TYUploadReloadTimeoutId = null;

window.onunload = TYUpload_CombineHandlers(window.onunload, function () 
{
	if (TYUploadReq && TYUploadReq.readystate
		&& TYUploadReq.readystate >= 1 && TYUploadReq.readystate <=3)
	{
		TYUploadReq.abort();
	}
	TYUploadReq = null;
	if (TYUploadReloadTimeoutId)
		clearTimeout(TYUploadReloadTimeoutId);
});

TYUploadMainWindow = TYUploadGetMainWindow();

function TYUploadRefresh()
{
	if (!TYUploadRefreshWithAjax(TYUploadRefreshUrl + '&useXml=true'))
	{
		TYUploadRefreshPage();
	}
}

function TYUploadRefreshPage() 
{
	if (!TYUploadCancelled)
	{
		window.location.replace(TYUploadRefreshUrl);
	}
}

function TYUpload_CancelClicked()
{
	TYUploadCancel();
	window.location.replace(TYUploadRefreshUrl + '&cancelled=true');
}
