﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Web;
using System.Web.Security;
using System.Security.Cryptography;
//5/1/a/spx
namespace BLL
{
    /// <summary>
    /// 信息提示类
    /// </summary>
    public class Message
    {
        /// <summary>
        /// 信息提示
        /// </summary>
        /// <param name="sql"></param>
        public static void Show(string sql)
        {
            MagicAjax.AjaxCallHelper.Write("alert('" + sql + "');");
        }

        /// <summary>
        /// 信息提示并返回前页
        /// </summary>
        /// <param name="sql"></param>
        public static void historyShow(string sql)
        {
            MagicAjax.AjaxCallHelper.Write("alert('" + sql + "');history.go(-1);");
        }

        /// <summary>
        /// 信息提示并返回指定连接
        /// </summary>
        /// <param name="sql"></param>
        public static void locationShow(string sql,string url)
        {
            MagicAjax.AjaxCallHelper.Write("alert('" + sql + "');location.href='"+url+"';");
        }

        /// <summary>
        /// 判断管理员
        /// </summary>
        public static void IsAdmin()
        {
            if (HttpContext.Current.Session["Admin"] == null && HttpContext.Current.Session["Pwd"] == null)
            {
                HttpContext.Current.Response.Write(@"<script>alert('你没有登陆或登陆超时!');this.parent.location.href='./Default.aspx';</script>");
            }
        }

        /// <summary>
        /// SHA512加密
        /// </summary>
        /// <param name="str">密码内容</param>
        /// <returns></returns>
        public static string ToSHA512(string str)
        {
            SHA512 sha512 = new SHA512Managed();
            byte[] sha512Bytes = Encoding.Default.GetBytes(str);
            byte[] cryString = sha512.ComputeHash(sha512Bytes);
            string sha512Str = string.Empty;
            for (int i = 0; i < cryString.Length; i++)
            {
                sha512Str += cryString[i].ToString();
            }
            return sha512Str;
        }

        /// <summary>
        /// SQL语句安全过滤
        /// </summary>
        /// <param name="sql">SQL语句</param>
        /// <returns></returns>
        public static string safeSQL(string sql)
        {
            return sql.ToLower().Replace("insert", "").Replace("delete", "").Replace("update", "").Replace("select", "").Replace("count", "").Replace("*", "").Replace("from", "").Replace(" ", "").Replace("and", "").Replace(";", "").Replace("%", "");
        }

        /// <summary>
        /// 是否为正整数
        /// </summary>
        /// <param name="sData">要检测的字符串</param>
        /// <returns>为正整数返回true, 否则返回false</returns>
        public static bool PositiveInteger(string sData)
        {
            return System.Text.RegularExpressions.Regex.IsMatch(sData, @"^[1-9]\d*$");
        }

        /// <summary>
        /// 修改WEB.CONFIG
        /// </summary>
        /// <param name="key"></param>
        /// <param name="strvalue"></param>
        public static void Modify(string key, string strvalue)
        {
            string xpath = "/configuration/appSettings/add[@key=?]";
            System.Xml.XmlDocument domwebconfig = new System.Xml.XmlDocument();

            domwebconfig.Load(HttpContext.Current.Server.MapPath("..\\web.config"));
            System.Xml.XmlNode addkey = domwebconfig.SelectSingleNode((xpath.Replace("?", key)));
            if (addkey == null)
            {
                throw new ArgumentException("没有找到<add key=" + key + " value=.../>的配置节");
            }
            addkey.Attributes["value"].InnerText = strvalue;
            domwebconfig.Save(HttpContext.Current.Server.MapPath("..\\web.config"));
        }
    }
}
