﻿/// <summary>
/// 摘要说明
/// 形式化说明: DataBaseLayer是一个用来执行存储过程操作数据库的函数
/// ==========================================================================================

/// </summary>
using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Wuqi.Webdiyer;

    ///***********************************************************************************************************************
    /// <summary>
    /// DataBaseLayer  用来完成用户定义的一系列操作,使用存储过程完成
    /// </summary>
public class DataBaseLayer:System.Web.UI.Page
{
    private string ConnectionString =ConfigurationManager.AppSettings["myconnection"];//数据库连接字符串
    private SqlConnection SqlConn;//数据库连接
    private SqlCommand SqlCmd;
    private SqlDataAdapter SqlAdpt;
    private SqlDataReader SqlDr;
    private DataSet ds;
    ///************************************************初始化连接和存储过程***********************************************************
    /// <summary>
    /// 初始化连接和存储过程
    /// </summary>
	public DataBaseLayer()
	{
       
            this.SqlConn = new SqlConnection(ConnectionString);
            this.SqlCmd = new SqlCommand();
            this.SqlCmd.Connection = SqlConn;
            this.SqlCmd.CommandType = CommandType.StoredProcedure;
            this.SqlAdpt = new SqlDataAdapter(this.SqlCmd);
       
	}
    ///******************************************希构函数释放占用的数据连接***************************************************
    /// <summary>
    /// 希构函数释放占用的数据连接
    /// </summary>
    ~DataBaseLayer()
    { 
    }
    ///*********************************存储过程参数的建造者,把存储过程需要的参数构造进Param数组成员中**************************
    /// <summary>
    /// 存储过程参数的建造者,把存储过程需要的参数构造进Param数组成员中
    /// </summary>
    /// <param name="ParamName">参数名</param>
    /// <param name="ParamValue">参数值</param>
    /// <param name="ParamDirection">参数的传递方向,INPUT,OUTPUT</param>
    public SqlParameter ParamBuilder(string ParamName, object ParamValue, object DbType, ParameterDirection ParamDirection)
    {
        System.Data.SqlClient.SqlParameter Param = new System.Data.SqlClient.SqlParameter(ParamName, DbType);
        Param.Value = ParamValue;
        Param.Direction = (ParameterDirection)ParamDirection;
        return Param;
    }
    /// 存储过程参数的建造者,把存储过程需要的参数构造进Param数组成员中
    /// </summary>
    /// <param name="ParamName">参数名</param>
    /// <param name="ParamDirection">参数的传递方向,OUTPUT</param>
    public SqlParameter ParamBuilder(string ParamName, object DbType, ParameterDirection ParamDirection)
    {
        System.Data.SqlClient.SqlParameter Param = new System.Data.SqlClient.SqlParameter(ParamName, DbType);
        Param.Direction = (ParameterDirection)ParamDirection;
        return Param;
    }
   /// <summary>
   /// 方法的重载,没有参数输入输出方向,默认既是输入
   /// </summary>
   /// <param name="ParamName"></param>
   /// <param name="ParamValue"></param>
   /// <param name="DbType"></param>
   /// <returns></returns>
    public SqlParameter ParamBuilder(string ParamName, object ParamValue, object DbType)
    {
       
        System.Data.SqlClient.SqlParameter Param = new System.Data.SqlClient.SqlParameter(ParamName, DbType);
        Param.Value = ParamValue;
        return Param;
   
    }
   
    /// <summary>
    /// 返回存储过程返回的值
    /// </summary>
    /// <param name="ParamName"></param>
    /// <param name="DbType"></param>
    /// <returns></returns>
    public object ReturnParamValue(string ParamName, object DbType)
    {
       
        object ParamValue;
        ParamValue = SqlCmd.Parameters[ParamName].Value;
        return ParamValue;
    }
    /// <summary>
    /// 运行存储过程，返回存储过程返回值，存储过程带有参数
    /// </summary>
    /// <param name="storedProcedureString"></param>
    /// <param name="prams"></param>
    /// <returns></returns>
    public int ReturnExecuteNonQuery(string storedProcedureString)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        //加入返回参数
        this.SqlCmd.Parameters.Add(new SqlParameter("ReturnValue", SqlDbType.Int, 4, ParameterDirection.ReturnValue, false, 0, 0, string.Empty, DataRowVersion.Default, null));
        try
        {
            SqlCmd.ExecuteNonQuery();

        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        //返回存储过程的返回值
        return (int)SqlCmd.Parameters["ReturnValue"].Value;
    }
    /// <summary>
    /// 运行存储过程，返回存储过程返回值，存储过程带有参数
    /// </summary>
    /// <param name="storedProcedureString"></param>
    /// <param name="prams"></param>
    /// <returns></returns>
    public int ReturnExecuteNonQuery(string storedProcedureString, SqlParameter[] prams)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        this.SqlCmd.Parameters.Clear();
        foreach (SqlParameter parameter in prams)
        {
            SqlCmd.Parameters.Add(parameter);
        }
        //加入返回参数
        this.SqlCmd.Parameters.Add(new SqlParameter("ReturnValue", SqlDbType.Int, 4, ParameterDirection.ReturnValue, false, 0, 0, string.Empty, DataRowVersion.Default, null));
        try
        {
            SqlCmd.ExecuteNonQuery();

        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        //返回存储过程的返回值
        return (int)SqlCmd.Parameters["ReturnValue"].Value;
    }

    
   ///************************************* 执行数据操作，包括：DELETE,UPDATE,INSERT***************************************
   /// <summary>
   ///  执行数据操作，包括：DELETE,UPDATE,INSERT
   /// </summary>
   /// <param name="storedProcedureString">存储过程名</param>
   /// <param name="prams">参数组</param>
    public void ExecuteNonQuery(string storedProcedureString, SqlParameter[] prams)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        this.SqlCmd.Parameters.Clear();
        foreach (SqlParameter parameter in prams)
        {
           SqlCmd.Parameters.Add(parameter);
        }
        try
        {
            SqlCmd.ExecuteNonQuery();

        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
    }
    /// <summary>
    /// 重载, 执行数据操作，包括：DELETE,UPDATE,INSERT
    /// </summary>
    /// <param name="storedProcedureString">存储过程名</param>
    public void ExecuteNonQuery(string storedProcedureString)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        try
        {
            SqlCmd.ExecuteNonQuery();

        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
    }
    ///**************************************数据工厂用于返回数据集********************************************************
    /// <summary>
    /// 数据工厂用于返回数据集
    /// </summary>
    /// <param name="storedProcedureString">存储过程名</param>
    /// <returns>返回数据集</returns>
    public DataSet DataSetFactory(string storedProcedureString)
    {
      
       if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
           this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        this.ds = new DataSet();
        SqlAdpt.Fill(this.ds);
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        return ds;

    }
    /// <summary>
    /// 重载,有参数,数据工厂用于返回数据集,
    /// </summary>
    /// <param name="storedProcedureString"></param>
    /// <param name="prams"></param>
    /// <returns></returns>
    public DataSet DataSetFactory(string storedProcedureString, SqlParameter[] prams)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
                this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        this.SqlCmd.CommandTimeout = 20;
        this.SqlCmd.Parameters.Clear();
        foreach (SqlParameter parameter in prams)
        {
            SqlCmd.Parameters.Add(parameter);
        }
        this.ds = new DataSet();
        SqlAdpt.Fill(this.ds);
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        return ds;

    }
    
    ///*****************************************返回SqlDataReader检索到的值******************************************************
    /// <summary>
    /// 返回SqlDataReader检索到的值
    /// </summary>
    /// <param name="storedProcedureString">存储过程名</param>
    /// <returns></returns>
    public SqlDataReader DataReader(string storedProcedureString)
    {
       if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        try
        {
          
            SqlDr = this.SqlCmd.ExecuteReader(CommandBehavior.CloseConnection);
        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }
        return SqlDr;
    }
    /// <summary>
    /// 重载,返回SqlDataReader检索到的值
    /// </summary>
    /// <param name="storedProcedureString"></param>
    /// <param name="prams">参数组</param>
    /// <returns></returns>
    public SqlDataReader DataReader(string storedProcedureString, SqlParameter[] prams)
    {
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = storedProcedureString;
        this.SqlCmd.Parameters.Clear();
        foreach (SqlParameter parameter in prams)
        {
            SqlCmd.Parameters.Add(parameter);
        }
        try
        {
            SqlDr = this.SqlCmd.ExecuteReader(CommandBehavior.CloseConnection);
        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);
        }
        return SqlDr;
    }


    ///**********************************数据工厂返回数据集，并实现数据分页显示***********************************************
    /// <summary>
    /// 数据工厂返回数据集，并实现数据分页显示
    /// </summary>
    /// <param name="DataBinder">数据绑定对象名</param>
    /// <param name="Pager">分页控件名</param>
    /// <param name="storedProcedureString">数据绑定存储过程</param>
    /// <param name="PagerStorProcedureString">分页存储过程，检索出记录条数</param>
    /// /// <param name="prams">参数组</param>
    public int DataSetFactoryWithPager(DataList DataBinder, AspNetPager Pager, string storedProcedureString, string PagerStorProcedureString, SqlParameter[] prams)
    {

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();

        this.SqlCmd.Parameters.Clear();
        foreach (SqlParameter parameter in prams)
        {
            SqlCmd.Parameters.Add(parameter);
        }
        this.SqlCmd.CommandText = PagerStorProcedureString;
        Pager.RecordCount = (int)this.SqlCmd.ExecuteScalar();
        int RecordCount = Pager.RecordCount;
        this.SqlCmd.CommandText = storedProcedureString;

        this.ds = new DataSet();
        try
        {
            SqlAdpt.Fill(ds, Pager.PageSize * (Pager.CurrentPageIndex - 1), Pager.PageSize, "TableName");
            DataBinder.DataSource = ds.Tables["TableName"];
            DataBinder.DataBind();
        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);

        }
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        return RecordCount;
    }
    /// <summary>
    /// 重载,数据工厂返回数据集，并实现数据分页显示
    /// </summary>
    /// <param name="DataBinder">数据邦定对象名</param>
    /// <param name="Pager">分页控件名</param>
    /// <param name="storedProcedureString">数据邦定存储过程</param>
    /// <param name="PagerStorProcedureString">分页存储过程，检索出记录条数</param>
    public int DataSetFactoryWithPager(DataList DataBinder, AspNetPager Pager, string storedProcedureString, string PagerStorProcedureString)
    {

        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Closed))
            this.SqlCmd.Connection.Open();
        this.SqlCmd.CommandText = PagerStorProcedureString;
        Pager.RecordCount = (int)this.SqlCmd.ExecuteScalar();
        int RecordCount = Pager.RecordCount;
        this.SqlCmd.CommandText = storedProcedureString;

        this.ds = new DataSet();
        try
        {
            SqlAdpt.Fill(ds, Pager.PageSize * (Pager.CurrentPageIndex - 1), Pager.PageSize, "TableName");
            DataBinder.DataSource = ds.Tables["TableName"];
            DataBinder.DataBind();
        }
        catch (Exception ec)
        {
            throw new Exception(ec.Message, ec);

        }
        if (this.SqlCmd.Connection.State.Equals(ConnectionState.Open))
            this.SqlCmd.Connection.Close();
        return RecordCount;

    }

    ///*******************************************用来截取字符串的长度***********************************************************
    /// <summary>
    ///  用来截取字符串的长度，如果长多超过定义的长度，则用“…”省略。
   /// </summary>
   /// <param name="str">原字符串</param>
   /// <param name="length">要求显示的长度</param>
   /// <returns>返回修改后的字符串</returns>
    public string SubStr(string str, int length)
    {
        if (str.Trim().Length <= length)
        {
            return str;
        }
        else
        {
            string newStr;
            newStr = str.Substring(0, length);
            newStr += "…";
            return newStr;
        }
    }

    //图片的缩略图函数,按比例缩放图片,并非按原来大小裁剪 垂直长度优先
    //srcImagePath原图片相对路径
    //thumbIamgePath缩略图相对路径
    //public string ToThumbImage(string srcImagePath, string thumbImagePath,string srcImageName,int size)
    //{
    //    System.Drawing.Image img = System.Drawing.Image.FromFile(srcImagePath);
    //    int newHight = img.Height;
    //    int newWidth = img.Width;
    //    while (newWidth >size)//按比例缩小图片
    //    {
    //        newHight = Convert.ToInt32(newHight / 1.01);
    //        newWidth = Convert.ToInt32(newWidth / 1.01);
    //    }
    //    System.Drawing.Image newimg = img.GetThumbnailImage(newWidth, newHight, new System.Drawing.Image.GetThumbnailImageAbort(ThumbCallBack), IntPtr.Zero);
    //    System.Drawing.Bitmap bmp = new System.Drawing.Bitmap(newimg);
    //    string thumbImageName ="ch3g_"+srcImageName;
    //    bmp.Save(Server.MapPath(thumbImagePath)+thumbImageName);
    //    return thumbImageName;
    //}
    
}
