﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Data.OleDb;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace xhvote
{
    public partial class admin_subject : System.Web.UI.Page
    {
        private OleDbConnection connection = new conn().CreateConnection();
        protected void Page_Load(object sender, EventArgs e)
        {
            function.check();
            if (!Page.IsPostBack)
            {
                if (Request["act"] == "delps")
                {
                    ClearVotes();
                }
                if (Request["act"] == "del")
                {
                    DelSubject();
                }
                BindData("SELECT * FROM XH_Subject WHERE [Subject] LIKE \"%" +k.Text.Trim()+ "%\"ORDER BY [id] DESC");
            }
        }
        private void DelSubject()
        {
            function.IsNumberOrEmpty(Request["id"].ToString());
            if (connection.State == ConnectionState.Closed)
            {
                connection.Open();
            }
            OleDbTransaction OleTran = connection.BeginTransaction();
            try
            {
                OleDbCommand OleCmd = connection.CreateCommand();
                OleCmd.Transaction = OleTran;
                OleCmd.CommandText = "DELETE FROM XH_Subject WHERE [id]=" + Request["id"].Trim();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "DELETE FROM XH_Title WHERE [sid]=" + Request["id"].Trim();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "DELETE FROM XH_Question WHERE [sid]=" + Request["id"].Trim();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "DELETE FROM XH_UserInfo WHERE [sid]=" + Request["id"].Trim();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "DELETE FROM XH_IP WHERE [sid]=" + Request["id"].Trim();
                OleCmd.ExecuteNonQuery();
                OleTran.Commit();
            }
            catch
            {
                OleTran.Rollback();
            }
            finally
            {
                connection.Close();
            }
        }
        private void ClearVotes()
        {
            function.IsNumberOrEmpty(Request["id"].ToString());
            if (connection.State == ConnectionState.Closed) 
            {
                connection.Open(); 
            }
            OleDbTransaction OleTran = connection.BeginTransaction();
            try
            {
                OleDbCommand OleCmd = connection.CreateCommand();
                OleCmd.Transaction = OleTran;
                OleCmd.CommandText = "UPDATE XH_Title SET [vcount]=0 WHERE sid=" + Request["id"].ToString();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "UPDATE XH_Question SET [ps]=0 WHERE sid=" + Request["id"].ToString();
                OleCmd.ExecuteNonQuery();
                OleCmd.CommandText = "DELETE FROM XH_IP WHERE sid=" + Request["id"].ToString();
                OleCmd.ExecuteNonQuery();
                OleTran.Commit();
            }
            catch(Exception)
            {
                OleTran.Rollback();
            }
            finally
            {
                connection.Close();
            }
        }
        private void BindData(string sql)
        {
            try
            {
                OleDbDataAdapter da = new OleDbDataAdapter(sql, connection);
                DataSet ds = new DataSet();
                da.Fill(ds, "xh_subject");                
                datagrid1.DataSource = ds.Tables["xh_subject"].DefaultView;
                datagrid1.DataBind();
                ShowStateInfo(ds.Tables["xh_subject"].Rows.Count);
                if (ds.Tables["xh_subject"].Rows.Count == 0)
                {
                    function.showErr("还没有找到任何投票主题",Response,Request);
                }
            }
            finally
            {
                connection.Close();
            }
        }
        private void ShowStateInfo(int recordcnt)
        {
            records.Text = recordcnt.ToString();
            pages.Text = datagrid1.PageCount.ToString();
            curpage.Text = (datagrid1.CurrentPageIndex+1).ToString();
                 
        }
        protected void datagrid1_ItemCreated(object sender, DataGridItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Header)
            {
                CheckBox chk = (CheckBox)e.Item.FindControl("choose");
                chk.CheckedChanged += new EventHandler(chk_CheckChanged);                
            }
            else if (e.Item.ItemType == ListItemType.Footer)
            {
                CheckBox chk = (CheckBox)e.Item.FindControl("chooseF");
                chk.CheckedChanged += new EventHandler(chk_CheckChanged);
            }
            else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                e.Item.Attributes.Add("className", "out_TableTitle3");
                e.Item.Attributes.Add("onmouseover", "this.className='over_TableTitle3'");
                e.Item.Attributes.Add("onmouseout", "this.className='out_TableTitle3'");
            }            
        }

        protected void chk_CheckChanged(object sender, EventArgs e)
        {
            CheckBox chk = (CheckBox)sender;
            if (chk != null)
            {
                for (int i =0; i < datagrid1.Items.Count; i++)
                {
                    CheckBox chk1 = (CheckBox)datagrid1.Items[i].FindControl("IDchk");
                    chk1.Checked = chk.Checked;
                }
            }            
            
        }        
        public string Invalid(DateTime dt)
        {
            if (dt > DateTime.Now)
            {
                return "正常";
            }
            else
            {
                return "<font color='red'>到期</font>";
            }
        }
        public string SearchSubject(string value)
        {
            if (xhvote.function.nohtml(value) != null && xhvote.function.nohtml(value) != string.Empty)
            {
                return "所有投票主题->搜索结果" + xhvote.function.nohtml(value);
            }
            else
            {
                return "所有投票主题";
            }      
          
        }
        protected void datagrid1_PageIndexChanged(object source, DataGridPageChangedEventArgs e)
        {
            datagrid1.CurrentPageIndex = e.NewPageIndex;
            BindData("SELECT * FROM XH_Subject WHERE [Subject] LIKE \"%" + function.nohtml(k.Text.Trim()) + "%\" ORDER BY [id] DESC");
        }

        protected void First_Click(object sender, EventArgs e)
        {
            string ArgValue = ((LinkButton)sender).CommandArgument.ToString();
            switch (ArgValue)
            {
                case "FIRST":
                    datagrid1.CurrentPageIndex = 0;
                    break;
                case "PREV":
                    if (datagrid1.CurrentPageIndex > 0)
                    {
                        datagrid1.CurrentPageIndex -= 1;
                    }
                    break;
                case "NEXT":
                    if (datagrid1.CurrentPageIndex < (datagrid1.PageCount - 1))
                    {
                        datagrid1.CurrentPageIndex += 1;
                    }
                    break;
                case "LAST":
                    datagrid1.CurrentPageIndex = datagrid1.PageCount - 1;
                    break;                    
            }
            BindData("SELECT * FROM XH_Subject WHERE [Subject] LIKE \"%" + function.nohtml(k.Text.Trim()) + "%\" ORDER BY [id] DESC");
        }

        protected void DelChoosed_Click(object sender, EventArgs e)
        {
            string ids = "";
            for (int i = 0; i < datagrid1.Items.Count; i++)
            {
                CheckBox chk = (CheckBox)datagrid1.Items[i].FindControl("IDchk");
                if (chk.Checked == true)
                {
                    ids += chk.ToolTip.Trim() + ",";
                }
            }
            if (ids == null || ids == string.Empty || ids==",")
            {
                function.showErr("没有主题被选中",Response,Request);
                return;
            }
            ids = ids.Substring(0, ids.Length - 1);
            try
            {
                OleDbTransaction OleTran = connection.BeginTransaction();
                OleDbCommand OleCmd = connection.CreateCommand();
                OleCmd.Transaction = OleTran;
                try
                {
                    OleCmd.CommandText = "DELETE FROM XH_Subject WHERE [ID] in (" + ids + ")";
                    OleCmd.ExecuteNonQuery();
                    OleCmd.CommandText = "DELETE FROM XH_Title WHERE [sid] in (" + ids + ")";
                    OleCmd.ExecuteNonQuery();
                    OleCmd.CommandText = "DELETE FROM XH_Question WHERE [sid] in (" + ids + ")";
                    OleCmd.ExecuteNonQuery();
                    OleCmd.CommandText = "DELETE FROM XH_UserInfo WHERE [sid] in (" + ids + ")";
                    OleCmd.ExecuteNonQuery();
                    OleTran.Commit();
                }
                catch (Exception)
                {
                    OleTran.Rollback();
                }
                finally
                {
                    
                }
            }
            finally
            {
                connection.Close();
            }
            BindData("SELECT * FROM XH_Subject WHERE [Subject] LIKE \"%" + function.nohtml(k.Text.Trim()) + "%\" ORDER BY [id] DESC");
        }

        protected void Search_Click(object sender, EventArgs e)
        {
            BindData("SELECT * FROM XH_Subject WHERE [Subject] LIKE \"%" + function.nohtml(k.Text.Trim()) + "%\" ORDER BY [id] DESC"); 
        }       
    }
}
