﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Data.OleDb;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace xhvote
{
    public partial class admin_user : System.Web.UI.Page
    {
        private OleDbConnection connection = new conn().CreateConnection();
        protected void Page_Load(object sender, EventArgs e)
        {
            function.check();
            if (!IsPostBack)
            {
                if (Request["sid"] != null && Request["sid"].Trim() != "")
                {
                    function.IsNumberOrEmpty(Request["sid"].Trim());
                    BindSQL();
                }
                else if (Request["act"] != null && Request["act"] == "del")
                {
                    if(Request["id"]!=null && Request["id"]!="")
                    {
                        function.IsNumberOrEmpty(Request["id"]);
                        try
                        {
                            if (connection.State == ConnectionState.Closed)
                            {
                                connection.Open();
                            }
                            OleDbCommand OleCmd = new OleDbCommand("DELETE FROM XH_UserInfo WHERE [id]=" + Request["id"].Trim(), connection);
                            OleCmd.ExecuteNonQuery();
                        }
                        finally
                        {
                            connection.Close();
                        }
                    }                    
                }
                else if (Request["k"] != null && Request["k"] != string.Empty)
                {
                    BindSQL();
                }
                else
                {
                    BindSQL();
                }                
            }
        }
        private void BindData(string sql)
        {
            try
            {
                OleDbDataAdapter OleDa = new OleDbDataAdapter(sql, connection);
                DataSet ds = new DataSet();
                OleDa.Fill(ds, "userinfo");
                table2.DataSource = ds.Tables["userinfo"].DefaultView;
                table2.DataBind();
                ShowStatus(ds.Tables["userinfo"].Rows.Count);
            }
            finally
            {
                connection.Close();
            }            
        }
        public string GetSubject()
        {
            string subject = string.Empty;            
            function.IsNumberOrEmpty(Request["sid"]);
            try
            {
                if (connection.State == ConnectionState.Closed)
                {
                    connection.Open();
                }
                OleDbCommand OleCmd = connection.CreateCommand();
                OleCmd.CommandText = "SELECT [Subject] FROM XH_Subject WHERE [id]=" + Request["sid"].Trim();                
                OleDbDataReader OleDr = OleCmd.ExecuteReader();
                while (OleDr.Read())
                {
                    subject = OleDr.GetString(0);
                }
                OleDr.Close();                
            }
            catch (InvalidOperationException)
            {
            }
            finally
            {
                connection.Close();
            }
            return subject;
        }

        protected void table2_ItemCreated(object sender, DataGridItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Header)
            {
                CheckBox ChkHeader = (CheckBox)e.Item.FindControl("ChooseAllHeader");
                ChkHeader.CheckedChanged += new EventHandler(Chk_CheckedChanged);
            }
            else if (e.Item.ItemType == ListItemType.Footer)
            {
                CheckBox ChkFooter = (CheckBox)e.Item.FindControl("ChooseAllFooter");
                ChkFooter.CheckedChanged += new EventHandler(Chk_CheckedChanged);
            }
            else if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                e.Item.Attributes.Add("className", "out_TableTitle3");
                e.Item.Attributes.Add("onmouseover", "this.className='over_TableTitle3'");
                e.Item.Attributes.Add("onmouseout", "this.className='out_TableTitle3'");
            }
        }
        private void Chk_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox chk = (CheckBox)sender;
            for (int i = 0; i < table2.Items.Count; i++)
            {
                CheckBox ChkItem = (CheckBox)table2.Items[i].FindControl("chkItem");
                ChkItem.Checked = chk.Checked;
            }
        }
        public string GetKValue()
        {
            if (Request["k"] == null || Request["k"].Trim() == string.Empty)
            {
                return "所有用户";
            }
            else
            {
                return "搜索用户(" + Request["k"].Trim()+")";
            }
        }
        private void BindSQL()
        {
            if (Request["k"] != null && Request["k"] != string.Empty && Request["sid"] != null && Request["sid"] != string.Empty)
            {
                BindData("SELECT * FROM XH_UserInfo WHERE [name] LIKE \"%" + Request["k"].Trim() + "%\" and [sid]=" + Request["sid"].Trim());
            }
            else if ((Request["k"] == null || Request["k"].Trim() == string.Empty) && Request["sid"] != null && Request["sid"] != string.Empty)
            {
                BindData("SELECT * FROM XH_UserInfo WHERE [sid]=" + Request["sid"].Trim());
            }
            else if (Request["k"] != null && Request["k"].Trim() != string.Empty && (Request["sid"] == null || Request["sid"].Trim() == string.Empty))
            {
                BindData("SELECT * FROM XH_UserInfo WHERE [name] LIKE \"%" + Request["k"].Trim() + "%\"");
            }
            else
            {
                BindData("SELECT * FROM XH_UserInfo");
            }
        }

        protected void SearchUser_Click(object sender, EventArgs e)
        {
            BindSQL();
        }

        protected void DelChoose_Click(object sender, EventArgs e)
        {
            string ids = string.Empty;
            for (int i = 0; i < table2.Items.Count; i++)
            {
                CheckBox chk = (CheckBox)table2.Items[i].FindControl("chkItem");
                if (chk.Checked)
                {
                    ids += chk.ToolTip + ",";
                }
            }
            if (ids.Trim() == string.Empty || ids == ",")
            {
                function.showErr("未选择任何用户",Response,Request);
            }
            ids = ids.Substring(0,ids.Length-1);
            try
            {
                if (connection.State == ConnectionState.Closed)
                {
                    connection.Open();
                }
                OleDbCommand OleCmd = new OleDbCommand("DELETE FROM XH_UserInfo WHERE [ID] IN(" + ids + ")",connection);
                OleCmd.ExecuteNonQuery();
            }
            finally
            {
                connection.Close();
            }
        }
        private void ShowStatus(int counts)
        {
            records.Text = counts.ToString();
            pages.Text = table2.PageCount.ToString();
            curpage.Text = (table2.CurrentPageIndex + 1).ToString();
        }
        public string FormAction()
        {
            if (Request["sid"] != null && Request["sid"] != string.Empty)
            {
                return "?sid=" + Request["sid"].Trim();
            }
            else
            {
                return "";
            }
        }
        protected void first_Click(object sender, EventArgs e)
        {
            LinkButton btn = (LinkButton)sender;
            switch (btn.CommandArgument)
            {
                case "FIRST": table2.CurrentPageIndex = 0; break;
                case "PREV":
                    if (table2.CurrentPageIndex > 0)
                    {
                        table2.CurrentPageIndex -= 1;
                    }
                    break;
                case "NEXT":
                    if (table2.CurrentPageIndex == (table2.PageCount - 1))
                    {
                        table2.CurrentPageIndex += 1;
                    }
                    break;
                case "LAST":
                    table2.CurrentPageIndex = table2.PageCount - 1;
                    break;
            }
            BindSQL();
        }

        protected void table2_PageIndexChanged(object source, DataGridPageChangedEventArgs e)
        {
            table2.CurrentPageIndex = e.NewPageIndex;
            BindSQL();
        }
    }
}
