﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using Dal;


namespace Bll
{
    public class SysTypeBll
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(SysType model, string dbName = "")
        {
            try
            {
                return SysTypeDal.Add(model, dbName);
            }
            catch (Exception)
            {
                return 0;
            }

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(SysType model, string dbName = "")
        {
            try
            {
                return SysTypeDal.Update(model, dbName);
            }
            catch (Exception)
            {
                return 0;
            }

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string KeyField, string dbName = "")
        {

            try
            {
                return SysTypeDal.Delete(KeyField, dbName);
            }
            catch (Exception)
            {
                return 0;
            }

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static SysType GetModel(string id, string dbName = "")
        {
            try
            {
                return SysTypeDal.GetModel(id, dbName);
            }
            catch (Exception)
            {
                return null;
            }
        }

        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="recordCount">查询结果总数</param>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页条数</param>
        /// <param name="colNames">查询列,为空查全部列</param>
        /// <param name="where">条件，可为空</param>
        /// <param name="order">排序，可为空</param>
        /// <param name="dbName">数据库名</param>
        /// <param name="p">参数，条件不为空才用到</param>
        /// <returns></returns>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            return SysTypeDal.GetPageData(ref  recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
        }


    }
}
