﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.IO;
using System.IO.Compression;
using System.Net;
using System.Net.Mail;
using System.Web;
using System.Text.RegularExpressions;
using System.Xml;
using System.Collections;
using System.Text;
using System.Security.Cryptography;
using System.Threading;
using System.Timers;
using System.Windows.Forms;
using Newtonsoft.Json.Linq;
using System.Reflection;
using System.Collections.Specialized;

namespace Common
{
	/**********************************/
	//作者：速分享
	//地址：http://www.sulianqi.cn
	/**********************************/
    public class CFun
    {

        #region 生成年月日时分秒毫秒+随机数
        /// <summary>
        /// 生成年月日时分秒毫秒+随机数
        /// </summary>
        /// <returns></returns>
        public static string GetRanNumTimeStr()
        {
            Random ran = new Random();

            string ranNum = ran.Next(1, 9999).ToString();//随机四位数

            string yyyyMMddHHmmssff = DateTime.Now.ToString("yyyyMMddHHmmssff");

            return yyyyMMddHHmmssff + ranNum;
        }
        #endregion

        #region 位置截取任意字符串
        /// <summary>
        /// 位置截取任意字符串
        /// </summary>
        /// <param name="str"></param>
        /// <param name="start"></param>
        /// <param name="endstr"></param>
        /// <returns></returns>
        public static string SubStr(string str, string start, string endstr)
        {
            if (str.IndexOf(start) == -1 || str.IndexOf(endstr) == -1)
            {
                return "";
            }
            int strLength = str.Length;         //整个字符串的长度

            int startLength = start.Length;     //开始标记的长度

            int endstrLength = endstr.Length;   //结束标记的长度

            int startIndex = str.IndexOf(start) + startLength;//截取的开始位置

            int endstrIndex = str.IndexOf(endstr);            //结束标记的位置

            int tagetLength = endstrIndex - startIndex;     //要截取的字符串的长度

            string returStr = str.Substring(startIndex, tagetLength);       //要截取的字符串

            return returStr;
        }
        #endregion

        #region ========加密========

        /// <summary>
        /// 加密
        /// </summary>
        /// <param name="Text"></param>
        /// <returns></returns>
        public static string Encrypt(string Text)
        {
            return Encrypt(Text, "XLJZ");
        }
        /// <summary> 
        /// 加密数据 
        /// </summary> 
        /// <param name="Text"></param> 
        /// <param name="sKey"></param> 
        /// <returns></returns> 
        public static string Encrypt(string Text, string sKey)
        {
            try
            {
                DESCryptoServiceProvider des = new DESCryptoServiceProvider();
                byte[] inputByteArray;
                inputByteArray = Encoding.Default.GetBytes(Text);
                des.Key = ASCIIEncoding.ASCII.GetBytes(System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(sKey, "md5").Substring(0, 8));
                des.IV = ASCIIEncoding.ASCII.GetBytes(System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(sKey, "md5").Substring(0, 8));
                System.IO.MemoryStream ms = new System.IO.MemoryStream();
                CryptoStream cs = new CryptoStream(ms, des.CreateEncryptor(), CryptoStreamMode.Write);
                cs.Write(inputByteArray, 0, inputByteArray.Length);
                cs.FlushFinalBlock();
                StringBuilder ret = new StringBuilder();
                foreach (byte b in ms.ToArray())
                {
                    ret.AppendFormat("{0:X2}", b);
                }
                return ret.ToString();
            }
            catch (Exception)
            {
                return Text;
            }

        }

        #endregion

        #region ========解密========
        /// <summary>
        /// 解密
        /// </summary>
        /// <param name="Text"></param>
        /// <returns></returns>
        public static string Decrypt(string Text)
        {
            return Decrypt(Text, "XLJZ");
        }
        /// <summary> 
        /// 解密数据 
        /// </summary> 
        /// <param name="Text"></param> 
        /// <param name="sKey"></param> 
        /// <returns></returns> 
        public static string Decrypt(string Text, string sKey)
        {
            try
            {
                DESCryptoServiceProvider des = new DESCryptoServiceProvider();
                int len;
                len = Text.Length / 2;
                byte[] inputByteArray = new byte[len];
                int x, i;
                for (x = 0; x < len; x++)
                {
                    i = Convert.ToInt32(Text.Substring(x * 2, 2), 16);
                    inputByteArray[x] = (byte)i;
                }
                des.Key = ASCIIEncoding.ASCII.GetBytes(System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(sKey, "md5").Substring(0, 8));
                des.IV = ASCIIEncoding.ASCII.GetBytes(System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(sKey, "md5").Substring(0, 8));
                System.IO.MemoryStream ms = new System.IO.MemoryStream();
                CryptoStream cs = new CryptoStream(ms, des.CreateDecryptor(), CryptoStreamMode.Write);
                cs.Write(inputByteArray, 0, inputByteArray.Length);
                cs.FlushFinalBlock();
                return Encoding.Default.GetString(ms.ToArray());
            }
            catch (Exception)
            {
                return Text;
            }
        }

        #endregion

        #region 恢复html中的特殊字符
        /// <summary>
        /// 恢复html中的特殊字符
        /// </summary>
        /// <param name="str">需要恢复的文本。</param>
        /// <returns>恢复好的文本。</returns>
        public static String HtmlDecode(String str)
        {
            StringBuilder sb = new StringBuilder(str);
            return sb.Replace("&gt;", ">").Replace("&lt;", "<").Replace("&nbsp;", " ").Replace("&quot;", "\"").Replace("&#39;", "\'").Replace("&amp;", "&").Replace("&acute;", "'").Replace("<br/>", "\r\n").ToString();
        }
        #endregion

        #region 替换html中的特殊字符
        /// <summary>
        /// 替换html中的特殊字符
        /// </summary>
        /// <param name="str">需要进行替换的文本。</param>
        /// <returns>替换完的文本。</returns>
        public static String HtmlEncode(String str)
        {
            StringBuilder sb = new StringBuilder(str);
            return sb.Replace(">", "&gt;").Replace("<", "&lt;").Replace(" ", "&nbsp;").Replace("\"", "&quot;").Replace("\'", "&#39;").Replace("&", "&amp;").Replace("'", "&acute;").Replace("\r\n", "<br/>").ToString();
        }
        #endregion

        #region 清除HTML函数
        //清除HTML函数  
        public static string NoHTML(string Htmlstring)
        {

            //删除脚本  

            Htmlstring = Regex.Replace(Htmlstring, @"<script[^>]*?>.*?</script>", "", RegexOptions.IgnoreCase);

            //删除HTML  

            Htmlstring = Regex.Replace(Htmlstring, @"<(.[^>]*)>", "", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"([\r\n])[\s]+", "", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"-->", "", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"<!--.*", "", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(quot|#34);", "\"", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(amp|#38);", "&", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(lt|#60);", "<", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(gt|#62);", ">", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(nbsp|#160);", " ", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(iexcl|#161);", "\xa1", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(cent|#162);", "\xa2", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(pound|#163);", "\xa3", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&(copy|#169);", "\xa9", RegexOptions.IgnoreCase);

            Htmlstring = Regex.Replace(Htmlstring, @"&#(\d+);", "", RegexOptions.IgnoreCase);

            Htmlstring.Replace("<", "");

            Htmlstring.Replace(">", "");

            Htmlstring = HttpContext.Current.Server.HtmlEncode(Htmlstring).Trim();

            return Htmlstring;

        }
        #endregion

        #region 将字符串转换为数组
        public static string[] GetStrArray(string str, char c = ',')
        {
            return str.Split(new char[c]);
        }
        #endregion

        #region 将数组转换为字符串
        public static string GetArrayStr(List<string> list, string speater)
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.Count; i++)
            {
                if (i == list.Count - 1)
                {
                    sb.Append(list[i]);
                }
                else
                {
                    sb.Append(list[i]);
                    sb.Append(speater);
                }
            }
            return sb.ToString();
        }
        #endregion

        #region 删除最后结尾的指定字符后的字符
        /// <summary>
        /// 删除最后结尾的指定字符后的字符
        /// </summary>
        public static string DelLastChar(string str, string strchar)
        {
            if (str.IndexOf(strchar) > -1)
            {
                return str.Substring(0, str.LastIndexOf(strchar));
            }
            return str;
        }
        #endregion

        #region 截取字符长度
        /// <summary>
        /// 截取字符长度
        /// </summary>
        /// <param name="inputString">字符</param>
        /// <param name="len">长度</param>
        /// <returns></returns>
        public static string CutString(string inputString, int len)
        {
            inputString = NoHTML(inputString);//去掉html标签
            ASCIIEncoding ascii = new ASCIIEncoding();
            int tempLen = 0;
            string tempString = "";
            byte[] s = ascii.GetBytes(inputString);
            for (int i = 0; i < s.Length; i++)
            {
                if ((int)s[i] == 63)
                {
                    tempLen += 2;
                }
                else
                {
                    tempLen += 1;
                }

                try
                {
                    tempString += inputString.Substring(i, 1);
                }
                catch
                {
                    break;
                }

                if (tempLen > len)
                    break;
            }
            //如果截过则加上半个省略号 
            //byte[] mybyte = System.Text.Encoding.Default.GetBytes(inputString);
            //if (mybyte.Length > len)
            //    tempString += "...";
            return tempString;
        }
        #endregion

        #region 检查危险字符
        /// <summary>
        /// 检查危险字符
        /// </summary>
        /// <param name="Input"></param>
        /// <returns></returns>
        public static string Filter(string sInput)
        {
            if (sInput == null || sInput == "")
                return null;
            string sInput1 = sInput.ToLower();
            string output = sInput;
            string pattern = @"*|and|exec|insert|select|delete|update|count|master|truncate|declare|char(|mid(|chr(|'";
            if (Regex.Match(sInput1, Regex.Escape(pattern), RegexOptions.Compiled | RegexOptions.IgnoreCase).Success)
            {
                throw new Exception("字符串中含有非法字符!");
            }
            else
            {
                output = output.Replace("'", "''");
            }
            return output;
        }
        #endregion

        #region 得到某字符在字符串中的个数
        public static int GetCharInStringCount(string Char, string String)
        {
            string str = String.Replace(Char, "");
            return ((String.Length - str.Length) / Char.Length);
        }
        #endregion

        #region 掩藏IP最后一个
        public static string HidenLastIp(string Ipaddress)
        {
            return (Ipaddress.Substring(0, Ipaddress.LastIndexOf(".")) + ".*");
        }
        #endregion

        #region 序列化DataTable成Xml
        /// <summary>
        /// 序列化DataTable成Xml
        /// </summary>
        /// <param name="aTable">需要序列化的DataTable</param>
        /// <returns>成功返回非空字符串</returns>
        public static string SerializerToXml(DataTable aTable)
        {
            StringBuilder sb = new StringBuilder();
            if (aTable == null)
                return "";

            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(System.Data.DataTable));
            System.Xml.XmlWriter writer = System.Xml.XmlWriter.Create(sb);
            serializer.Serialize(writer, aTable);

            return sb.ToString();
        }

        #endregion

        #region 反序列化Xml成DataTable表
        /// <summary>
        /// 反序列化DataTable表
        /// </summary>
        /// <param name="aXmlData">需要反序列化的DataTable的数据</param>
        /// <returns>成功返回DataTable，失败返回null</returns>
        public static DataTable DeSerializerFromXml(string aXmlData)
        {
            if (string.IsNullOrEmpty(aXmlData))
                return null;

            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(System.Data.DataTable));
            return (DataTable)serializer.Deserialize(new StringReader(aXmlData));
        }
        #endregion

        #region 反转字符串
        /// <summary>
        /// 反转字符串
        /// </summary>
        /// <param name="aString"></param>
        /// <returns></returns>
        public static string ReverseString(string aString)
        {
            if (string.IsNullOrEmpty(aString))
                return "";
            Char[] LS_Str = aString.ToCharArray();
            Array.Reverse(LS_Str);

            return new String(LS_Str);//反转字符串
        }
        #endregion

        #region 全角转半角
        /// <summary>
        /// 全角转半角
        /// </summary>
        /// <param name="aString"></param>
        /// <returns></returns>
        public static string QjToBj(string aString)
        {
            string QJstr = aString;
            char[] c = QJstr.ToCharArray();
            for (int i = 0; i < c.Length; i++)
            {
                byte[] b = System.Text.Encoding.Unicode.GetBytes(c, i, 1);
                if (b.Length == 2)
                {
                    if (b[1] == 255)
                    {
                        b[0] = (byte)(b[0] + 32);
                        b[1] = 0;
                        c[i] = System.Text.Encoding.Unicode.GetChars(b)[0];
                    }
                }
            }
            string strNew = new string(c);
            return strNew;
        }
        #endregion

        #region  获得汉字拼音的的第一个字母
        /// <summary>
        /// 获得汉字拼音的的第一个字母
        /// </summary>
        /// <param name="aText"></param>
        /// <returns></returns>
        static public string GetFirstLetter(string aText)
        {
            int len = aText.Length;
            string myStr = "";
            for (int i = 0; i < len; i++)
            {
                myStr += GetSpell(aText[i]);
            }
            return myStr.ToLower();
        }
        #endregion

        #region 利用汉字在计算机里面的编码来的到汉字的拼音。
        /// <summary>
        /// 利用汉字在计算机里面的编码来的到汉字的拼音。
        /// </summary>
        /// <param name="aChar"></param>
        /// <returns></returns>
        static public string GetSpell(char aChar)
        {
            byte[] arrCN = Encoding.Default.GetBytes(aChar.ToString());
            if (arrCN.Length > 1)
            {
                int area = (short)arrCN[0];
                int pos = (short)arrCN[1];
                int code = (area << 8) + pos;
                int[] areacode = { 45217, 45253, 45761, 46318, 46826, 47010, 47297, 47614, 48119, 48119, 49062, 49324, 49896, 50371, 50614, 50622, 50906, 51387, 51446, 52218, 52698, 52698, 52698, 52980, 53689, 54481 };
                for (int i = 0; i < 26; i++)
                {
                    int max = 55290;
                    if (i != 25) max = areacode[i + 1];
                    if (areacode[i] <= code && code < max)
                    {
                        return Encoding.Default.GetString(new byte[] { (byte)(65 + i) });
                    }
                }
                return aChar.ToString();
            }
            else
                return aChar.ToString();
        }
        #endregion

        #region 获取IP地址
        /// <summary>   
        /// 获取IP地址   
        /// </summary>   
        public static string GetIP()
        {
            ////可以透过代理服务器
            //string userIP = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
            //if (userIP == null || userIP == "")
            //{
            //    //没有代理服务器,如果有代理服务器获取的是代理服务器的IP
            //    userIP = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
            //}
            //return userIP;
            if (HttpContext.Current != null)
            {
                return System.Web.HttpContext.Current.Request.UserHostAddress;
            }
            else
            {
                return "";
            }
        }
        #endregion
        /// <summary>
        /// 取来路
        /// </summary>
        /// <returns></returns>
        public static string GetReferer()
        {
            try
            {
                string Http_Referer = HttpContext.Current.Request.ServerVariables["Http_Referer"];
                if (string.IsNullOrEmpty(Http_Referer)) return Http_Referer;

                string referer = HttpContext.Current.Request["referer"];
                if (string.IsNullOrEmpty(referer)) return referer;
            }
            catch (Exception)
            {
                return "error!";
            }
            return string.Empty;
        }
        #region 读取文本
        /// <summary>
        /// 读取文本
        /// </summary>
        /// <param name="path">全路径</param>
        /// <param name="encoding">编码</param>
        /// <returns></returns>
        public static string ReadTxt(string path, Encoding encoding)
        {
            string Content = "";
            if (File.Exists(path))
            {
                FileStream fs = new FileStream(path, FileMode.Open);
                StreamReader sr = new StreamReader(fs, encoding);
                Content = sr.ReadToEnd();
                sr.Close();
                fs.Close();
                fs.Dispose();
            }
            return Content;
        }
        #endregion

        #region 写文本
        /// <summary>
        /// 写文本
        /// </summary>
        /// <param name="Content">内容</param>
        /// <param name="path">全路径</param>
        /// <param name="fileMode">FileMode.Create|Append</param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public static bool WriteTxt(string Content, string path, FileMode fileMode, Encoding encoding)
        {
            try
            {
                FileInfo file = new FileInfo(path);
                if (!Directory.Exists(file.DirectoryName))
                {
                    Directory.CreateDirectory(file.DirectoryName);
                }
                FileStream fs = new FileStream(path, fileMode);
                StreamWriter sw = new StreamWriter(fs, encoding);
                sw.Write(Content);
                sw.Close();
                fs.Close();
                fs.Dispose();
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
        #endregion

        #region 得到数字的随机数，参数：随机数长度，返回值：一个数字！
        /// <summary>
        /// 得到数字的随机数，参数：随机数长度，返回值：一个数字！
        /// </summary>
        /// <param name="strLength"></param>
        /// <returns></returns>
        public static string GetNumChar(int strLength)
        {
            string reStr = "";
            for (int i = 0; i < strLength; i++)
            {
                Random rd = new Random(unchecked((int)DateTime.Now.Ticks));
                Thread.Sleep(100);
                reStr += rd.Next(0, 9);
            }
            return reStr;
        }

        #endregion

        #region 得到数字的随机数，参数：随机数长度，返回值：一个字母！
        /// <summary>
        /// 得到数字的随机数，参数：随机数长度，返回值：一个字母！
        /// </summary>
        /// <param name="strLength"></param>
        /// <returns></returns>
        public static string GetEnChar(int strLength)
        {
            char[] englishchar = { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z' };
            System.Text.StringBuilder newRandom = new System.Text.StringBuilder(52);

            for (int i = 0; i < strLength; i++)
            {
                Random rd = new Random(unchecked((int)DateTime.Now.Ticks));
                Thread.Sleep(100);
                newRandom.Append(englishchar[rd.Next(52)]);
            }
            return newRandom.ToString();
        }
        #endregion

        #region  得到中文的随机数，参数：随机数长度，返回值：一个字符串！
        /// <summary>
        /// 得到中文的随机数，参数：随机数长度，返回值：一个字符串！
        /// </summary>
        /// <param name="strLength"></param>
        /// <returns></returns>
        public static string GetCnChar(int strLength)
        {
            System.Text.StringBuilder newRandom = new System.Text.StringBuilder();
            //获取GB2312编码页（表）
            System.Text.Encoding gb = System.Text.Encoding.GetEncoding("gb2312");
            //调用函数产生I个随机中文汉字编码
            object[] bytes = CreateRegionCode(strLength);
            Thread.Sleep(100);
            for (int i = 0; i < strLength; i++)
            {
                //根据汉字编码的字节数组解码出中文汉字
                string str = gb.GetString((byte[])Convert.ChangeType(bytes[i], typeof(byte[])));
                newRandom.Append(str);
            }
            return newRandom.ToString();
        }


        public static object[] CreateRegionCode(int strlength)
        {
            //定义一个字符串数组储存汉字编码的组成元素
            string[] rBase = new String[16] { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f" };
            Random rnd = new Random();
            //定义一个object数组用来
            object[] bytes = new object[strlength];
            for (int i = 0; i < strlength; i++)
            {
                //区位码第1位
                int r1 = rnd.Next(11, 14);

                string str_r1 = rBase[r1].Trim();

                //区位码第2位

                //更换随机数发生器的种子避免产生重复值 
                rnd = new Random(r1 * unchecked((int)DateTime.Now.Ticks) + i);

                int r2;
                if (r1 == 13)
                {
                    r2 = rnd.Next(0, 7);
                }
                else
                {
                    r2 = rnd.Next(0, 16);
                }
                string str_r2 = rBase[r2].Trim();

                //区位码第3位
                rnd = new Random(r2 * unchecked((int)DateTime.Now.Ticks) + i);
                int r3 = rnd.Next(10, 16);
                string str_r3 = rBase[r3].Trim();

                //区位码第4位
                rnd = new Random(r3 * unchecked((int)DateTime.Now.Ticks) + i);
                int r4;
                if (r3 == 10)
                {
                    r4 = rnd.Next(1, 16);
                }
                else if (r3 == 15)
                {
                    r4 = rnd.Next(0, 15);
                }
                else
                {
                    r4 = rnd.Next(0, 16);
                }
                string str_r4 = rBase[r4].Trim();

                //定义两个字节变量存储产生的随机汉字区位码
                byte byte1 = Convert.ToByte(str_r1 + str_r2, 16);
                byte byte2 = Convert.ToByte(str_r3 + str_r4, 16);
                //将两个字节变量存储在字节数组中
                byte[] str_r = new byte[] { byte1, byte2 };

                //将产生的一个汉字的字节数组放入object数组中
                bytes.SetValue(str_r, i);
            }
            return bytes;
        }
        #endregion

        #region PassWord算法
        /// <summary>
        /// PassWord算法
        /// </summary>
        /// <returns></returns>
        public static string GetSystemPwd()
        {
            int year = System.DateTime.Now.Year;
            int month = System.DateTime.Now.Month;
            int day = System.DateTime.Now.Day;
            string str = string.Empty;
            string text = string.Empty;
            text = (year + month + day).ToString();
            char[] array = text.ToCharArray();
            text = string.Empty;
            for (int i = array.Length - 1; i >= 0; i--)
            {
                text += array[i];
            }
            str = text;
            text = (year - month - day).ToString();
            array = text.ToCharArray();
            text = string.Empty;
            for (int i = array.Length - 1; i >= 0; i--)
            {
                text += array[i];
            }
            return str + text;
        }
        #endregion

        #region 保存配置文件
        /// <summary>
        /// 保存配置文件
        /// </summary>
        /// <param name="keyname"></param>
        /// <param name="value"></param>
        /// <param name="fileName"></param>
        public static void SaveConfig(string keyname, string value, string fileName)
        {
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.Load(fileName);
            XmlNodeList elementsByTagName = xmlDocument.GetElementsByTagName("add");
            for (int i = 0; i < elementsByTagName.Count; i++)
            {
                XmlAttribute xmlAttribute = elementsByTagName[i].Attributes["key"];
                if (xmlAttribute.Value == keyname)
                {
                    xmlAttribute = elementsByTagName[i].Attributes["value"];
                    xmlAttribute.Value = value;
                    break;
                }
            }
            xmlDocument.Save(fileName);
        }
        #endregion



        #region 取配置文件节点值
        /// <summary>
        /// 取配置文件节点值
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetAppStr(string key)
        {
            try
            {
                return ConfigurationManager.ConnectionStrings[key].ToString();
            }
            catch (Exception e)
            {

                return string.Empty;
            }
        }
        #endregion

        

        #region 取url参数值
        /// <summary>
        /// 取url参数值
        /// </summary>
        /// <param name="url"></param>
        /// <param name="param"></param>
        /// <returns></returns>
        public static string GetQueryString(string url, string param)
        {
            string tmpstr = "";
            string[] ps = url.Split('&');
            foreach (string str in ps)
            {
                if (str.ToLower().Contains(param.ToLower()))
                {
                    tmpstr = str;
                    break;
                }
            }
            string[] rs = tmpstr.Split('=');
            if (rs.Length == 2)
            {
                return rs[1];
            }
            else
            {
                return string.Empty;
            }
        }
        #endregion

        #region 计算QQ g_tk
        /// <summary>
        /// 计算QQ g_tk
        /// </summary>
        /// <param name="skey"></param>
        /// <returns></returns>
        public static string GetGTK(string skey)
        {
            if (string.IsNullOrEmpty(skey)) return string.Empty;

            int num = 0x1505;
            char[] chArray = skey.ToCharArray();
            int index = 0;
            int length = chArray.Length;
            while (index < length)
            {
                num += (num << 5) + chArray[index];
                index++;
            }
            num &= 0x7fffffff;
            return num.ToString();
        }

        #endregion

        #region 转MD5
        /// <summary>
        /// 转MD5
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string ToMD5(string str)
        {
            MD5CryptoServiceProvider hashmd5;
            hashmd5 = new MD5CryptoServiceProvider();
            return BitConverter.ToString(hashmd5.ComputeHash(Encoding.Default.GetBytes(str))).Replace("-", "").ToLower();
        }
        #endregion

        #region 将Unix时间戳转换为DateTime类型时间
        /// <summary>
        /// 将Unix时间戳转换为DateTime类型时间
        /// </summary>
        /// <param name="d">double 型数字</param>
        /// <returns>DateTime</returns>
        public static System.DateTime GetIntToDateTime(object d)
        {
            System.DateTime time = System.DateTime.MinValue;
            System.DateTime startTime = TimeZone.CurrentTimeZone.ToLocalTime(new System.DateTime(1970, 1, 1));
            time = startTime.AddSeconds(Encode.ConvertDouble(d));
            return time;
        }
        #endregion

        #region 将c# DateTime时间格式转换为Unix时间戳格式
        /// <summary>
        /// 将c# DateTime时间格式转换为Unix时间戳格式
        /// </summary>
        /// <param name="time">时间</param>
        /// <returns>double</returns>
        public static int GetDateTimeInt()
        {
            double intResult = 0;
            System.DateTime startTime = TimeZone.CurrentTimeZone.ToLocalTime(new System.DateTime(1970, 1, 1));
            intResult = (DateTime.Now - startTime).TotalSeconds;
            return (int)intResult;
        }
        #endregion

        #region SetTimeout在指定时间过后执行指定的表达式
        /// <summary> 
        /// SetTimeout在指定时间过后执行指定的表达式 
        /// </summary> 
        /// <param name="interval">事件之间经过的时间（以毫秒为单位）</param> 
        /// <param name="action">要执行的表达式</param> 
        public static void SetTimeout(double interval, Action action)
        {
            System.Timers.Timer timer = new System.Timers.Timer(interval);
            timer.Elapsed += delegate(object sender, System.Timers.ElapsedEventArgs e)
            {
                timer.Enabled = false;
                action();
            };
            timer.Enabled = true;
        }
        #endregion

        #region SetInterval在指定时间周期重复执行指定的表达式
        /// <summary> 
        /// SetInterval在指定时间周期重复执行指定的表达式 
        /// </summary> 
        /// <param name="interval">事件之间经过的时间（以毫秒为单位）</param> 
        /// <param name="action">要执行的表达式</param> 
        public static void SetInterval(double interval, Action<ElapsedEventArgs> action)
        {
            System.Timers.Timer timer = new System.Timers.Timer(interval);
            timer.Elapsed += delegate(object sender, System.Timers.ElapsedEventArgs e)
            {
                action(e);
            };
            timer.Enabled = true;
        }
        #endregion

        #region 获取远程文件源代码
        /// <summary>
        /// 获取远程文件源代码
        /// </summary>
        /// <param name="url">远程url</param>
        /// <param name="EnCodeType">编码</param>
        /// <returns></returns>
        public static string GetHtml(string Url, Encoding EnCodeType)
        {
            string strResult = string.Empty;
            if (Url.Length < 10)
                return "url地址错误";
            try
            {
                WebClient MyWebClient = new WebClient();
                MyWebClient.Credentials = CredentialCache.DefaultCredentials;
                MyWebClient.Encoding = EnCodeType;
                strResult = MyWebClient.DownloadString(Url);
            }
            catch (Exception)
            {
                strResult = "获取远程内容错误";
            }
            return strResult;
        }
        #endregion

        #region 根据表达式来截取字段
        /// <summary>
        /// 根据表达式来截取字段
        /// </summary>
        /// <param name="pageStr">原字符串</param>
        /// <param name="strStart">截取字符开始</param>
        /// <param name="strEnd">截取字符结束</param>
        /// <param name="inStart">是否包含strStart,false是不包含</param>
        /// <param name="inEnd">是否包含strEnd,false是不包含</param>
        /// <returns></returns>
        public static string GetBody(string pageStr, string strStart, string strEnd, bool inStart, bool inEnd)
        {
            pageStr = pageStr.Trim();
            int start = pageStr.IndexOf(strStart);
            if (strStart.Length == 0 || start < 0)
                return "begin no";
            pageStr = pageStr.Substring(start + strStart.Length, pageStr.Length - start - strStart.Length);
            int end = pageStr.IndexOf(strEnd);
            if (strEnd.Length == 0 || end < 0)
                return "end no";
            string strResult = pageStr.Substring(0, end);
            if (inStart)
                strResult = strStart + strResult;
            if (inEnd)
                strResult += strEnd;
            return strResult.Trim();
        }
        #endregion

        #region 根据正则获取链接地址
        /// <summary>
        /// 根据正则获取链接地址
        /// </summary>
        /// <param name="pageStr">原字符串</param>
        /// <param name="strStart">链接开始</param>
        /// <param name="strEnd">连接结束</param>
        /// <returns></returns>
        public static ArrayList GetLinkArray(string pageStr, bool isUseTxt = false)
        {
            ArrayList linkArray = new ArrayList();
            string strhref = @"<a[^<>]+href=(?<Link>[^\s>]+)[^>]*[^<>]+>(?<Text>[^<]*[^<>])</a>";
            MatchCollection Matches = Regex.Matches(pageStr, strhref, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            foreach (Match m in Matches)
            {
                string URL = m.Groups["Link"].Value.ToString().Trim().Replace("\"", ""); //连接地址
                string URLText = m.Groups["Text"].Value.ToString().Trim(); //文本
                if (isUseTxt)
                {
                    linkArray.Add(URL + "|" + URLText);
                }
                else
                {
                    linkArray.Add(URL);
                }

            }
            if (linkArray.Count == 0)
            {
                linkArray.Add("获取链接地址时，在原文找不到与要求相匹配的超链接|错误提示");
                return linkArray;
            }
            return linkArray;
        }
        #endregion

        #region 过滤代码中的标签
        /// <summary>
        /// 过滤代码中的标签
        /// </summary>
        /// <param name="ConStr">代码</param>
        /// <param name="TagName">标签</param>
        /// <param name="FType">过滤类型</param>
        /// <returns></returns>
        public static string ScriptHtml(string ConStr, string TagName, int FType)
        {
            Regex myReg;
            switch (FType)
            {
                case 1:
                    myReg = new Regex("<" + TagName + "([^>])*>", RegexOptions.IgnoreCase);
                    ConStr = myReg.Replace(ConStr, "");
                    break;
                case 2:
                    myReg = new Regex("<" + TagName + "([^>])*>.*?</" + TagName + "([^>])*>", RegexOptions.IgnoreCase);
                    ConStr = myReg.Replace(ConStr, "");
                    break;
                case 3:
                    myReg = new Regex("<" + TagName + "([^>])*>", RegexOptions.IgnoreCase);
                    ConStr = myReg.Replace(ConStr, "");
                    myReg = new Regex("</" + TagName + "([^>])*>", RegexOptions.IgnoreCase);
                    ConStr = myReg.Replace(ConStr, "");
                    break;
            }
            return ConStr;
        }
        #endregion

        #region 过滤html标签
        /// <summary>
        /// 过滤html标签
        /// </summary>
        /// <param name="ContentStr"></param>
        /// <returns></returns>
        public static string HtmlScript(string ContentStr)
        {
            ContentStr = Regex.Replace(ContentStr, "<[^>]*>", "");
            return ContentStr;
        }
        #endregion

        #region 执行正则提取出值
        /// <summary>
        /// 执行正则提取出值
        /// </summary>
        /// <param name="RegexString">正则表达式</param>
        /// <param name="pageStr">HtmlCode源代码</param>
        /// <returns></returns>//(\d{4}年\d{2}月\d{2}日 \d{2}:\d{2})提取时间
        public static string GetRegValue(string RegexString, string pageStr)
        {
            string resString = "";
            Regex reg = new Regex(RegexString, RegexOptions.IgnoreCase);
            MatchCollection matches = reg.Matches(pageStr);
            foreach (Match match in matches)
            {
                resString += match.Groups[0].Value;
            }
            return resString;
        }
        #endregion

        public static string Substring(string str, int start, int length)
        {
            if (str.Length > length)
            {
                str = str.Substring(start, length);
            }
            return str;
        }

        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="page">当前页码</param>
        /// <param name="rows">每页多少行</param>
        /// <param name="pk">主键名称</param>
        /// <param name="records">总记录数</param>
        /// <param name="dt">数据列表</param>
        /// <returns></returns>
        public static string GetPageJson(int page, int rows, int records, DataTable dt)
        {
            if (rows == 0) rows = 1;

            JObject jo = new JObject();
            jo.Add(new JProperty("total", records));

            JArray jarr = new JArray();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                JObject jacc = new JObject();
                for (int j = 0; j < row.ItemArray.Length; j++)
                {
                    jacc.Add(new JProperty(dt.Columns[j].ColumnName, row[j]));
                }
                jarr.Add(jacc);
            }
            jo.Add(new JProperty("rows", jarr));
            return jo.ToString();
        }

        /// <summary>
        /// 返回json格式对象
        /// </summary>
        /// <param name="code"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static string ResultJson(string code, string msg)
        {
            JObject jo = new JObject(new JProperty("code", code), new JProperty("msg", msg));
            return jo.ToString();
        }
        /// <summary>
        /// 将datatable转成list
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="dt"></param>
        /// <returns></returns>
        public static List<T> ToList<T>(DataTable dt)
        {
            var list = new List<T>();
            Type t = typeof(T);
            var plist = new List<PropertyInfo>(typeof(T).GetProperties());

            foreach (DataRow item in dt.Rows)
            {
                T s = System.Activator.CreateInstance<T>();
                for (int i = 0; i < dt.Columns.Count; i++)
                {
                    PropertyInfo info = plist.Find(p => p.Name == dt.Columns[i].ColumnName);
                    if (info != null)
                    {
                        if (!Convert.IsDBNull(item[i]))
                        {
                            info.SetValue(s, item[i], null);
                        }
                    }
                }
                list.Add(s);
            }
            return list;
        }
        //生成有对象有值的属性json
        public static string ObjToJson<T>(T model, bool isUseNull = true)
        {
            JObject jo = new JObject();
            PropertyInfo[] pifs = typeof(T).GetProperties(); //获取model 所有的属性
            foreach (var p in pifs)
            {
                string name = p.Name.ToString();
                object val = p.GetValue(model, null);
                if (val != null)
                {
                    jo.Add(new JProperty(name, val));
                }
            }
            return jo.ToString();
        }
        /// <summary>
        /// 请确定控件命名规则
        /// </summary>
        /// <typeparam name="T">model的类型</typeparam>
        /// <param name="model">model实体</param>
        /// <param name="e">当前页Request.Form表单</param>
        /// <returns>成功赋值的个数</returns>
        public static bool SetModelValue<T>(T model, NameValueCollection fromTest)
        {
            object NewValue = new object(); //暂时存储一些值
            PropertyInfo[] pifs = typeof(T).GetProperties(); //获取model 所有的属性
            foreach (var p in pifs)
            {
                string ControlNameStr = p.Name.ToString();
                if (fromTest[ControlNameStr] != null) //检查对应的控件是否为空
                {
                    try
                    {
                        NewValue = Convert.ChangeType(fromTest[ControlNameStr], p.PropertyType);//将控件值转化对应属性的值
                        p.SetValue(model, NewValue, null);
                    }
                    catch (Exception)
                    {
                    }
                }
            }
            return true;
        }


        /// <summary>
        /// 返回树数据表格json数据
        /// </summary>
        /// <param name="dt"></param>
        /// <returns></returns>
        public static string GetTreeGridJson(DataTable dt)
        {
            JObject jo = new JObject();
            jo.Add(new JProperty("total", dt.Rows));

            JArray jr = new JArray();
            foreach (DataRow row in dt.Rows)
            {
                JObject jo2 = new JObject();
                for (int a = 0; a < dt.Columns.Count; a++)
                {
                    jo2.Add(new JProperty(dt.Columns[a].ColumnName, row[dt.Columns[a].ColumnName]));
                }
                jr.Add(jo2);
            }
            jo.Add(new JProperty("rows", jr));
            return jo.ToString();
        }
        public static string GetTreeJson(JArray ja, DataRow[] drRoot, DataTable dt, String primaryId, string parentID)
        {
            DataRow[] drChild = { };
            for (int i = 0; i < drRoot.Length; i++)
            {
                string ItemCode = drRoot[i][primaryId].ToString();

                JObject jo = new JObject();
                for (int a = 0; a < dt.Columns.Count; a++)
                {
                    jo.Add(new JProperty(dt.Columns[a].ColumnName, drRoot[i][dt.Columns[a].ColumnName]));
                }
                //子节点
                drChild = dt.Select(string.Format("{0}='{1}'", parentID, ItemCode));
                MakeChildren(jo, dt, drChild, primaryId, parentID);
                ja.Add(jo);
            }
            return ja.ToString();
        }
        private static void MakeChildren(JObject jo, DataTable dt, DataRow[] drChild, String primaryId, string parentID)
        {
            JArray jr = new JArray();
            for (int v = 0; v < drChild.Length; v++)
            {

                JObject joc = new JObject();
                for (int c = 0; c < dt.Columns.Count; c++)
                {
                    joc.Add(new JProperty(dt.Columns[c].ColumnName, drChild[v][dt.Columns[c].ColumnName]));
                }
                jr.Add(joc);

                string ItemCode = drChild[v][primaryId].ToString();
                DataRow[] drChildNext = dt.Select(string.Format("{0}='{1}'", parentID, ItemCode));
                if (drChildNext.Length > 0)
                {
                    MakeChildren(joc, dt, drChildNext, primaryId, parentID);
                }
            }
            if (jr.Count > 0)
            {
                jo.Add(new JProperty("children", jr));
            }
        }
        /// <summary>
        /// 根据表单的值组装条件
        /// eq等于 ne不等于 lt小于 gt大于 le小于等于 ge大于等于 lc左包含 rc右包含 lk包含 begin-end之间
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public static string GetWhere(HttpContext context)
        {
            string where = string.Empty;
            string btField = string.Empty;
            string beginvalue = string.Empty;
            string endvalue = string.Empty;
            NameValueCollection qs = context.Request.Form;
            for (int i = 0; i < qs.Keys.Count; i++)
            {
                string key = qs.Keys[i].ToString();
                string value = Common.Encode.UTF8Decode(qs[key]);
                if (!string.IsNullOrEmpty(value))
                {
                    string field = string.Empty;
                    if (key.StartsWith("eq_"))
                    {
                        field = key.Replace("eq_", "");
                        where += string.Format("and {0} = '{1}' ", field, value);
                    }
                    else if (key.StartsWith("ne_"))
                    {
                        field = key.Replace("ne_", "");
                        where += string.Format("and {0} <> '{1}' ", field, value);
                    }
                    else if (key.StartsWith("lt_"))
                    {
                        field = key.Replace("lt_", "");
                        where += string.Format("and {0} < '{1}' ", field, value);
                    }
                    else if (key.StartsWith("gt_"))
                    {
                        field = key.Replace("gt_", "");
                        where += string.Format("and {0} > '{1}' ", field, value);
                    }
                    else if (key.StartsWith("le_"))
                    {
                        field = key.Replace("le_", "");
                        where += string.Format("and {0} <= '{1}' ", field, value);
                    }
                    else if (key.StartsWith("ge_"))
                    {
                        field = key.Replace("ge_", "");
                        where += string.Format("and {0} >= '{1}' ", field, value);
                    }
                    else if (key.StartsWith("lc_"))
                    {
                        field = key.Replace("lc_", "");
                        where += string.Format("and {0} like '%{1}' ", field, value);
                    }
                    else if (key.StartsWith("rc_"))
                    {
                        field = key.Replace("rc_", "");
                        where += string.Format("and {0} like '{1}%' ", field, value);
                    }
                    else if (key.StartsWith("lk_"))
                    {
                        field = key.Replace("lk_", "");
                        where += string.Format("and {0} like '%{1}%' ", field, value);
                    }
                    else if (key.StartsWith("begin_"))
                    {
                        btField = key.Replace("begin_", "");
                        beginvalue = value;
                    }
                    else if (key.StartsWith("end_"))
                    {
                        btField = key.Replace("end_", "");
                        endvalue = value;
                    }
                }
            }

            if (!string.IsNullOrEmpty(beginvalue) && !string.IsNullOrEmpty(endvalue))
            {
                where += string.Format("and {0} between '{1} 00:00' and '{2} 23:59'", btField, beginvalue, endvalue);
            }
            if (where.StartsWith("and")) where = where.Substring(3);
            return where;
        }

        /// <summary>
        /// 系统属性列表，返回属性表格数据
        /// </summary>
        /// <param name="records">总记录数</param>
        /// <param name="dt">数据列表</param>
        /// <returns></returns>
        public static string GetSysPropertyJson(int records, DataTable dt)
        {
            JObject jo = new JObject();
            jo.Add(new JProperty("total", records));


            JArray jarr = new JArray();
            String[] keys = new String[dt.Rows.Count];
            String[] values = new String[dt.Rows.Count];
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                DataRow row = dt.Rows[i];
                JObject jacc = new JObject();
                for (int j = 0; j < row.ItemArray.Length; j++)
                {
                    String colName = dt.Columns[j].ColumnName;
                    String colValue = row[j].ToString();
                    if ("editor".Equals(colName) && colValue.Contains("options"))
                    {
                        String key = colName + "_" + i;
                        keys[i] = key;
                        values[i] = colValue;
                        jacc.Add(new JProperty(colName, key)); // 以代号为标识
                    }
                    else
                    {
                        jacc.Add(new JProperty(dt.Columns[j].ColumnName, row[j]));
                    }
                }
                jarr.Add(jacc);
            }
            jo.Add(new JProperty("rows", jarr));

            String result = jo.ToString();
            for (int i = 0; i < keys.Length; i++)
            {
                if (null != keys[i] && result.Contains(keys[i]))
                {
                    string key = "\"" + keys[i] + "\"";
                    result = result.Replace(key, values[i]);
                }
            }

            return result;
        }
        /// <summary>
        /// 表格转实体
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="dt"></param>
        /// <returns></returns>
        public static T DtToModel<T>(DataTable dt)
        {
            List<T> list = ToList<T>(dt);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return default(T);
            }
        }
        /// <summary>
        /// 取post表单值
        /// </summary>
        /// <param name="key"></param>
        /// <param name="context"></param>
        /// <returns></returns>
        public static string GetString(string key, HttpContext context)
        {
            string k = string.Empty;
            if (context.Request.Form[key] != null)
            {
                k = context.Request.Form[key].ToString();
            }

            return k;

        }
        /// <summary>
        /// 取地址栏值
        /// </summary>
        /// <param name="key"></param>
        /// <param name="context"></param>
        /// <returns></returns>
        public static string GetQueryString(string key, HttpContext context)
        {
            string k = string.Empty;
            if (context.Request.QueryString[key] != null)
            {
                k = context.Request.QueryString[key].ToString();
            }
            return k;
        }
        /// <summary>
        /// 取post表单数值
        /// </summary>
        /// <param name="key"></param>
        /// <param name="context"></param>
        /// <returns></returns>
        public static int GetInt(string key, HttpContext context)
        {
            int k = 0;
            if (context.Request.Form[key] != null)
            {
                string s = context.Request.Form[key].ToString();
                Int32.TryParse(s, out k);
            }
            return k;
        }
        /// <summary>
        ///取地址栏数值
        /// </summary>
        /// <param name="key"></param>
        /// <param name="context"></param>
        /// <returns></returns>
        public static int GetQueryInt(string key, HttpContext context)
        {
            int k = 0;
            if (context.Request.QueryString[key] != null)
            {
                string s = context.Request.QueryString[key].ToString();
                Int32.TryParse(s, out k);
            }
            return k;
        }
        /// <summary>
        /// 返回分页条
        /// </summary>
        /// <param name="PageID"></param>
        /// <param name="RecordCount"></param>
        /// <param name="PageSize"></param>
        /// <returns></returns>
        public static string GetPageBar(int PageID, int RecordCount, int PageSize)
        {
            Common.PageModel PL = new Common.PageModel();//分页
            PL.PageID = PageID;
            PL.PageSize = PageSize;
            PL.RecordCount = RecordCount;
            Common.PageListHelper h = new PageListHelper();
            return h.GetPageList(PL);
        }
        //Escape编码，同js
        public static string Escape(string str)
        {
            return Microsoft.JScript.GlobalObject.escape(str);
        }
        //UnEscape解码，同js
        public static string UnEscape(string str)
        {
            return Microsoft.JScript.GlobalObject.unescape(str);
        }
        //Guid
        public static string GetGuid()
        {
            return Guid.NewGuid().ToString().Replace("-", string.Empty);
        }
        //流水号
        public static string GetMaxLsh(string lshCode = "")
        {
            string str = DateTime.Now.Year.ToString();
            string str2 = DateTime.Now.Month.ToString().PadLeft(2, '0');
            string str3 = DateTime.Now.Day.ToString().PadLeft(2, '0');
            string format = "Select CurLsh From Sys_Maxlsh Where LshCode='{0}' And CurYear='{1}' And CurMonth='{2}' And CurDay='{3}'";
            string s = "0";
            object single = SqliteHelper.ExecuteScalar(string.Format(format, new object[] { lshCode, str, str2, str3 }));
            if (single != null)
            {
                s = (string)single;
            }
            int num = 0;
            num = int.Parse(s) + 1;
            if (num == 1)
            {
                format = "Insert Into Sys_Maxlsh (LshID,LshCode,CurYear,CurMonth,CurDay,Curlsh) Values('{0}','{1}','{2}','{3}','{4}','0')";
                SqliteHelper.ExecuteNonQuery(string.Format(format, new object[] { GetGuid(), lshCode, str, str2, str3 }));
            }
            s = num.ToString().PadLeft(5, '0');
            format = "  Update Sys_Maxlsh SET CurLsh='{0}'  Where  LshCode='{1}'  And    CurYear='{2}'  And    CurMonth='{3}'  And    CurDay='{4}'";
            SqliteHelper.ExecuteNonQuery(string.Format(format, new object[] { s, lshCode, str, str2, str3 }));
            return (lshCode + str + str2 + str3 + s);
        }
        //系统属性
        public static string GetPropertyByName(string Kind, string PName)
        {
            string reStr = string.Empty;
            string sql = "select PValue from Sys_Properties where Kind=? and PName=?";
            object o = SqliteHelper.ExecuteScalar(sql, "", new object[] { Kind, PName });
            if (o != null)
            {
                reStr = o.ToString();
            }
            return reStr;
        }
        /// <summary>
        /// 取baidu关键字
        /// </summary>
        /// <param name="content">内容</param>
        /// <param name="sp">返回分隔符</param>
        /// <param name="count">提取关键字个数</param>
        /// <returns></returns>
        public static string GetKeyWord(string content, string sp = ",", int count = 4)
        {
            string reStr = string.Empty;
            List<string> list = GetKeyWordArr(content, count);
            for (int i = 0; i < list.Count; i++)
            {
                reStr += list[i] + sp;
            }
            reStr = Common.CFun.DelLastChar(reStr, sp);
            return reStr;
        }
        /// <summary>
        /// 取baidu关键字,返回list
        /// </summary>
        /// <param name="content">内容</param>
        /// <param name="count">返回个数</param>
        /// <returns></returns>
        public static List<string> GetKeyWordArr(string content, int count = 4)
        {
            List<string> listTmp = new List<string>();
            WebClient wc = new WebClient();
            wc.Credentials = CredentialCache.DefaultCredentials;
            wc.Headers.Set("User-Agent", "Microsoft Internet Explorer");//增加的代码
            System.IO.Stream resStream = wc.OpenRead("http://m.baidu.com/s?word=" + content);
            StreamReader sr = new StreamReader(resStream, System.Text.Encoding.UTF8);
            string code = sr.ReadToEnd();
            resStream.Close();

            System.Text.RegularExpressions.Regex paramReg = new System.Text.RegularExpressions.Regex(@"<em>[\s\S]*?</em>", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            System.Text.RegularExpressions.MatchCollection matches = paramReg.Matches(code.ToLower());

            int c = 0;
            foreach (System.Text.RegularExpressions.Match m in matches)
            {

                string val = m.Value.ToLower().Replace("<em>", "").Replace("</em>", "");
                if (!listTmp.Contains(val) && val != content)
                {
                    listTmp.Add(val);
                    c++;
                }

                if (listTmp.Count > count) break;
            }

            if (listTmp.Count == 0) listTmp.Add(content);

            return listTmp;
        }
        #region 提取摘要，是否清除HTML代码
        /// <summary>
        /// 提取摘要，是否清除HTML代码
        /// </summary>
        /// <param name="content"></param>
        /// <param name="length"></param>
        /// <param name="StripHTML">去掉html</param>
        /// <returns></returns>
        public static string GetContentSummary(string content, int length, bool StripHTML)
        {
            if (string.IsNullOrEmpty(content) || length == 0)
                return "";
            if (StripHTML)
            {
                Regex re = new Regex("<[^>]*>");
                content = re.Replace(content, "");
                content = content.Replace("　", "").Replace(" ", "");
                if (content.Length <= length)
                    return content;
                else
                    return content.Substring(0, length) + "……";
            }
            else
            {
                if (content.Length <= length)
                    return content;

                int pos = 0, npos = 0, size = 0;
                bool firststop = false, notr = false, noli = false;
                StringBuilder sb = new StringBuilder();
                while (true)
                {
                    if (pos >= content.Length)
                        break;
                    string cur = content.Substring(pos, 1);
                    if (cur == "<")
                    {
                        string next = content.Substring(pos + 1, 3).ToLower();
                        if (next.IndexOf("p") == 0 && next.IndexOf("pre") != 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                        }
                        else if (next.IndexOf("/p") == 0 && next.IndexOf("/pr") != 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                                sb.Append("<br/>");
                        }
                        else if (next.IndexOf("br") == 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                                sb.Append("<br/>");
                        }
                        else if (next.IndexOf("img") == 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                            {
                                sb.Append(content.Substring(pos, npos - pos));
                                size += npos - pos + 1;
                            }
                        }
                        else if (next.IndexOf("li") == 0 || next.IndexOf("/li") == 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                            {
                                sb.Append(content.Substring(pos, npos - pos));
                            }
                            else
                            {
                                if (!noli && next.IndexOf("/li") == 0)
                                {
                                    sb.Append(content.Substring(pos, npos - pos));
                                    noli = true;
                                }
                            }
                        }
                        else if (next.IndexOf("tr") == 0 || next.IndexOf("/tr") == 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                            {
                                sb.Append(content.Substring(pos, npos - pos));
                            }
                            else
                            {
                                if (!notr && next.IndexOf("/tr") == 0)
                                {
                                    sb.Append(content.Substring(pos, npos - pos));
                                    notr = true;
                                }
                            }
                        }
                        else if (next.IndexOf("td") == 0 || next.IndexOf("/td") == 0)
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            if (size < length)
                            {
                                sb.Append(content.Substring(pos, npos - pos));
                            }
                            else
                            {
                                if (!notr)
                                {
                                    sb.Append(content.Substring(pos, npos - pos));
                                }
                            }
                        }
                        else
                        {
                            npos = content.IndexOf(">", pos) + 1;
                            sb.Append(content.Substring(pos, npos - pos));
                        }
                        if (npos <= pos)
                            npos = pos + 1;
                        pos = npos;
                    }
                    else
                    {
                        if (size < length)
                        {
                            sb.Append(cur);
                            size++;
                        }
                        else
                        {
                            if (!firststop)
                            {
                                sb.Append("...");
                                firststop = true;
                            }
                        }
                        pos++;
                    }

                }
                return sb.ToString();
            }
        }
        #endregion
    }
}
