﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SQLite;
using System.Data;
using System.IO;
using System.Configuration;
using System.Reflection;
using System.Web;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Common
{
    public class SqliteHelper
    {
        public struct DbName
        {
            public static string ShareDB = "";
            public static string ShareSeg = "ShareSeg";
            public static string Robot = "Robot";
            public static string Joke = "Joke";
            public static string Temp = "Temp";
        }


        /// <summary>
        /// 数据库连接
        /// </summary>
        /// <param name="dbName"></param>
        /// <returns></returns>
        public static SQLiteConnection GetSQLiteConnection(string dbName = "")
        {
            try
            {
                //如果配置里面读取不到则直接构建链接字符串
                string path = HttpContext.Current.Server.MapPath(ConfigurationManager.AppSettings[dbName + "Path"].ToString());
                string connStr = string.Format("Data Source={0};Pooling=True", path);
                if (string.IsNullOrEmpty(connStr))
                {
                    connStr = @"Data Source=" + dbName;
                }

                return new SQLiteConnection(connStr);
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// 功能: 创建数据库，带路径
        /// [2013-01-31 15:03 by SST]
        /// </summary>
        /// <param name="dbName"></param>
        public static void CreateDB(string dbName)
        {
            if (!File.Exists(System.Environment.CurrentDirectory + "\\" + dbName))
            {
                SQLiteConnection.CreateFile(System.Environment.CurrentDirectory + "\\" + dbName);
            }
        }
        /// <summary>
        /// 功能: 判断表是否存在
        /// [2013-01-31 15:03 by SST]
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns>存在不存在</returns>
        public static bool IsTableExist(string tableName, string dbName = "")
        {
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                connection.Open();
                using (SQLiteCommand command = new SQLiteCommand(connection))
                {

                    command.CommandText = "SELECT COUNT(*) FROM sqlite_master where type='table' and name='" + tableName + "'";
                    int iaaa = Convert.ToInt32(command.ExecuteScalar());
                    if (Convert.ToInt32(command.ExecuteScalar()) == 0)
                    {
                        return false;
                    }
                    else
                    {
                        return true;
                    }
                }
            }
        }


        /// <summary>        
        /// 返回DataSet        
        /// </summary>        
        /// <param name="sql">The CMD text.</param>        
        /// <param name="p">The p.</param>        
        /// <returns></returns>        
        public static DataSet ExecuteDataset(string sql, string dbName = "", params object[] p)
        {
            DataSet ds = new DataSet();
            SQLiteCommand command = new SQLiteCommand();
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                PrepareCommand(command, connection, sql, p);
                SQLiteDataAdapter da = new SQLiteDataAdapter(command);
                da.Fill(ds);
            }
            return ds;
        }

        /// <summary>        
        /// 返回DataTable    
        /// </summary>        
        /// <param name="sql">The CMD text.</param>        
        /// <param name="p">The p.</param>        
        /// <returns></returns>        
        public static DataTable ExecuteDataTable(string sql, string dbName = "", params object[] p)
        {
            DataTable dt = new DataTable();
            SQLiteCommand command = new SQLiteCommand();
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                PrepareCommand(command, connection, sql, p);
                SQLiteDataAdapter da = new SQLiteDataAdapter(command);
                da.Fill(dt);
            }
            return dt;
        }


        /// <summary>        
        /// 执行SQL 返回受影响的行数        
        /// </summary>        
        /// <param name="sql">a</param>        
        /// <param name="commandParameters">传入的参数</param>        
        /// <returns></returns>        
        public static int ExecuteNonQuery(string sql, string dbName = "", params object[] p)
        {
            SQLiteCommand command = new SQLiteCommand();
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                PrepareCommand(command, connection, sql, p);
                return command.ExecuteNonQuery();
            }
        }
        /// <summary>        
        /// 返回SqlDataReader对象        
        /// </summary>        
        /// <param name="sql"></param>        
        /// <param name="commandParameters">传入的参数</param>        
        /// <returns></returns>        
        public static SQLiteDataReader ExecuteReader(string sql, string dbName = "", params object[] p)
        {
            SQLiteCommand command = new SQLiteCommand();
            SQLiteConnection connection = GetSQLiteConnection(dbName);
            try
            {
                PrepareCommand(command, connection, sql, p);
                SQLiteDataReader reader = command.ExecuteReader(CommandBehavior.CloseConnection);
                return reader;
            }
            catch
            {
                connection.Close();
                throw;
            }
        }
        /// <summary>        
        /// 返回结果集中的第一行第一列，忽略其他行或列        
        /// </summary>        
        /// <param name="sql"></param>        
        /// <param name="commandParameters">传入的参数</param>        
        /// <returns></returns>        
        public static object ExecuteScalar(string sql, string dbName = "", params object[] p)
        {
            SQLiteCommand cmd = new SQLiteCommand();
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                PrepareCommand(cmd, connection, sql, p);
                return cmd.ExecuteScalar();
            }
        }
        /// <summary>
        /// 检测是否存在
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="dbName"></param>
        /// <param name="p"></param>
        /// <returns></returns>
        public static bool Exists(string sql, string dbName = "", params object[] p)
        {
            object o = ExecuteScalar(sql, dbName, p);
            if (o.ToString() != "0")
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 分页返回DataTable
        /// </summary>
        /// <param name="recordCount">返回结果总数</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页条数</param>
        /// <param name="tableName">表名</param>
        /// <param name="colNames">列名</param>
        /// <param name="where">条件</param>
        /// <param name="order">排序</param>
        /// <param name="dbName">数据库</param>
        /// <param name="p">参数</param>
        /// <returns>返回DataTable</returns>
        public static DataTable ExecutePager(ref int recordCount, int pageIndex, int pageSize, string tableName, string colNames, string where, string order, string dbName = "", params object[] p)
        {

            string sqlcount = string.Format("select count(*) from {0} where {1}", tableName, string.IsNullOrEmpty(where) ? "1=1" : where);
            recordCount = int.Parse(ExecuteScalar(sqlcount, dbName, p).ToString());

            string sqlresult = string.Format("select {0} from {1} where {2} order by {3}", colNames, tableName, string.IsNullOrEmpty(where) ? "1=1" : where, string.IsNullOrEmpty(order) ? "1" : order);
            DataSet ds = new DataSet();
            SQLiteCommand command = new SQLiteCommand();
            using (SQLiteConnection connection = GetSQLiteConnection(dbName))
            {
                PrepareCommand(command, connection, sqlresult, p);
                SQLiteDataAdapter da = new SQLiteDataAdapter(command);
                da.Fill(ds, (pageIndex - 1) * pageSize, pageSize, "result");
            }
            if (ds.Tables.Count == 1)
            {
                return ds.Tables[0];
            }
            else
            {
                return null;
            }

        }
        private static void PrepareCommand(SQLiteCommand cmd, SQLiteConnection conn, string sql, params object[] p)
        {
            if (conn.State != ConnectionState.Open)
                conn.Open();
            cmd.Parameters.Clear();
            cmd.Connection = conn;
            cmd.CommandText = sql;
            cmd.CommandType = CommandType.Text;
            cmd.CommandTimeout = 30;
            if (p != null)
            {
                foreach (object parm in p)
                    cmd.Parameters.AddWithValue(string.Empty, parm);
            }
        }
        /// <summary>
        /// 填充对象
        /// </summary>
        /// <typeparam name="T">要填充的对象</typeparam>
        /// <param name="reader">SQLiteDataReader对象</param>
        /// <returns></returns>
        public static List<T> FillEntityFromReader<T>(SQLiteDataReader reader)
        {
            List<T> list = new List<T>();

            while (reader.Read())
            {
                T instance = Activator.CreateInstance<T>();

                foreach (PropertyInfo pinfo in typeof(T).GetProperties())
                {
                    //判断reader是否有此Property中的BoundFieldAttribute所对应需要绑定的字段
                    if (reader.GetSchemaTable().Select("ColumnName='" + pinfo.Name + "'").Length > 0)
                    {
                        int index = reader.GetOrdinal(pinfo.Name);
                        if (reader.GetValue(index) != DBNull.Value)
                        {
                            if (!pinfo.PropertyType.IsEnum)
                            {
                                pinfo.SetValue(instance, Convert.ChangeType(reader.GetValue(index), pinfo.PropertyType), null);
                            }
                            else
                            {
                                pinfo.SetValue(instance, Enum.Parse(pinfo.PropertyType, reader.GetValue(index).ToString()), null);
                            }
                        }
                    }
                }
                list.Add(instance);
            }
            reader.Close();
            return list;
        }

        /// <summary>
        /// 批量删除
        /// </summary>
        /// <param name="table">要删除的表名</param>
        /// <param name="pk">主键</param>
        /// <param name="ids">编号集合</param>
        public static int DelObjectByIds(string table, string pk, string ids, string dbName = "")
        {
            StringBuilder Sql = new StringBuilder("delete from {$table} where {$PK} in({$Ids})");

            Sql = Sql.Replace("{$table}", table).Replace("{$PK}", pk).Replace("{$Ids}", ids);

            return ExecuteNonQuery(Sql.ToString(), dbName);
        }
        /// <summary>
        /// 压缩数据库
        /// </summary>
        /// <param name="dbName"></param>
        /// <returns></returns>
        public static bool VACUUMDB(string dbName = "")
        {
            try
            {
                SQLiteConnection Connection = GetSQLiteConnection(dbName);
                SQLiteCommand cmd = Connection.CreateCommand();
                cmd.CommandText = "VACUUM";
                Connection.Open();
                cmd.ExecuteNonQuery();
                Connection.Close();
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
       

 
        /// <summary>
        /// 根据主键批量删除
        /// </summary>
        /// <param name="table">要删除的表名</param>
        /// <param name="pk">主键列名</param>
        /// <param name="Pks">编号集合，主键是字符串类型时要加单引号，是数值类型不用</param>
        public static int DelObjectByPKs(string table, string pk, string Pks, string dbName = "")
        {
            StringBuilder Sql = new StringBuilder("delete from {$table} where {$PK} in({$Pks})");

            Sql = Sql.Replace("{$table}", table).Replace("{$PK}", pk).Replace("{$Pks}", Pks);

            return ExecuteNonQuery(Sql.ToString(), dbName);
        }
        /// <summary>
        /// 根据主键单个删除
        /// </summary>
        /// <param name="table">表名</param>
        /// <param name="pk">主键列名</param>
        /// <param name="Pk">主键值，主键是字符串类型时要加单引号，是数值类型不用</param>
        /// <returns></returns>
        public static int DelObjectByPK(string table, string pk, string Pk, string dbName = "")
        {
            StringBuilder Sql = new StringBuilder("delete from {$table} where {$PK} ={$Pks}");

            Sql = Sql.Replace("{$table}", table).Replace("{$PK}", pk).Replace("{$Pks}", Pk);

            return ExecuteNonQuery(Sql.ToString(), dbName);
        }
        /// <summary>
        /// 根据主键修改
        /// </summary>
        /// <param name="table">表名</param>
        /// <param name="pk">主键列名</param>
        /// <param name="Pk">主键值，主键是字符串类型时要加单引号，是数值类型不用</param>
        /// <param name="fieldNVs">列名跟更新值</param>
        /// <returns></returns>
        public static int UpdateObjectByPK(string table, string pk, string PkV, string fieldNVs, string dbName = "")
        {
            StringBuilder Sql = new StringBuilder("update  {$table} set {$FieldNVs} where {$PK} ='{$Pks}'");

            Sql = Sql.Replace("{$table}", table).Replace("{$PK}", pk).Replace("{$FieldNVs}", fieldNVs).Replace("{$Pks}", PkV);

            return ExecuteNonQuery(Sql.ToString(), dbName);
        }

        /// <summary>
        ///  上一页|下一页
        /// </summary>
        /// <param name="table">表名</param>
        /// <param name="pk">传进来的主键</param>
        /// <param name="id">主键id</param>
        /// <param name="upOrnext">上一页，n等于下一页，u等于上一页</param>
        /// <returns></returns>
        public static DataTable GetUpOrNextPage(string table, string where, string pk, string id, string upOrnext)
        {
            StringBuilder Sql = new StringBuilder("select * from {$table} where {$PK} {$OP} '{$ID}' and {$where} order by {$PK} {$sort} limit 0,1");

            Sql.Replace("{$table}", table).Replace("{$PK}", pk).Replace("{$ID}", id).Replace("{$where}", string.IsNullOrEmpty(where) ? "1=1" : where);
            if (upOrnext == "n")
            {
                Sql.Replace("{$sort}", "asc").Replace("{$OP}", ">");
            }
            if (upOrnext == "u")
            {
                Sql.Replace("{$sort}", "desc").Replace("{$OP}", "<");
            }
            return ExecuteDataTable(Sql.ToString());
        }
    }
}