﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class ArticleDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(Article model, string dbName = "")
        {

            string sql = "insert into Article(ID,Title,CreateDate,Contents,Author,IsLock,KeyWord,Sort,TypeID,Click,Kind,Introduction) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.ID,
				model.Title,
				model.CreateDate,
				model.Contents,
				model.Author,
				model.IsLock,
				model.KeyWord,
				model.Sort,
				model.TypeID,
				model.Click,
				model.Kind,
				model.Introduction
	        });
            return rst;

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(Article model, string dbName = "")
        {

            string sql = "update Article set Title=?,CreateDate=?,Contents=?,Author=?,IsLock=?,KeyWord=?,Sort=?,TypeID=?,Click=?,Kind=?,Introduction=? where ID = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				  model.Title,
				  model.CreateDate,
				  model.Contents,
				  model.Author,
				  model.IsLock,
				  model.KeyWord,
				  model.Sort,
				  model.TypeID,
				  model.Click,
				  model.Kind,
                  model.Introduction,
				  model.ID});
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string id, string dbName = "")
        {

            string sql = "DELETE FROM Article WHERE ID = ?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { id });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static Article GetModel(string id, string dbName = "")
        {
            string sql = "select ID,Title,CreateDate,Contents,Author,IsLock,KeyWord,Sort,TypeID,Click,Kind,Introduction from Article where ID = ?";
            Article model = new Article();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<Article> list = SqliteHelper.FillEntityFromReader<Article>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "ID,Title,CreateDate,Contents,Author,IsLock,KeyWord,Sort,TypeID,Click,Kind,Introduction" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "Article", colNames, where, order, dbName, p);
            return dt;
        }
        public static DataTable GetComment(string ID, string dbName = "")
        {
            string sql = "SELECT Name,Contents,AddTime FROM Comment where CID=? order by AddTime desc";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql, dbName, new object[] { ID });
            return dt;
        }
        public static Int32 GetTotalPage(string dbName = "")
        {
            Int32 count = 0;
            string sql = "SELECT Count(1) FROM Article where Kind<>'Sys' and IsLock='n'";
            object o = Common.SqliteHelper.ExecuteScalar(sql, dbName, new object[] { });
            if (o != null)count= Common.Encode.ConvertInt32(o);
            return count;
        }
    }
}
