﻿using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using Model;
using System.Data.SQLite;
using Common;

namespace Dal
{
    public class SysRuleDal
    {
        /// <summary>
        /// 添加
        /// </summary>
        public static int Add(SysRule model, string dbName = "")
        {

            string sql = "insert into SysRule(ID,Svalue,Rvalue,Rate,Kind,Mark) values(?,?,?,?,?,?)";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				model.ID,
				model.Svalue,
				model.Rvalue,
				model.Rate,
				model.Kind,
				model.Mark
	        });
            return rst;

        }

        /// <summary>
        /// 修改
        /// </summary>
        public static int Update(SysRule model, string dbName = "")
        {

            string sql = "update SysRule set Svalue=?,Rvalue=?,Rate=?,Kind=?,Mark=? where ID = ?";
            int rst = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] {
				  model.Svalue,
				  model.Rvalue,
				  model.Rate,
				  model.Kind,
				  model.Mark,
				  model.ID});
            return rst;

        }

        /// <summary>
        /// 删除
        /// </summary>
        public static int Delete(string id, string dbName = "")
        {

            string sql = "DELETE FROM SysRule WHERE ID = ?";
            int row = SqliteHelper.ExecuteNonQuery(sql, dbName, new object[] { id });
            return row;

        }

        /// <summary>
        /// 查实体
        /// </summary>
        public static SysRule GetModel(string id, string dbName = "")
        {
            string sql = "select ID,Svalue,Rvalue,Rate,Kind,Mark from SysRule where ID = ?";
            SysRule model = new SysRule();

            SQLiteDataReader reader = SqliteHelper.ExecuteReader(sql, dbName, new object[] { id });
            List<SysRule> list = SqliteHelper.FillEntityFromReader<SysRule>(reader);
            if (list.Count == 1)
            {
                return list[0];
            }
            else
            {
                return null;
            }
        }
		/// <summary>
        /// 分页
        /// </summary>
        public static DataTable GetPageData(ref int recordCount, int pageIndex, int pageSize, string colNames = "", string where = "", string order = "", string dbName = "", params object[] p)
        {
            colNames = string.IsNullOrEmpty(colNames) ? "ID,Svalue,Rvalue,Rate,Kind,Mark" : colNames;
            DataTable dt = SqliteHelper.ExecutePager(ref recordCount, pageIndex, pageSize, "SysRule", colNames, where, order, dbName, p);
            return dt;
        }
    }
}
