﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using System.Collections.Specialized;
using System.Collections;
using System.Web.SessionState;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share.Admin.Account
{
    public class Handler : StoreBase, IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            String src = Common.CFun.GetQueryString("src", context);
            String result = Common.CFun.ResultJson("0", "src error !");
            if ("list".Equals(src))
            {
                result = List(context);
            }
            else if ("save".Equals(src))
            {
                result = Save(context);
            }
            else if ("edit".Equals(src))
            {
                result = GetModel(context);
            }
            else if ("delete".Equals(src))
            {
                result = Delete(context);
            }
            else if ("logout".Equals(src))
            {
                result = Logout(context);
            }
            else if ("ckLogin".Equals(src))
            {
                result = Common.CFun.ResultJson("1","");
            }
            context.Response.Write(result);
        }

        private String Save(HttpContext context)
        {
            string keyField = Common.CFun.GetString("LoginID", context);
            string hdAction = Common.CFun.GetString("hdAction", context);
            int result = 0;
            string pwd = Common.CFun.GetString("LoginPwd", context);


            Model.Account model = AccountBll.GetModel(keyField);
            if (hdAction == "add")
            {
                if (model != null) return Common.CFun.ResultJson("0", "主键重复！");
                if (string.IsNullOrEmpty(pwd)) return Common.CFun.ResultJson("0", "密码不能为空！");

                model = new Model.Account();
                Common.CFun.SetModelValue<Model.Account>(model, context.Request.Form);
                model.LoginPwd = Common.CFun.Encrypt(pwd, "Share");
                result = AccountBll.Add(model);

            }
            else
            {
                Common.CFun.SetModelValue<Model.Account>(model, context.Request.Form);
                if (!string.IsNullOrEmpty(pwd))
                {
                    model.LoginPwd = Common.CFun.Encrypt(pwd, "Share");
                }
                else
                {
                    model.LoginPwd = CurrUser.LoginPwd;
                }
                result = AccountBll.Update(model);
            }

            if (result > 0)
            {
                return Common.CFun.ResultJson("1", "保存成功！");
            }
            else
            {
                return Common.CFun.ResultJson("0", "保存失败！");
            }
        }

        private String Delete(HttpContext context)
        {
            int count = 0;
            String idsStr = Common.CFun.GetString("ids", context);
            string[] ids = idsStr.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {

                int r = AccountBll.Delete(ids[i]);
                if (r > 0)
                {
                    count++;
                }
            }
            return Common.CFun.ResultJson("1", string.Format("删除成功{0}！", count));
        }

        private String GetModel(HttpContext context)
        {
            String id = Common.CFun.GetQueryString("id", context);
            if (!string.IsNullOrEmpty(id))
            {
                Model.Account model = AccountBll.GetModel(id);
                if (model == null) return Common.CFun.ResultJson("0", "对象为空！");
                model.LoginPwd = "";
                return JsonConvert.SerializeObject(model);
            }
            else
            {
                return Common.CFun.ResultJson("0", "参数错误！");
            }
        }

        private String List(HttpContext context)
        {
            int recordCount = 0;
            int pageIndex = Common.CFun.GetInt("page", context);
            int pageSize = Common.CFun.GetInt("rows", context);
            String colNames = "";
            String where = Common.CFun.GetWhere(context);
            String order = Common.CFun.GetString("sort", context) + " " + Common.CFun.GetString("order", context);
            String dbName = "";
            object[] p = { };
            DataTable dt = AccountBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
            String result = Common.CFun.GetPageJson(pageIndex, pageSize, recordCount, dt);
            return result;
        }

        private String Logout(HttpContext context)
        {
            string LoginID = Common.CookieHelper.GetCookie("LoginID");
            if (!string.IsNullOrEmpty(LoginID))
            {
                Common.CookieHelper.RemoveCookie("LoginID");
            };
            return Common.CFun.ResultJson("1", "注销成功！");
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}