﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using System.Collections.Specialized;
using System.Collections;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share.Admin.Article
{
    /// <summary>
    /// HandlerArticle 的摘要说明
    /// </summary>
    public class Handler : StoreBase, IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            String src = Common.CFun.GetQueryString("src", context);
            String result = Common.CFun.ResultJson("0", "src error !");
            if ("list".Equals(src))
            {
                result = List(context);
            }
            else if ("save".Equals(src))
            {
                result = Save(context);
            }
            else if ("edit".Equals(src))
            {
                result = GetModel(context);
            }
            else if ("delete".Equals(src))
            {
                result = Delete(context);
            }
            else if ("delcomment".Equals(src))
            {
                result = Delcomment(context);
            }
            else if (src == "getKeyWord")
            {
                result = GetKeyWord();
            }
            else if (src == "commentlist")
            {
                result = GetCommentList();
            }
            context.Response.Write(result);
        }

        private string Delcomment(HttpContext context)
        {
            int count = 0;
            String idsStr = Common.CFun.GetString("ids", context);
            string[] ids = idsStr.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {

                int r = CommentBll.Delete(ids[i]);
                if (r > 0)
                {
                    count++;
                }
            }
            return Common.CFun.ResultJson("1", string.Format("删除成功{0}！", count));
        }

        private string GetCommentList()
        {
            string id = Common.CFun.GetQueryString("id", HttpContext.Current);
            DataTable dt = CommentBll.GetComment(id, "");
            return Common.CFun.GetPageJson(1, dt.Rows.Count, dt.Rows.Count, dt);
        }

        private String Save(HttpContext context)
        {
            string keyField = Common.CFun.GetString("ID", context);
            string hdAction = Common.CFun.GetString("hdAction", context);
            int result = 0;

            Model.Article model = ArticleBll.GetModel(keyField);
            if (hdAction == "add")
            {
                if (model != null) return Common.CFun.ResultJson("0", "主键重复！");

                model = new Model.Article();
                Common.CFun.SetModelValue<Model.Article>(model, context.Request.Form);
                model.CreateDate = Common.Encode.GetCurDateTime();
                model.IsLock = "n";
                model.Author = CurrUser.NickName;
                model.Introduction = Common.CFun.GetContentSummary(Common.CFun.UnEscape(model.Contents), 300, false);
                result = ArticleBll.Add(model);
            }
            else
            {
                Common.CFun.SetModelValue<Model.Article>(model, context.Request.Form);
                model.Introduction = Common.CFun.GetContentSummary(Common.CFun.UnEscape(model.Contents), 300, false);
                result = ArticleBll.Update(model);
            }

            if (result > 0)
            {
                return Common.CFun.ResultJson("1", "保存成功！");
            }
            else
            {
                return Common.CFun.ResultJson("0", "保存失败！");
            }
        }

        private String Delete(HttpContext context)
        {
            int count = 0;
            String idsStr = Common.CFun.GetString("ids", context);
            string[] ids = idsStr.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {

                int r = ArticleBll.Delete(ids[i]);
                if (r > 0)
                {
                    count++;
                }
            }
            return Common.CFun.ResultJson("1", string.Format("删除成功{0}！", count));
        }

        private String GetModel(HttpContext context)
        {
            Model.Article model = null;
            String id = Common.CFun.GetQueryString("id", context);
            if (!string.IsNullOrEmpty(id))
            {
                model = ArticleBll.GetModel(id);
            }
            if (model == null)
            {
                model = new Model.Article();
                model.ID = Common.CFun.GetMaxLsh("ART");
                return Common.CFun.ObjToJson<Model.Article>(model);
            }
            return JsonConvert.SerializeObject(model);
        }

        private String List(HttpContext context)
        {
            int recordCount = 0;
            int pageIndex = Common.CFun.GetInt("page", context);
            int pageSize = Common.CFun.GetInt("rows", context);
            String colNames = "ID,Title,Author,Click,KeyWord,CreateDate,IsLock,0 PlCount";
            String where = Common.CFun.GetWhere(context);
            String order = Common.CFun.GetString("sort", context) + " " + Common.CFun.GetString("order", context);
            String dbName = "";
            object[] p = { };
            DataTable dt = ArticleBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
            ChangeDt(dt);
            String result = Common.CFun.GetPageJson(pageIndex, pageSize, recordCount, dt);
            return result;
        }

        public void ChangeDt(DataTable dtOld)
        {
            foreach (DataRow row in dtOld.Rows)
            {
                string aid = row["ID"] as string;
                row["PlCount"] = GetComment(aid); // 设置评论数
            }
        }

        public string GetKeyWord()
        {
            string Title = Common.CFun.GetString("Title", HttpContext.Current);
            string reStr = Common.CFun.GetKeyWord(Title);
            return Common.CFun.ResultJson("1", reStr);
        }

        public int GetComment(string id)
        {
            int count = 0;
            DataTable dt = ArticleBll.GetComment(id, "");
            if (dt != null)
            {
                count = dt.Rows.Count;
            }
            return count;
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}