﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using System.Collections.Specialized;
using System.Collections;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share.Admin.SysRule
{
    public class Handler : StoreBase, IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            String src = Common.CFun.GetQueryString("src", context);
            String result = Common.CFun.ResultJson("0", "src error !");
            if ("list".Equals(src))
            {
                result = List(context);
            }
            else if ("save".Equals(src))
            {
                result = Save(context);
            }
            else if ("edit".Equals(src))
            {
                result = GetModel(context);
            }
            else if ("delete".Equals(src))
            {
                result = Delete(context);
            }
            context.Response.Write(result);
        }

        private String Save(HttpContext context)
        {
            string Kind = Common.CFun.GetString("Kind", context);
            String dataGridData = Common.CFun.GetString("dataGridData", context);
            DataTable dt = (DataTable)JsonConvert.DeserializeObject(dataGridData, typeof(DataTable));

            int result = 0;
            try
            {
                string sql = "DELETE FROM SysRule WHERE Kind = ?";
                Common.SqliteHelper.ExecuteNonQuery(sql, "", new object[] { Kind });
                foreach (DataRow row in dt.Rows)
                {
                    Model.SysRule rule = new Model.SysRule();
                    rule.ID = Common.CFun.GetMaxLsh(Kind);
                    rule.Kind = Kind;
                    rule.Rate = 0;
                    rule.Mark = row["Mark"].ToString();
                    rule.Rvalue = row["Rvalue"].ToString();
                    rule.Svalue = Common.Encode.ConvertDouble(row["Svalue"].ToString());
                    result = SysRuleBll.Add(rule);

                }
            }
            catch (Exception ex)
            {
                return Common.CFun.ResultJson("0", ex.Message);
            }

            string msg = result == 0 ? "保存失败！" : "保存成功！";

            return Common.CFun.ResultJson("1", msg);
        }

        private String Delete(HttpContext context)
        {
            int count = 0;
            String idsStr = Common.CFun.GetString("ids", context);
            string[] ids = idsStr.Split(',');
            for (int i = 0; i < ids.Length; i++)
            {

                int r = SysRuleBll.Delete(ids[i]);
                if (r > 0)
                {
                    count++;
                }
            }
            return Common.CFun.ResultJson("1", string.Format("删除成功{0}！", count));
        }

        private String GetModel(HttpContext context)
        {
            Model.SysRule model = null;
            String id = Common.CFun.GetQueryString("id", context);
            if (!string.IsNullOrEmpty(id))
            {
                model = SysRuleBll.GetModel(id);
            }
            if (model == null)
            {
                model = new Model.SysRule();
                model.ID = Common.CFun.GetMaxLsh("TAG");
                return Common.CFun.ObjToJson<Model.SysRule>(model);
            }
            return JsonConvert.SerializeObject(model);
        }

        private String List(HttpContext context)
        {
            int recordCount = 0;
            int pageIndex = Common.CFun.GetInt("page", context);
            int pageSize = Common.CFun.GetInt("rows", context);
            string Kind = Common.CFun.GetQueryString("Kind", context);
            String colNames = "ID,Svalue,Rvalue,Mark";
            String where = Common.CFun.GetWhere(context);
            if (!string.IsNullOrEmpty(where))
            {
                where += " and Kind=? ";
            }
            else
            {
                where = " Kind=? ";
            }
            String order = " Svalue asc";
            String dbName = "";
            object[] p = { Kind };
            DataTable dt = SysRuleBll.GetPageData(ref recordCount, pageIndex, pageSize, colNames, where, order, dbName, p);
            String result = Common.CFun.GetPageJson(pageIndex, pageSize, recordCount, dt);
            return result;
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}