﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Model;
using Bll;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
/**********************************/
//作者：速分享
//地址：http://www.sulianqi.cn
/**********************************/
namespace Share.Admin.Tree
{
    /// <summary>
    /// Handler1 的摘要说明
    /// </summary>
    public class Handler : StoreBase, IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            String src = Common.CFun.GetQueryString("src", context);
            String result = Common.CFun.ResultJson("0", "src error !");
            if ("list".Equals(src))
            {
                result = List(context);
            }
            else if ("list2".Equals(src))
            {
                result = TypeList(context);
            }
            else if ("save".Equals(src))
            {
                result = Save(context);
            }
            else if ("edit".Equals(src))
            {
                result = GetModel(context);
            }
            else if ("delete".Equals(src))
            {
                result = Delete(context);
            }
            else if ("plist".Equals(src))
            {
                result = PropertyList(context);
            }
            else if ("savepro".Equals(src))
            {
                result = UpdatePropertyList(context);
            }
            context.Response.Write(result);
        }


        private String Save(HttpContext context)
        {
            string keyField = Common.CFun.GetString("TypeID", context);
            string hdAction = Common.CFun.GetString("hdAction", context);
            int result = 0;

            Model.SysType sysType = SysTypeBll.GetModel(keyField);
            if (hdAction == "add")
            {
                if (sysType != null) return Common.CFun.ResultJson("0", "主键重复！");
                sysType = new Model.SysType();
                Common.CFun.SetModelValue<Model.SysType>(sysType, context.Request.Form);
                result = SysTypeBll.Add(sysType);
            }
            else
            {
                Common.CFun.SetModelValue<Model.SysType>(sysType, context.Request.Form);
                result = SysTypeBll.Update(sysType);
            }

            if (result > 0)
            {
                return Common.CFun.ResultJson("1", "保存成功！");
            }
            else
            {
                return Common.CFun.ResultJson("0", "保存失败！");
            }
        }

        private String Delete(HttpContext context)
        {

            String idsStr = Common.CFun.GetString("ids", context);
            if (!string.IsNullOrEmpty(idsStr))
            {
                int r = SysTypeBll.Delete(idsStr);
                if (r > 0)
                {
                    return Common.CFun.ResultJson("1", "删除成功！");
                }
                else
                {
                    return Common.CFun.ResultJson("0", "删除失败！");
                }
            }
            else
            {
                return Common.CFun.ResultJson("0", "参数错误！");
            }
        }

        private String GetModel(HttpContext context)
        {
            Model.SysType model = null;
            String id = Common.CFun.GetQueryString("id", context);
            if (!string.IsNullOrEmpty(id))
            {
                model = SysTypeBll.GetModel(id);
            }
            if (model == null)
            {
                model = new Model.SysType();
                model.TypeID = Common.CFun.GetMaxLsh("TYPE");
                return Common.CFun.ObjToJson<Model.SysType>(model);
            }
            return JsonConvert.SerializeObject(model);
        }

        private String List(HttpContext context)
        {
            string Kind = Common.CFun.GetQueryString("Kind", context);
            DataTable dt = Common.SqliteHelper.ExecuteDataTable("select Depth,IsShow,Kind,ParentID,RootID,Sort,TypeID,TypeName from SysType where Kind=?", "", new object[] { Kind });
            JArray ja = new JArray();
            DataRow[] drRoot = dt.Select("ParentID=''");

            Common.CFun.GetTreeJson(ja, drRoot, dt, "TypeID", "ParentID");
            return ja.ToString();
        }

        private String TypeList(HttpContext context)
        {
            string Kind = Common.CFun.GetQueryString("Kind", context);
            DataTable dt = Common.SqliteHelper.ExecuteDataTable("select TypeID as id, TypeName as text, ParentID from SysType where Kind=?", "", new object[] { Kind });
            JArray ja = new JArray();
            DataRow[] drRoot = dt.Select("ParentID=''");

            return Common.CFun.GetTreeJson(ja, drRoot, dt, "id", "ParentID");
        }

        /*
        * 系统属性列表
        **/
        private String PropertyList(HttpContext context)
        {
            String sql = "SELECT PName, PValue as value,PText as name, Kind, editor FROM Sys_Properties";
            DataTable dt = Common.SqliteHelper.ExecuteDataTable(sql);
            JArray ja = new JArray();
            String data = Common.CFun.GetSysPropertyJson(dt.Rows.Count, dt);
            return data;
        }

        /*
         * 修改系统属性列表
         **/
        private String UpdatePropertyList(HttpContext context)
        {
            String properties = Common.CFun.GetString("properties", context);
            DataTable dt = (DataTable)JsonConvert.DeserializeObject(properties, typeof(DataTable));

            int result = 0;
            try
            {
                foreach (DataRow row in dt.Rows)
                {
                    String pName = row["PName"].ToString();
                    String pValue = row["value"].ToString();
                    String kind = row["kind"].ToString();
                    result = ModifyProperty(pName, pValue, kind);
                }
            }
            catch (Exception ex)
            {
                return Common.CFun.ResultJson("0", ex.Message);
            }

            string msg = result == 0 ? "保存失败！" : "保存成功！";

            return Common.CFun.ResultJson("1", msg);
        }

        /*
         * 更新指定属性的值
         **/
        private int ModifyProperty(String pName, String pValue, String kind)
        {
            int result = 0;
            // 获取实体对象，id为组装主键
            Sys_Properties sysProp = Sys_PropertiesBll.GetModel(pName, kind);
            if (null != sysProp)
            {
                sysProp.PValue = pValue;
                result = Sys_PropertiesBll.Update(sysProp);
            }
            return result;
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}