﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="index.aspx.cs" Inherits="Share.Admin.index" %>

<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>【Share Blog】后台管理</title>
    <link href="/js/jquery-easyui-1.3.2/themes/default/easyui.css" rel="stylesheet" type="text/css"
        id="swicth-style" />
    <link href="css/admin.css" rel="stylesheet" type="text/css" />
    <script src="../js/jquery-1.8.0.min.js" type="text/javascript"></script>
    <script src="../js/jquery-easyui-1.3.2/jquery.easyui.min.js" type="text/javascript"></script>
    <script type="text/javascript">


        function tabClose() {
            /*双击关闭TAB选项卡*/
            $(".tabs-inner").dblclick(function () {
                var subtitle = $(this).children(".tabs-closable").text();
                $('#tabs').tabs('close', subtitle);
            })
            /*为选项卡绑定右键*/
            $(".tabs-inner").bind('contextmenu', function (e) {
                $('#mm').menu('show', {
                    left: e.pageX,
                    top: e.pageY
                });

                var subtitle = $(this).children(".tabs-closable").text();

                $('#mm').data("currtab", subtitle);
                $('#tabs').tabs('select', subtitle);
                return false;
            });
        }
        //绑定右键菜单事件
        function tabCloseEven() {
            $('#tabs').bind('contextmenu', function (e) {
                e.preventDefault();
                $('#mm').menu('show', {
                    left: e.pageX,
                    top: e.pageY
                });
            });
            //刷新
            $('#mm-tabupdate').click(function () {
                var currTab = $('#tabs').tabs('getSelected');
                var url = $(currTab.panel('options').content).attr('src');
                if (url != undefined && currTab.panel('options').title != '主页') {
                    refreshTab({ url: url });
                }
            })
            //关闭当前
            $('#mm-tabclose').click(function () {
                var currtab_title = $('#mm').data("currtab");
                $('#tabs').tabs('close', currtab_title);
            })
            //全部关闭
            $('#mm-tabcloseall').click(function () {
                $('.tabs-inner span').each(function (i, n) {
                    var t = $(n).text();
                    if (t != 'Home') {
                        $('#tabs').tabs('close', t);
                    }
                });
            });
            //关闭除当前之外的TAB
            $('#mm-tabcloseother').click(function () {
                var prevall = $('.tabs-selected').prevAll();
                var nextall = $('.tabs-selected').nextAll();
                if (prevall.length > 0) {
                    prevall.each(function (i, n) {
                        var t = $('a:eq(0) span', $(n)).text();
                        if (t != '主页') {
                            $('#tabs').tabs('close', t);
                        }
                    });
                }
                if (nextall.length > 0) {
                    nextall.each(function (i, n) {
                        var t = $('a:eq(0) span', $(n)).text();
                        if (t != '主页') {
                            $('#tabs').tabs('close', t);
                        }
                    });
                }
                return false;
            });
            //关闭当前右侧的TAB
            $('#mm-tabcloseright').click(function () {
                var nextall = $('.tabs-selected').nextAll();
                if (nextall.length == 0) {
                    alert('后边没有啦');
                    return false;
                }
                nextall.each(function (i, n) {
                    var t = $('a:eq(0) span', $(n)).text();
                    $('#tabs').tabs('close', t);
                });
                return false;
            });
            //关闭当前左侧的TAB
            $('#mm-tabcloseleft').click(function () {
                var prevall = $('.tabs-selected').prevAll();
                if (prevall.length == 0) {
                    alert('到头了，前边没有啦');
                    return false;
                }
                prevall.each(function (i, n) {
                    var t = $('a:eq(0) span', $(n)).text();
                    $('#tabs').tabs('close', t);
                });
                return false;
            });

            //退出
            $("#mm-exit").click(function () {
                $('#mm').menu('hide');
            })
        }


        function setCookie(name, value) {
            var Days = 30;
            var exp = new Date();
            exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
            document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
        }

        function getCookie(name) {
            var arr = document.cookie.match(new RegExp("(^| )" + name + "=([^;]*)(;|$)"));
            if (arr != null) return unescape(arr[2]); return null;
        }

        function addTab(title, href) {
            var tt = $('#tabs');
            if (tt.tabs('exists', title)) {
                //如果tab已经存在,则选中并刷新该tab          
                tt.tabs('select', title);
                refreshTab({ tabTitle: title, url: href });
            } else {
                if (href) {
                    var content = '<iframe scrolling="no" frameborder="0"  src="' + href + '" style="width:100%;height:100%;"></iframe>';
                } else {
                    var content = '未实现';
                }
                tt.tabs('add', {
                    title: title,
                    closable: true,
                    content: content
                });
            }
        }
        function refreshTab(cfg) {
            var refresh_tab = cfg.tabTitle ? $('#tabs').tabs('getTab', cfg.tabTitle) : $('#tabs').tabs('getSelected');
            if (refresh_tab && refresh_tab.find('iframe').length > 0) {
                var _refresh_ifram = refresh_tab.find('iframe')[0];
                var refresh_url = cfg.url ? cfg.url : _refresh_ifram.src;
                _refresh_ifram.contentWindow.location.href = refresh_url;
            }
        }
        $(document).ready(function () {
            $(".navleft").click(function () {
                var title = $(this).html();
                var href = $(this).attr("src");
                addTab(title, href);
            });

            tabCloseEven();

            var themes = {
                'gray': '/js/jquery-easyui-1.3.2/themes/gray/easyui.css',
                'black': '/js/jquery-easyui-1.3.2/themes/black/easyui.css',
                'bootstrap': '/js/jquery-easyui-1.3.2/themes/bootstrap/easyui.css',
                'default': '/js/jquery-easyui-1.3.2/themes/default/easyui.css',
                'metro': '/js/jquery-easyui-1.3.2/themes/metro/easyui.css'
            };

            var skins = $('.li-skinitem span').click(function () {
                var $this = $(this);
                if ($this.hasClass('cs-skin-on')) return;
                skins.removeClass('cs-skin-on');
                $this.addClass('cs-skin-on');
                var skin = $this.attr('rel');
                $('#swicth-style').attr('href', themes[skin]);
                setCookie('cs-skin', skin);
            });

            if (getCookie('cs-skin')) {
                var skin = getCookie('cs-skin');
                $('#swicth-style').attr('href', themes[skin]);
                $this = $('.li-skinitem span[rel=' + skin + ']');
                $this.addClass('cs-skin-on');
            }
        });
        function logout() {
            $.post("Account/Handler.ashx?src=logout", { "logoutUser": "currUser" }, function (data) {
                var result = $.parseJSON(data);
                if (result.code == 0) {
                    $.messager.show({ title: '系统提醒', msg: result.msg });
                } else if (result.code == 1) {
                    //window.location = "login.aspx";
                    document.write("<script>window.location = 'login.aspx'<\/script>");
                }
            });
        }
    </script>
</head>
<body class="easyui-layout">
    <div region="north" border="false" class="cs-north" style="height: 55px; background: #3D3C7A">
        <div class="cs-north-bg">
            <div class="cs-north-logo">
                <%=WebName%>
            </div>
            <ul class="ui-skin-nav">
                <li class="li-skinitem" style="width: 150px; height: 18px;"><a href="/" target="_blank"
                    style="color: White;">前台首页</a></li>
                <li class="li-skinitem" style="width: 150px; height: 18px;"><a href="javascript:void(0);"
                    style="color: White;">欢迎您：<%=Account.NickName %></a></li>
                <li class="li-skinitem" style="width: 50px; height: 18px;"><a href="javascript:void(0);"
                    style="color: White;" onclick="logout()">注销</a></li>
                <li class="li-skinitem" title="gray"><span class="gray" rel="gray"></span></li>
                <li class="li-skinitem" title="default"><span class="default" rel="default"></span>
                </li>
                <li class="li-skinitem" title="bootstrap"><span class="bootstrap" rel="bootstrap"></span>
                </li>
                <li class="li-skinitem" title="black"><span class="black" rel="black"></span></li>
                <li class="li-skinitem" title="metro"><span class="metro" rel="metro"></span></li>
            </ul>
        </div>
    </div>
    <div region="west" border="true" split="true" title="" class="cs-west">
        <div class="easyui-accordion" fit="true" border="false">
            <!-- 左边菜单栏 -->
            <%= LeftMenu %>
        </div>
    </div>
    <div id="mainPanle" region="center" border="true" border="false">
        <div id="tabs" class="easyui-tabs" fit="true" border="false">
            <div title="主页">
                <iframe src="Systems/WebInfo.aspx" width="100%" height="500px" scrolling="no" frameborder="0">
                </iframe>
            </div>
        </div>
    </div>
    <div id="mm" class="easyui-menu cs-tab-menu">
        <div id="mm-tabupdate">
            刷新</div>
        <div class="menu-sep">
        </div>
        <div id="mm-tabclose">
            关闭</div>
        <div id="mm-tabcloseother">
            关闭其他</div>
        <div id="mm-tabcloseall">
            关闭全部</div>
    </div>
</body>
</html>
