﻿function OpenSearchForm() {
    $('#dlgSearch').show();
    $('#dlgSearch').dialog({
        buttons: [{
            text: '查询',
            iconCls: 'icon-search',
            handler: function () {
                Search();
            }
        }, {
            text: '取消',
            handler: function () {
                $('#dlg').dialog('close')
            }
        }]
    });
}
function Search() {
    var fstr = $("#dlgSearch input,select").serialize();
    var fs = fstr.split('&');
    var obj;
    var arr = {};
    for (var i = 0; i < fs.length; i++) {
        var kv = fs[i].split('=');
        if (kv.length == 2) {
            arr[kv[0]] = kv[1];
        }
    }
    $('#dlgSearch').dialog('close');
    $('#dg').treegrid('reload', arr);
}
function OpenForm(op) {
    var id = "";
    if (op == "edit") {
        var options = $("#dg").treegrid("options");
        var row = $('#dg').treegrid('getSelected');
        if (row) {
            id = row[options.idField];
        } else {
            $.messager.show({ title: '提示', msg: "请选择一行数据再编辑！" });
            return;
        }
    }
    $('#form1').form('load', 'Handler.ashx?src=edit&id=' + id);

    $('#dlg').show();
    $('#dlg').dialog({
        collapsible: false,
        minimizable: false,
        maximizable: true,
        buttons: [{
            text: '保存',
            iconCls: 'icon-ok',
            handler: function () {
                Save();
            }
        }, {
            text: '取消',
            handler: function () {
                $('#dlg').dialog('close')
            }
        }]
    });
    $("#hdAction").val(op);
}

function Save() {
    $('#form1').form('submit', {
        url: 'Handler.ashx?src=save',
        onSubmit: function () {
            return $(this).form('validate');
        },
        success: function (data) {
            var result = $.parseJSON(data);
            if (result.code == 1) {
                $('#dlg').dialog('close');
                $('#dg').treegrid('reload');
                ClearForm();
            }
            $.messager.show({ title: '提示', msg: result.msg });
        }
    });
}
function ClearForm() {
    //保存不能被清空的值
    var arr = {};
    $(".noclear").each(function () {
        arr[$(this).attr("name")] = $(this).val();
    });
    //清空表单
    $('#form1').form('clear');
    //还原默认值
    $(".noclear").each(function () {
        $(this).val(arr[$(this).attr("name")]);
    });
}
function Delete() {
    var options = $("#dg").treegrid("options");
    var rows = $('#dg').treegrid('getChecked');
    var selectNode = $('#dg').treegrid('getSelected');
    var children = $('#dg').treegrid('getChildren', selectNode[options.idField]);
    if (children.length>0) {
        $.messager.alert('提示', '有子项不能直接删除！');
        return;
    }
    if (!rows || rows.length == 0) {
        $.messager.alert('提示', '请选择要删除的数据');
        return;
    }
    var ids = "";
    $.each(rows, function (i, row) {
        if (i == 0) {
            ids = row[options.idField];
        }
        else {
            ids += "," + row[options.idField];
        }
    });

    $.messager.confirm('提示', '是否删除这些数据?', function (r) {
        if (r) {
            $.post('Handler.ashx?src=delete', { ids: ids, r: Math.random() }, function (result) {
                if (result.code == 1) {
                    $('#dg').treegrid('reload');
                }
                $('#dg').treegrid('clearChecked');
                $.messager.show({ title: '提示', msg: result.msg });
            }, 'json');
        }
    });
}  