﻿

var setting = {
    view: {
        showLine: false,
        showIcon: false,
        selectedMulti: false,
        dblClickExpand: false,
        addDiyDom: addDiyDom
    },

    async: {
        enable: true,
        url: "ajax/get_folder.aspx",
        autoParam: ["id"],
        dataFilter: filter
    },

    callback: {
        onClick: onClick
    }
};




function filter(treeId, parentNode, childNodes) {
    if (!childNodes)
        return null;

    for (var i = 0, l = childNodes.length; i < l; i++) {
        childNodes[i].name = childNodes[i].name.replace(/\.n/g, '.');
    }
    return childNodes;
}


function addDiyDom(treeId, treeNode) {
    var spaceWidth = 5;
    var switchObj = $("#" + treeNode.tId + "_switch"),
    icoObj = $("#" + treeNode.tId + "_ico");
    switchObj.remove();
    icoObj.before(switchObj);

    if (treeNode.level >= 1) {
        var spaceStr = "<span style='display: inline-block;width:" + (spaceWidth * treeNode.level) + "px'></span>";
        switchObj.before(spaceStr);
    }
}






function onClick(event, treeId, treeNode, clickFlag) {
    var id = treeNode.id;
    var vpath = treeNode.vpath;
    var fullpath = treeNode.url.replace("#", "");

    $("#currentid").val(id);
    $("#currentpath").val(vpath);
    $("#currentfullpath").val(fullpath); 
    GetDoc(id, vpath, fullpath);
}





function search() {
    var _id = $("#currentid").val();
    var _vpath = $("#currentpath").val();
    var _fullpath = $("#currentfullpath").val();

    GetDoc(_id, _vpath, _fullpath, null, null, null);
}




/*
id:文件夹ID，例如  5
vpath: 文件夹相对路径，例如 .5.6.7
fullpath 文件夹相对路径名称  例如 /Root/人事部/文档/
curPage:当前页码
recallpaging：重新分页
refresh:是否刷新当前保存页码信息的位置
*/
function GetDoc(id, vpath, fullpath, curPage, recallpaging, refresh) {


    //1. 检查有没有权限

    $.ajax({
        url: "ajax/get_folder_sec.aspx",
        data: { id: id },
        type: "get",
        cache: false,
        async: false,
        success: function (r) {

            if (r == 4) {
                $("#sec").html("<span class=_sec onclick=layer.msg('您可以可以进行任何操作')>管理</a>");
            }

            if (r == 3) {
                $("#sec").html("<span class=_sec onclick=layer.msg('您可以添加、删除文件或者文件夹')>设计</a>");
            }

            if (r == 2) {
                $("#sec").html("<span class=_sec onclick=layer.msg('您可以添加、删除文件但是无权建立、删除子文件夹')>读写</a>");
            }

            if (r == 1) {
                $("#sec").html("<span class=_sec onclick=layer.msg('您可以查看文件')>只读</a>");
            }

            if (r == 0) {
                layer.msg("无权访问此文件夹");
                return;
            }

        }
    });






    if (curPage == undefined || curPage == null) {
        //当前页码
        curPage = 1;
    }

    if (recallpaging == undefined || recallpaging == null) {
        //是否重新分页
        getPaging(id, vpath, fullpath);
    }


    if (refresh != undefined && refresh != null) {
        //存储新位置
        $("#currentid").val(id);
        $("#currentfullpath").val(decodeURI(fullpath));
    }


    $("#currentpath").val(vpath);
     

    fullpath = decodeURI(fullpath);
    BuildMenu(vpath, fullpath);



    var table = $("#fileList");
    table.html('');
    table.append("  <thead> <tr > <th  class=tbl-header width=400>名称</th>  <th  class=tbl-header  width=90px>预览</th> <th  class=tbl-header  width=180>修改时间</th>   <th  class=tbl-header  width=120>上传者</th> <th  class=tbl-header  width=100>大小</th>  <th class=tbl-header width=80px> 版本 </th>  <th width=100px  class=tbl-header >下载次数</th>  </tr> </thead> <tbody>");



    $.ajax({
        url: "ajax/get_folder_and_file.aspx",
        data: { id: id, currentpage: curPage, key: encodeURI($("#txt_key").val()) },
        cache: false,
        dataType: "json",
        success: function (result) {
            var _curUrl = getUrl();
            var temp = "";

            for (index in result) {

                var isfolder = result[index].IsFolder;
                var _folder = isfolder ? "<img src=../javascript/zTree/css/zTreeStyle/img/folder.png> " : "";

                if (isfolder == "1") {
                    var __foldername = result[index].FolderName;
                    var __link = _curUrl + __foldername;
                    var __treeid = result[index].treeid;
                    var __id = result[index].id;
                    var __name = result[index].username;
                    var __date = formatData(result[index].ModifyDate);
                    var __path = result[index].path;

                    temp += "<tr class=tbl-tr data-isfolder=1   >";
                    temp += "<td > <span><a href='#" + __link + "' data-treeid='" + __treeid + "' data-id=" +__id + " data-isfolder=1  onclick=GetDoc(" + __id + ",'" + __path + "','" + encodeURI(__link) + "',null,null,1) >" + _folder + __foldername + " </a> </span>  </td>";
                    temp += "<td class=support>&nbsp;</td>";
                    temp += "<td class=support>" + __date + "</td>";
                    temp += "<td class=support>" + __name + "</td>";
                    temp += "<td class=support></td>";
                    temp += "<td class=support></td>";
                    temp += "<td class=support></td>";
                    temp += "</tr>";
                }
                else {
                    

                    var __filename = result[index].FolderName;
                    var __id = result[index].id;
                    var __treeid = result[index].treeid;
                    var __guid = result[index].guid;
                    var __ext = result[index].Ext;
                    var __link="binn.ashx?id=" + __id + "&guid=" + __guid + "&treeid=" + __treeid;
                    var __date = formatData(result[index].ModifyDate);
                    var __name = result[index].username;
                    var __size = result[index].Size;
                    var __click = result[index].click;


                    temp += "<tr   class=tbl-tr data-isfolder=0   >";

                    temp += "<td title='" + __filename + "'><span>  <a   onclick=addhis(" +__id + ",this)  target=_blank data-id=" + __id + " data-isfolder=0  data-treeid='" +__treeid + "' href='"+__link+"') >" + geticon(result[index].Ext) + " " +__filename + " </a> </span> </td>";


                    if (use_pdf_preview == 0) {
                        temp += "<td class=support>" + getpreview(__ext, __id, __treeid, __guid) ; 
                    }
                    else {
                        temp += "<td class=support>" + getpreview2(__ext, __id, __treeid, __guid);
                    }
                     
                     


                    temp += "<td class=support>" + __date + "</td>";
                    temp += "<td class=support>" + __name + "</td>";
                    temp += "<td class=support>" + __size + " KB</td>";
                    temp += "<td class=support><span onclick=_history('" + __id + "') class=sharefile>历史版本</span></td>";
                    temp += "<td class=support>" + __click+ " 次</td>";
                    temp += "</tr>";
                    

                }


            }



            table.append(temp + "</tbody>");

            $('.bodymain tbody tr').click( function () {
                     $(this).toggleClass("select");
            });
             
        }
    });
}








function BuildMenu(vpath, fullpath) {

    fullpath = decodeURI(fullpath);
    // .1.2.3.
    // vpath=/人事部/招聘/

    var subnav = $("#subnav")

    subnav.html('');

    subnav.append("<li><a href=#  onclick=GetDoc(0,'.0.','/',null,null,1); >Root</a></li>");


    var ids = vpath.split('.');
    var folders = fullpath.split('/');


    var temp = "";

    var _pp = "/";
    var _kk = ".";

    for (var i = 0; i < folders.length; i++) {
        if (folders[i] != "") {

            _pp += folders[i] + "/";
            _kk += ids[i] + ".";

            temp = "<li> <a href='#" + _pp + "' onclick=GetDoc('" + ids[i] + "','" + _kk + "','" + encodeURI(_pp) + "',null,null,1) >" + folders[i] + "</a></li>";

            subnav.append(temp);

        }
    }



}



