/**
* @author wang
* @version 0.01
*/
(function($){  
	$.extend($.fn,{
		//变换BANNER条
		autoBanner:function(options){
			$(this).each(function(){
				var op = $.extend({
					amitElm:"a",//滚动的元素
					height:$(this).height(),//可视区域的高度，默认不用更改
					width:$(this).width(),//同上
					nextBnt:"",//...
					prevBnt:"",//左右按钮的selecter(支持左右按钮);
					changType:"move-Y",//变换方式，move-Y[Y轴方向滚动] ,move-X[X轴方向滚动], alpha[透明度变换]
					mouseType:"click",//左右按钮鼠标触发方式，click , mouserover
					nplay:0,//初始化播放第几个，默认第一个
					autoTime:0,//自动变换时间，<=0 时，不会自动滚动，单位毫秒
					moveSpeed:1000//变换动画效果持续时间，单位毫秒
				},options);
				var St = $(this);
				var len = $(this).find(op.amitElm).css("display","block").length;
				var nplay = op.nplay;
				var oldId = nplay;
				var stopPlay = false;
				if(op.changType === "move-X"){
					$(this).wrapInner("<div style='position:relative; overflow:hidden;'><div style='position:absolute'></div></div>");
					$(this).find("div").eq(0).css({width:op.width+"px", height:op.height+"px"});
					var melem = $(this).find("div").eq(1).css({width:"9999px", height:op.height+"px"});
				}else if(op.changType === "move-Y"){
					$(this).wrapInner("<div style='position:relative; overflow:hidden;'><div style='position:absolute'></div></div>");
					$(this).find("div").eq(0).css({width:op.width+"px", height:op.height+"px"});
					var melem = $(this).find("div").eq(1).css({width:op.width+"px", height:"728px"});
				}else if(op.changType === "alpha"){
					$(this).wrapInner("<div style='position:relative; overflow:hidden;'></div>");
					$(this).find("div").eq(0).css({width:op.width+"px", height:op.height+"px"});
					$(this).find(op.amitElm).css("position","absolute").hide().eq(nplay).show();
				}
				if(op.nextBnt != "" && op.prevBnt != ""){
					$(op.nextBnt).live(op.mouseType,function(){
						if(nplay < len-1){
							nplay++;
						}else{
							nplay = 0;
						}
						moveElm(nplay);
					})
					
					$(op.prevBnt).live(op.mouseType,function(){
						if(nplay > 0){
							nplay--;
						}else{
							nplay = len-1;
						}
						moveElm(nplay)
					})
				}
				$(op.prevBnt+","+op.nextBnt).bind('mouseenter',function(){
					stopPlay = true;
				})
				$(op.prevBnt+","+op.nextBnt).bind('mouseleave',function(){
					stopPlay = false;
				})
				if(op.autoTime > 0) {setInterval(autoMove,op.autoTime)};
				function autoMove(){
					if(stopPlay) return false;
					if(nplay < len-1){nplay++;}else{nplay = 0;}
					moveElm(nplay);
				}
				function moveElm(nid){
					if(op.changType === "move-Y"){
						melem.animate({top:-op.height*nid},op.moveSpeed)
					}else if(op.changType === "move-X"){
						melem.animate({left:-op.width*nid},op.moveSpeed)
					}else if(op.changType === "alpha"){
						St.find(op.amitElm).eq(oldId).fadeOut(op.moveSpeed);
						St.find(op.amitElm).eq(nid).fadeIn(op.moveSpeed);
					}
					oldId = nid;
				}
			});
		},
		//鼠标浮上变颜色:比如常见的table里tr背景色鼠标浮上去变换
		addHover : function(hovClass){
			hovClass = hovClass || "hov";
			return this.each(function(){
				$(this).on("mouseenter", function(){
					$(this).addClass(hovClass);
				});
				$(this).on("mouseleave", function(){
					$(this).removeClass(hovClass);
				});
			})
		},
		//无缝滚动
		only_scorller:function(options){
			$(this).each(function(){
				var op = $.extend({
					refresh:20, //动画刷新间隔
					child: "li",
					duration : 500  //500毫秒
				},options);
				var St = $(this);
				$(this).wrapInner("<div style='overflow:hidden;'><div dcont='1' style='float:left'></div></div>");
				var slen = $(this).find("div[dcont='1']").width();
				var mlen = $(this).find(op.child).outerWidth(true);
				$(this).find("div").eq(0).append("<div dcont='2' style='float:left'></div>").append();
				$(this).find("div[dcont='2']").html($(this).find("div[dcont='1']").html());
				$(this).find("div").eq(0).width(9999);
				var moved = 0;
				if(op.refresh >= 1000){//当速度大于一秒时
					setInterval(function(){  //可以从这改走格。
						St.animate({scrollLeft:St.scrollLeft() + mlen}, op.duration, function(){
							if(St.scrollLeft() >= slen){
								St.scrollLeft(0);
							}
						});
					},op.refresh)
				}else{
					setInterval(function(){  //可以从这改走格。
					  moved +=2;
					  if(slen <= moved){
						  moved = 0;
					  }
					  St.scrollLeft(moved);
					},op.refresh)
				}
				
			})
		},
		//二级下拉菜单，可变化用于多级
		subMenu:function(options){
			return $(this).each(function() {
				var op = $.extend({
					showType:"none",//菜单展示动画，默认没有。alpha【淡入淡出】，slide【向上向下展开】
					showTime:300,//动画变换时间，单位毫秒
					hoverClass:"hov",//菜单鼠标覆盖后的样式
					activeCalss:"act",//子元素激活后的样式,showType为 class 时起效。
					autoHideTime:200,//自动隐藏时间，默认不用更改
					tigger:"",//触发SELECTER
					subBox:""//子元素SELECTER，子元素一定要在触发元素内部！
				},options);
				if(op.tigger == "" || op.subBox == "") return false;
				var cid = 0, enableHide = false, menus = $(this).find("> " + op.tigger);
				menus.each(function(i){$(this).data("mid",i)});
				menus.mouseenter(function(){
					enableHide = false;
					_show(menus.find(">" + op.subBox + ":visible"), false);
					_show($(this).find(">" + op.subBox), true);
					$(this).addClass(op.hoverClass);
				})
				menus.mouseleave(function(){
					enableHide = true;
					_this = $(this);
					_this.removeClass(op.hoverClass);
					if(op.autoHideTime >= 0){
						setTimeout(function(){
							if(enableHide){
								_show(menus.find(">" + op.subBox + ":visible"), false);
							};
						}, op.autoHideTime);
					}
				})
				menus.find(" > " + op.subBox).mouseenter(function(e) {
					enableHide = false;
				});
				function _show(elm, isShow){
					switch(op.showType){
						case "none":
							isShow ? elm.show() : elm.hide();
						break;
						case "alpha":
							isShow ? elm.fadeIn(op.showTime) : elm.fadeout(op.showTime);
						break;
						case "slide":
							isShow ? elm.slideDown(op.showTime) : elm.slideUp(op.showTime);
						break;
						case "class":
							isShow ? elm.addClass(op.activeCalss) : elm.removeClass(op.activeCalss);
						break;
					}
				}
			});
		},
		slideShow:function(actionName, paramArg){
			var action = $.type(actionName) === "string" ? action : "init";
			var param = (action === "init" && $.type(actionName) != "string") ? actionName : paramArg;
			var $this = $(this), plugName = "slideShow";
			var prop = {
				isInit : false, //这是私有属性，不可以加。
				width : 0,//非特殊情况不设置
				height : 0,  //殊情况不设置
				prevBtn : null,  //若有左右按钮，
				nextBtn : null,
				pnBtnMouseType : "click",  //左右按钮触发方式
				controlBar : null,  //下面控制条（123）
				barChild : null, //控制条子元素
				barMouseType:"mouseenter", //控制条触发方式
				barActiveClass:"active",
				enableMouse : true,   //是否允许鼠标方式
				childSelector : "*",  //寻找子集的匹配对象。
				child : null,  //已选择好的子集 （私有属性）
				animateType : "move_x", //动画效果。
				autoPlay: true, //是否自动播放。若false 不了。
				autoDuration : 5000,  //自动播放间隔
				animateSpeed : 500, //动画走动间隔
				changCall: null,
				currId:0 // 私有（默认第几个开始放。）
			}
			prop = $.extend(prop, $this.data(plugName));
			var animateType = {
				move_x:function(mid){
					if(mid === prop.currId) return false;
					if(!prop.enableMouse) return false;
					var _mid = mid === undefined ? (prop.currId + 1) : mid;
					var mv = _mid > prop.currId ? 1 : -1;
					var currElm = prop.child.eq(prop.currId);
					var newElm = prop.child.eq(getCurrId(_mid));
					prop.enableMouse = false;
					newElm.css({"left":prop.width*mv, "display":"block"});
					currElm.animate({"left":-prop.width*mv},prop.animateSpeed, function(){
						currElm.hide();
						prop.enableMouse = true;
					});
					newElm.animate({"left":0},prop.animateSpeed);
				},
				alpha:function(mid){
					if(mid === prop.currId) return false;
					if(!prop.enableMouse) return false;
					var _mid = mid === undefined ? (prop.currId + 1) : mid;
					var mv = _mid > prop.currId ? 1 : -1;
					var currElm = prop.child.eq(prop.currId);
					var newElm = prop.child.eq(getCurrId(_mid));
					prop.enableMouse = false;
					currElm.fadeOut(prop.animateSpeed, function(){
						prop.enableMouse = true;
					});
					newElm.fadeIn(prop.animateSpeed);
				}
			}
			var method = {
				init:function(){
					if(prop.isInit) return false;
					if($.type(param) === "object"){
						prop = $.extend(prop, param);
					}
					prop.isInit = true;
					prop.width = prop.width === 0 ? $this.width() : prop.width;
					prop.height = prop.height === 0 ? $this.height() : prop.height;
					if(prop.childSelector === "*"){
						if($this.find("> ul").length >= 1){
							prop.child = $this.find("> ul > li");
						}else{
							prop.child = $this.find("> *");
						}
					}else{
						prop.child = $this.find("> " + prop.childSelector);
					}
					if(prop.child.length <= 1) return false;
					$this.wrapInner("<div style='position: relative; overflow:hidden; height: "+prop.height+"px; width: "+prop.width+"px;'></div>")
					prop.child.css({ display : "none", position : "absolute", top:0, left:0 });
					if(prop.autoDuration > 0 ){
						method.controlBar(prop.controlBar);
						method.setPNbtn(prop.prevBtn, prop.nextBtn);
						prop.child.eq(getCurrId(prop.currId)).show();
						setInterval(function(){
							if(prop.autoPlay){
								animateType[prop.animateType].call();
							}
						}, prop.autoDuration);
					}
				},
				setPNbtn:function(pbtn, nbtn){
					if(pbtn){
						$(pbtn).on(prop.pnBtnMouseType, function(){
							animateType[prop.animateType].call(null, prop.currId - 1);
						})
					}
					if(nbtn){
						$(nbtn).on(prop.pnBtnMouseType, function(){
							animateType[prop.animateType].call(null, prop.currId + 1);
						})
					}
				},
				controlBar:function(bar){
					if(!bar) return false;
					bar = $(bar);
					var barChild, len = prop.child.length;
					if(bar.find("> ul").length >= 1){
						barChild = bar.find("> ul > li");
					}else{
						barChild = bar.find("> *");
					}
					var clearH = Boolean(barChild.length != len);
					if(clearH) bar.html("");
					for(var i = 0; i < len ; i++){
						if(clearH){
							bar.append("<a aid='"+i+"'><span>"+(i+1)+"</span></a>");
						}else{
							barChild.eq(i).attr("aid", i)
						}
					}
					if(clearH) barChild =  bar.find("> a");
					barChild.eq(prop.currId).addClass(prop.barActiveClass);
					barChild.on(prop.barMouseType,function(){
						if(!prop.enableMouse) return false;
						animateType[prop.animateType].call(null, Number($(this).attr("aid")));
					})
					barChild.on("mouseenter",function(){
						prop.autoPlay = false;
					})
					barChild.on("mouseleave",function(){
						prop.autoPlay = true;
					})
					prop.barChild = barChild;
				}
			}

			function getCurrId(cid){
				var len = prop.child.length - 1;
				if(prop.barChild){
					 prop.barChild.eq(prop.currId).removeClass(prop.barActiveClass);
				}
				if(cid < 0){
					prop.currId =  len;
				}else if(cid > len){
					prop.currId = 0;
				}else{
					prop.currId = cid
				}
				if(prop.barChild){
					 prop.barChild.eq(prop.currId).addClass(prop.barActiveClass);
				}
				if(prop.changCall) prop.changCall.call(prop.child.eq(prop.currId), {oldId:cid, currId:prop.currId, oldTarget:prop.child.eq(cid), currTatget:prop.child.eq(prop.currId)});
				return prop.currId;
			}

			return $(this).each(function(){
				if(!prop.isInit && action != "init"){
					$.error("JQuery插件[slideShow]还未初始化！");
					return $this;
				}
				if(method.hasOwnProperty(action) && $.isFunction(method[action])){
					method[action].apply(null, [param || null]);
					$this.data(plugName, prop);
				}else{
					$.error("JQuery插件[slideShow]的属性或方法[" + action + "]不存在！");
					return $this;
				}
			})
		}
		
		
		
	});

})(jQuery) 