/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private Matcher _preparse_matcher_;
    private Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
        try {
            this._preparse_pattern_ = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    @Override
    public List<String> preParse(List<String> original) {
        NameVersion existing;
        NameVersion nv;
        String version;
        String name;
        MatchResult result;
        String entry;
        original = super.preParse(original);
        HashMap<String, NameVersion> existingEntries = new HashMap<String, NameVersion>();
        ListIterator<String> iter = original.listIterator();
        while (iter.hasNext()) {
            entry = iter.next().trim();
            result = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(entry);
            if (!this._preparse_matcher_.matches()) continue;
            result = this._preparse_matcher_.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            nv = new NameVersion(name, version);
            existing = (NameVersion)existingEntries.get(name);
            if (existing != null && nv.versionNumber < existing.versionNumber) {
                iter.remove();
                continue;
            }
            existingEntries.put(name, nv);
        }
        while (iter.hasPrevious()) {
            entry = iter.previous().trim();
            result = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(entry);
            if (!this._preparse_matcher_.matches()) continue;
            result = this._preparse_matcher_.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            nv = new NameVersion(name, version);
            existing = (NameVersion)existingEntries.get(name);
            if (existing == null || nv.versionNumber >= existing.versionNumber) continue;
            iter.remove();
        }
        return original;
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }

    private static class NameVersion {
        String name;
        int versionNumber;

        NameVersion(String name, String vers) {
            this.name = name;
            this.versionNumber = Integer.parseInt(vers);
        }
    }
}

